/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.log;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Handler;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JSeparator;
import jp.sfjp.jindolf.log.LogPanel;

public class LogFrame
extends JDialog {
    private static final String CMD_CLOSELOG = "CMD_CLOSE_LOG";
    private static final String CMD_CLEARLOG = "CMD_CLEAR_LOG";
    private final LogPanel logPanel = new LogPanel();
    private final JButton clearButton = new JButton("\u30af\u30ea\u30a2");
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");

    public LogFrame(Frame owner) {
        super(owner);
        this.design();
        this.clearButton.setActionCommand(CMD_CLEARLOG);
        this.closeButton.setActionCommand(CMD_CLOSELOG);
        ActionWatcher actionListener = new ActionWatcher();
        this.clearButton.addActionListener(actionListener);
        this.closeButton.addActionListener(actionListener);
        this.setResizable(true);
        this.setLocationByPlatform(true);
        this.setModal(false);
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        content.add((Component)this.logPanel, constraints);
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 5, 5, 5);
        content.add((Component)new JSeparator(), constraints);
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        content.add((Component)this.clearButton, constraints);
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        content.add((Component)this.closeButton, constraints);
    }

    public Handler getHandler() {
        return this.logPanel.getHandler();
    }

    public void clearLog() {
        this.logPanel.clearLog();
    }

    private final class ActionWatcher
    implements ActionListener {
        ActionWatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String cmd = event.getActionCommand();
            if (LogFrame.CMD_CLEARLOG.equals(cmd)) {
                LogFrame.this.clearLog();
            } else if (LogFrame.CMD_CLOSELOG.equals(cmd)) {
                LogFrame.this.setVisible(false);
            }
        }
    }
}

