/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import jp.sourceforge.jindolf.parser.ContentBuilder;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.ShiftJis;

public class ContentBuilderSJ
extends ContentBuilder {
    private static final int DEF_BUF_SZ = 128;
    private boolean hasByte1st;
    private byte byte1st;

    public ContentBuilderSJ() {
        this(128);
    }

    public ContentBuilderSJ(int capacity) throws NegativeArraySizeException {
        super(capacity);
        this.initImpl();
    }

    private void initImpl() {
        this.getContent().init();
        this.hasByte1st = false;
        this.byte1st = 0;
    }

    @Override
    protected void init() {
        this.initImpl();
    }

    @Override
    protected void flushError() {
        if (this.hasByte1st) {
            this.getContent().addDecodeError(this.byte1st);
            this.hasByte1st = false;
        }
    }

    @Override
    public void charContent(CharSequence seq) throws DecodeException {
        this.flushError();
        this.getContent().append(seq);
    }

    @Override
    public void decodingError(byte[] errorArray, int offset, int length) throws DecodeException {
        int limit = offset + length;
        for (int bpos = offset; bpos < limit; ++bpos) {
            byte bval = errorArray[bpos];
            if (!this.hasByte1st) {
                if (ShiftJis.isShiftJIS1stByte(bval)) {
                    this.byte1st = bval;
                    this.hasByte1st = true;
                    continue;
                }
                this.getContent().addDecodeError(bval);
                continue;
            }
            if (ShiftJis.isShiftJIS2ndByte(bval)) {
                this.getContent().addDecodeError(this.byte1st, bval);
                this.hasByte1st = false;
                continue;
            }
            if (ShiftJis.isShiftJIS1stByte(bval)) {
                this.getContent().addDecodeError(this.byte1st);
                this.byte1st = bval;
                this.hasByte1st = true;
                continue;
            }
            this.getContent().addDecodeError(this.byte1st);
            this.getContent().addDecodeError(bval);
            this.hasByte1st = false;
        }
    }
}

