/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.config.AppSetting;
import jp.sfjp.jindolf.config.ConfigStore;
import jp.sfjp.jindolf.config.OptionInfo;
import jp.sfjp.jindolf.data.Anchor;
import jp.sfjp.jindolf.data.DialogPref;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.LandsModel;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.RegexPattern;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.dxchg.CsvExporter;
import jp.sfjp.jindolf.dxchg.Hon5;
import jp.sfjp.jindolf.dxchg.WebIPCDialog;
import jp.sfjp.jindolf.dxchg.WolfBBS;
import jp.sfjp.jindolf.editor.TalkPreview;
import jp.sfjp.jindolf.glyph.AnchorHitEvent;
import jp.sfjp.jindolf.glyph.AnchorHitListener;
import jp.sfjp.jindolf.glyph.Discussion;
import jp.sfjp.jindolf.glyph.FontChooser;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.TalkDraw;
import jp.sfjp.jindolf.log.LogFrame;
import jp.sfjp.jindolf.log.LogUtils;
import jp.sfjp.jindolf.net.ProxyInfo;
import jp.sfjp.jindolf.net.ServerAccess;
import jp.sfjp.jindolf.summary.DaySummary;
import jp.sfjp.jindolf.summary.VillageDigest;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sfjp.jindolf.util.StringUtils;
import jp.sfjp.jindolf.view.AccountPanel;
import jp.sfjp.jindolf.view.ActionManager;
import jp.sfjp.jindolf.view.FilterPanel;
import jp.sfjp.jindolf.view.FindPanel;
import jp.sfjp.jindolf.view.HelpFrame;
import jp.sfjp.jindolf.view.LandsTree;
import jp.sfjp.jindolf.view.OptionPanel;
import jp.sfjp.jindolf.view.PeriodView;
import jp.sfjp.jindolf.view.TabBrowser;
import jp.sfjp.jindolf.view.TopFrame;
import jp.sfjp.jindolf.view.TopView;
import jp.sfjp.jindolf.view.WindowManager;
import jp.sourceforge.jindolf.corelib.VillageState;
import jp.sourceforge.jovsonz.JsObject;

public class Controller
implements ActionListener,
TreeWillExpandListener,
TreeSelectionListener,
ChangeListener,
AnchorHitListener {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private static final String ERRTITLE_LAF = "Look&Feel";
    private static final String ERRFORM_LAF = "\u3053\u306eLook&Feel[{0}]\u3092\u751f\u6210\u3059\u308b\u4e8b\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
    private final LandsModel model;
    private final WindowManager windowManager;
    private final ActionManager actionManager;
    private final AppSetting appSetting;
    private final TopView topView;
    private volatile boolean isBusyNow;

    public Controller(LandsModel model, WindowManager windowManager, ActionManager actionManager, AppSetting setting) {
        this.appSetting = setting;
        this.actionManager = actionManager;
        this.windowManager = windowManager;
        this.model = model;
        this.topView = this.windowManager.getTopFrame().getTopView();
        JToolBar toolbar = this.actionManager.getBrowseToolBar();
        this.topView.setBrowseToolBar(toolbar);
        this.actionManager.addActionListener(this);
        JTree treeView = this.topView.getTreeView();
        treeView.setModel(this.model);
        treeView.addTreeWillExpandListener(this);
        treeView.addTreeSelectionListener(this);
        this.topView.getTabBrowser().addChangeListener(this);
        this.topView.getTabBrowser().addActionListener(this);
        this.topView.getTabBrowser().addAnchorHitListener(this);
        JButton reloadVillageListButton = this.topView.getLandsTree().getReloadVillageListButton();
        reloadVillageListButton.addActionListener(this);
        reloadVillageListButton.setEnabled(false);
        TopFrame topFrame = this.windowManager.getTopFrame();
        TalkPreview talkPreview = this.windowManager.getTalkPreview();
        OptionPanel optionPanel = this.windowManager.getOptionPanel();
        FindPanel findPanel = this.windowManager.getFindPanel();
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        LogFrame logFrame = this.windowManager.getLogFrame();
        AccountPanel accountPanel = this.windowManager.getAccountPanel();
        HelpFrame helpFrame = this.windowManager.getHelpFrame();
        topFrame.setJMenuBar(this.actionManager.getMenuBar());
        this.setFrameTitle(null);
        topFrame.setDefaultCloseOperation(2);
        topFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                Controller.this.shutdown();
            }
        });
        filterPanel.addChangeListener(this);
        Handler newHandler = logFrame.getHandler();
        LogUtils.switchHandler(newHandler);
        ConfigStore config = this.appSetting.getConfigStore();
        JsObject draft = config.loadDraftConfig();
        talkPreview.putJson(draft);
        JsObject history = config.loadHistoryConfig();
        findPanel.putJson(history);
        FontInfo fontInfo = this.appSetting.getFontInfo();
        this.topView.getTabBrowser().setFontInfo(fontInfo);
        talkPreview.setFontInfo(fontInfo);
        optionPanel.getFontChooser().setFontInfo(fontInfo);
        ProxyInfo proxyInfo = this.appSetting.getProxyInfo();
        optionPanel.getProxyChooser().setProxyInfo(proxyInfo);
        DialogPref pref = this.appSetting.getDialogPref();
        this.topView.getTabBrowser().setDialogPref(pref);
        optionPanel.getDialogPrefPanel().setDialogPref(pref);
        accountPanel.setModel(this.model);
        OptionInfo optInfo = this.appSetting.getOptionInfo();
        ConfigStore configStore = this.appSetting.getConfigStore();
        helpFrame.updateVmInfo(optInfo, configStore);
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public TopFrame getTopFrame() {
        TopFrame result = this.windowManager.getTopFrame();
        return result;
    }

    public void submitBusyStatus(final boolean isBusy, final String message) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (isBusy) {
                    Controller.this.setBusy(true);
                }
                if (message != null) {
                    Controller.this.updateStatusBar(message);
                }
                if (!isBusy) {
                    Controller.this.setBusy(false);
                }
            }
        };
        EventQueue.invokeLater(task);
    }

    public void submitLightBusyTask(Runnable task, String beforeMsg, String afterMsg) {
        this.submitBusyStatus(true, beforeMsg);
        EventQueue.invokeLater(task);
        this.submitBusyStatus(false, afterMsg);
    }

    public void submitLightBusyTask(Runnable task, String beforeMsg) {
        String afterMsg = this.topView.getSysMessage();
        this.submitLightBusyTask(task, beforeMsg, afterMsg);
    }

    public void submitHeavyBusyTask(final Runnable heavyTask, String beforeMsg, final String afterMsg) {
        this.submitBusyStatus(true, beforeMsg);
        final Runnable busyManager = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread.yield();
                try {
                    heavyTask.run();
                }
                finally {
                    Controller.this.submitBusyStatus(false, afterMsg);
                }
            }
        };
        Runnable forkLauncher = new Runnable(){

            @Override
            public void run() {
                ExecutorService executor = Executors.newCachedThreadPool();
                executor.execute(busyManager);
            }
        };
        EventQueue.invokeLater(forkLauncher);
    }

    public void submitHeavyBusyTask(Runnable task, String beforeMsg) {
        String afterMsg = this.topView.getSysMessage();
        this.submitHeavyBusyTask(task, beforeMsg, afterMsg);
    }

    private void actionAbout() {
        String message = VerInfo.getAboutMessage();
        JOptionPane pane = new JOptionPane(message, 1, -1, GUIUtils.getLogoIcon());
        JDialog dialog = pane.createDialog(this.getTopFrame(), VerInfo.TITLE + "\u306b\u3064\u3044\u3066");
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    private void actionExit() {
        this.shutdown();
    }

    private void actionHelp() {
        HelpFrame helpFrame = this.windowManager.getHelpFrame();
        this.toggleWindow(helpFrame);
    }

    private void actionShowWebVillage() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL url = server.getVillageURL(village);
        String urlText = url.toString();
        if (village.getState() != VillageState.GAMEOVER) {
            urlText = urlText + "#bottom";
        }
        WebIPCDialog.showDialog(this.getTopFrame(), urlText);
    }

    private void actionShowWebWiki() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        String urlTxt = WolfBBS.getCastGeneratorUrl(village);
        WebIPCDialog.showDialog(this.getTopFrame(), urlTxt);
    }

    private void actionShowWebCast() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        String urlTxt = Hon5.getCastGeneratorUrl(village);
        WebIPCDialog.showDialog(this.getTopFrame(), urlTxt);
    }

    private void actionShowWebDay() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL url = server.getPeriodURL(period);
        String urlText = url.toString();
        if (period.isHot()) {
            urlText = urlText + "#bottom";
        }
        WebIPCDialog.showDialog(this.getTopFrame(), urlText);
    }

    private void actionShowWebTalk() {
        TabBrowser browser = this.topView.getTabBrowser();
        Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Discussion discussion = periodView.getDiscussion();
        Talk talk = discussion.getPopupedTalk();
        if (talk == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL url = server.getPeriodURL(period);
        String urlText = url.toString();
        urlText = urlText + "#" + talk.getMessageID();
        WebIPCDialog.showDialog(this.getTopFrame(), urlText);
    }

    private void actionShowPortal() {
        WebIPCDialog.showDialog(this.getTopFrame(), VerInfo.CONTACT);
    }

    private void warnDialog(String title, String message, Throwable e) {
        LOGGER.log(Level.WARNING, message, e);
        JOptionPane.showMessageDialog(this.getTopFrame(), message, VerInfo.getFrameTitle(title), 2);
    }

    private void actionChangeLaF() {
        LookAndFeel lnf;
        Class<?> lnfClass;
        String className = this.actionManager.getSelectedLookAndFeel();
        try {
            lnfClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            String warnMsg = MessageFormat.format("\u3053\u306eLook&Feel[{0}]\u3092\u8aad\u307f\u8fbc\u3080\u4e8b\u304c\u3067\u304d\u307e\u305b\u3093\u3002", className);
            this.warnDialog(ERRTITLE_LAF, warnMsg, e);
            return;
        }
        try {
            lnf = (LookAndFeel)lnfClass.newInstance();
        }
        catch (InstantiationException e) {
            String warnMsg = MessageFormat.format(ERRFORM_LAF, className);
            this.warnDialog(ERRTITLE_LAF, warnMsg, e);
            return;
        }
        catch (IllegalAccessException e) {
            String warnMsg = MessageFormat.format(ERRFORM_LAF, className);
            this.warnDialog(ERRTITLE_LAF, warnMsg, e);
            return;
        }
        catch (ClassCastException e) {
            String warnMsg = MessageFormat.format(ERRFORM_LAF, className);
            this.warnDialog(ERRTITLE_LAF, warnMsg, e);
            return;
        }
        Runnable lafTask = new Runnable(){

            @Override
            public void run() {
                Controller.this.changeLaF(lnf);
            }
        };
        this.submitLightBusyTask(lafTask, "Look&Feel\u3092\u66f4\u65b0\u4e2d\u2026", "Look&Feel\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f");
    }

    private void changeLaF(LookAndFeel lnf) {
        assert (EventQueue.isDispatchThread());
        try {
            UIManager.setLookAndFeel(lnf);
        }
        catch (UnsupportedLookAndFeelException e) {
            String warnMsg = MessageFormat.format("\u3053\u306eLook&Feel[{0}]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", lnf.getName());
            this.warnDialog(ERRTITLE_LAF, warnMsg, e);
            return;
        }
        this.windowManager.changeAllWindowUI();
        LOGGER.log(Level.INFO, "Look&Feel\u304c[{0}]\u306b\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002", lnf.getName());
    }

    private void actionShowFilter() {
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        this.toggleWindow(filterPanel);
    }

    private void actionShowAccount() {
        AccountPanel accountPanel = this.windowManager.getAccountPanel();
        this.toggleWindow(accountPanel);
    }

    private void actionShowLog() {
        LogFrame logFrame = this.windowManager.getLogFrame();
        this.toggleWindow(logFrame);
    }

    private void actionTalkPreview() {
        TalkPreview talkPreview = this.windowManager.getTalkPreview();
        this.toggleWindow(talkPreview);
    }

    private void actionOption() {
        OptionPanel optionPanel = this.windowManager.getOptionPanel();
        FontInfo fontInfo = this.appSetting.getFontInfo();
        optionPanel.getFontChooser().setFontInfo(fontInfo);
        ProxyInfo proxyInfo = this.appSetting.getProxyInfo();
        optionPanel.getProxyChooser().setProxyInfo(proxyInfo);
        DialogPref dialogPref = this.appSetting.getDialogPref();
        optionPanel.getDialogPrefPanel().setDialogPref(dialogPref);
        optionPanel.setVisible(true);
        if (optionPanel.isCanceled()) {
            return;
        }
        fontInfo = optionPanel.getFontChooser().getFontInfo();
        this.updateFontInfo(fontInfo);
        proxyInfo = optionPanel.getProxyChooser().getProxyInfo();
        this.updateProxyInfo(proxyInfo);
        dialogPref = optionPanel.getDialogPrefPanel().getDialogPref();
        this.updateDialogPref(dialogPref);
    }

    private void updateFontInfo(FontInfo newFontInfo) {
        FontInfo oldInfo = this.appSetting.getFontInfo();
        if (newFontInfo.equals(oldInfo)) {
            return;
        }
        this.appSetting.setFontInfo(newFontInfo);
        this.topView.getTabBrowser().setFontInfo(newFontInfo);
        TalkPreview talkPreview = this.windowManager.getTalkPreview();
        OptionPanel optionPanel = this.windowManager.getOptionPanel();
        FontChooser fontChooser = optionPanel.getFontChooser();
        talkPreview.setFontInfo(newFontInfo);
        fontChooser.setFontInfo(newFontInfo);
    }

    private void updateProxyInfo(ProxyInfo newProxyInfo) {
        ProxyInfo oldProxyInfo = this.appSetting.getProxyInfo();
        if (newProxyInfo.equals(oldProxyInfo)) {
            return;
        }
        this.appSetting.setProxyInfo(newProxyInfo);
        for (Land land : this.model.getLandList()) {
            ServerAccess server = land.getServerAccess();
            server.setProxy(newProxyInfo.getProxy());
        }
    }

    private void updateDialogPref(DialogPref newDialogPref) {
        DialogPref oldDialogPref = this.appSetting.getDialogPref();
        if (newDialogPref.equals(oldDialogPref)) {
            return;
        }
        this.appSetting.setDialogPref(newDialogPref);
        this.topView.getTabBrowser().setDialogPref(newDialogPref);
    }

    private void actionShowDigest() {
        VillageDigest villageDigest;
        TabBrowser browser = this.topView.getTabBrowser();
        final Village village = browser.getVillage();
        if (village == null) {
            return;
        }
        VillageState villageState = village.getState();
        if (villageState != VillageState.EPILOGUE && villageState != VillageState.GAMEOVER || !village.isValid()) {
            String message = "\u30a8\u30d4\u30ed\u30fc\u30b0\u3092\u6b63\u5e38\u306b\u8fce\u3048\u3066\u3044\u306a\u3044\u6751\u306f\n\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u6a5f\u80fd\u3092\u5229\u7528\u3067\u304d\u307e\u305b\u3093";
            String title = VerInfo.getFrameTitle("\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u4e0d\u53ef");
            JOptionPane pane = new JOptionPane(message, 2, -1);
            JDialog dialog = pane.createDialog(this.getTopFrame(), title);
            dialog.pack();
            dialog.setVisible(true);
            dialog.dispose();
            return;
        }
        final VillageDigest digest = villageDigest = this.windowManager.getVillageDigest();
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                Controller.this.taskFullOpenAllPeriod();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        digest.setVillage(village);
                        digest.setVisible(true);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskFullOpenAllPeriod() {
        this.setBusy(true);
        this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u958b\u59cb");
        try {
            TabBrowser browser = this.topView.getTabBrowser();
            Village village = browser.getVillage();
            if (village == null) {
                return;
            }
            for (PeriodView periodView : browser.getPeriodViewList()) {
                Period period = periodView.getPeriod();
                if (period == null || period.isFullOpen()) continue;
                String message = period.getDay() + "\u65e5\u76ee\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059";
                this.updateStatusBar(message);
                try {
                    Period.parsePeriod(period, true);
                }
                catch (IOException e) {
                    this.showNetworkError(village, e);
                    this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    this.setBusy(false);
                    return;
                }
                periodView.showTopics();
            }
        }
        finally {
            this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
            this.setBusy(false);
        }
    }

    private void actionShowFind() {
        FindPanel findPanel = this.windowManager.getFindPanel();
        findPanel.setVisible(true);
        if (findPanel.isCanceled()) {
            this.updateFindPanel();
            return;
        }
        if (findPanel.isBulkSearch()) {
            this.bulkSearch();
        } else {
            this.regexSearch();
        }
    }

    private void regexSearch() {
        Pattern pattern;
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        FindPanel findPanel = this.windowManager.getFindPanel();
        RegexPattern regPattern = findPanel.getRegexPattern();
        int hits = discussion.setRegexPattern(regPattern);
        String hitMessage = "\uff3b" + hits + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f";
        this.updateStatusBar(hitMessage);
        String loginfo = "";
        if (regPattern != null && (pattern = regPattern.getPattern()) != null) {
            loginfo = "\u6b63\u898f\u8868\u73fe " + pattern.pattern() + " \u306b";
        }
        loginfo = loginfo + hitMessage;
        LOGGER.info(loginfo);
    }

    private void bulkSearch() {
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                Controller.this.taskBulkSearch();
            }
        });
    }

    private void taskBulkSearch() {
        Pattern pattern;
        this.taskLoadAllPeriod();
        int totalhits = 0;
        FindPanel findPanel = this.windowManager.getFindPanel();
        RegexPattern regPattern = findPanel.getRegexPattern();
        StringBuilder hitDesc = new StringBuilder();
        TabBrowser browser = this.topView.getTabBrowser();
        for (PeriodView periodView : browser.getPeriodViewList()) {
            Discussion discussion = periodView.getDiscussion();
            int hits = discussion.setRegexPattern(regPattern);
            totalhits += hits;
            if (hits <= 0) continue;
            Period period = discussion.getPeriod();
            hitDesc.append(' ').append(period.getDay()).append("d:");
            hitDesc.append(hits).append("\u4ef6");
        }
        String hitMessage = "\uff3b" + totalhits + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002" + hitDesc.toString();
        this.updateStatusBar(hitMessage);
        String loginfo = "";
        if (regPattern != null && (pattern = regPattern.getPattern()) != null) {
            loginfo = "\u6b63\u898f\u8868\u73fe " + pattern.pattern() + " \u306b";
        }
        loginfo = loginfo + hitMessage;
        LOGGER.info(loginfo);
    }

    private void updateFindPanel() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        RegexPattern pattern = discussion.getRegexPattern();
        FindPanel findPanel = this.windowManager.getFindPanel();
        findPanel.setRegexPattern(pattern);
    }

    private void actionDaySummary() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        DaySummary daySummary = this.windowManager.getDaySummary();
        daySummary.summaryPeriod(period);
        daySummary.setVisible(true);
    }

    private void actionDayExportCsv() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        File file = CsvExporter.exportPeriod(period, filterPanel);
        if (file != null) {
            String message = "CSV\u30d5\u30a1\u30a4\u30eb(" + file.getName() + ")\u3078\u306e\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f";
            this.updateStatusBar(message);
        }
    }

    private void actionSearchNext() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.nextHotTarget();
    }

    private void actionSearchPrev() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.prevHotTarget();
    }

    private void actionReloadPeriod() {
        this.updatePeriod(true);
        TabBrowser tabBrowser = this.topView.getTabBrowser();
        Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        if (village.getState() != VillageState.EPILOGUE) {
            return;
        }
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        Period period = discussion.getPeriod();
        if (period == null) {
            return;
        }
        if (period.getTopics() > 1000) {
            JOptionPane.showMessageDialog(this.getTopFrame(), "\u30a8\u30d4\u30ed\u30fc\u30b0\u304c1000\u767a\u8a00\u3092\u8d85\u3048\u306f\u3058\u3081\u305f\u3089\u3001\n\u8ca0\u8377\u5bfe\u7b56\u306e\u305f\u3081Web\u30d6\u30e9\u30a6\u30b6\u306b\u3088\u308b\u30a2\u30af\u30bb\u30b9\u3092\u5fc3\u304c\u3051\u307e\u3057\u3087\u3046", "\u9577\u5927\u30a8\u30d4\u30ed\u30fc\u30b0\u8b66\u544a", 2);
        }
    }

    private void actionLoadAllPeriod() {
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                Controller.this.taskLoadAllPeriod();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskLoadAllPeriod() {
        this.setBusy(true);
        this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u958b\u59cb");
        try {
            TabBrowser browser = this.topView.getTabBrowser();
            Village village = browser.getVillage();
            if (village == null) {
                return;
            }
            for (PeriodView periodView : browser.getPeriodViewList()) {
                Period period = periodView.getPeriod();
                if (period == null) continue;
                String message = period.getDay() + "\u65e5\u76ee\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059";
                this.updateStatusBar(message);
                try {
                    Period.parsePeriod(period, false);
                }
                catch (IOException e) {
                    this.showNetworkError(village, e);
                    this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    this.setBusy(false);
                    return;
                }
                periodView.showTopics();
            }
        }
        finally {
            this.updateStatusBar("\u4e00\u62ec\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
            this.setBusy(false);
        }
    }

    private void actionReloadVillageList() {
        JTree tree = this.topView.getTreeView();
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Land land = null;
        for (int ct = 0; ct < path.getPathCount(); ++ct) {
            Object obj = path.getPathComponent(ct);
            if (!(obj instanceof Land)) continue;
            land = (Land)obj;
            break;
        }
        if (land == null) {
            return;
        }
        this.topView.showInitPanel();
        this.submitReloadVillageList(land);
    }

    private void actionCopySelected() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence copied = discussion.copySelected();
        if (copied == null) {
            return;
        }
        copied = StringUtils.suppressString(copied);
        this.updateStatusBar("[" + copied + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private void actionCopyTalk() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence copied = discussion.copyTalk();
        if (copied == null) {
            return;
        }
        copied = StringUtils.suppressString(copied);
        this.updateStatusBar("[" + copied + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private void actionJumpAnchor() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Discussion discussion = periodView.getDiscussion();
        final TabBrowser browser = this.topView.getTabBrowser();
        final Village village = browser.getVillage();
        final Anchor anchor = discussion.getPopupedAnchor();
        if (anchor == null) {
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u30b8\u30e3\u30f3\u30d7\u5148\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                if (anchor.hasTalkNo()) {
                    Controller.this.taskLoadAllPeriod();
                }
                try {
                    List<Talk> talkList = village.getTalkListFromAnchor(anchor);
                    if (talkList == null || talkList.size() <= 0) {
                        Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u30b8\u30e3\u30f3\u30d7\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                        return;
                    }
                    final Talk targetTalk = talkList.get(0);
                    final Period targetPeriod = targetTalk.getPeriod();
                    final int tabIndex = targetPeriod.getDay() + 1;
                    final PeriodView target = browser.getPeriodView(tabIndex);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            browser.setSelectedIndex(tabIndex);
                            target.setPeriod(targetPeriod);
                            target.scrollToTalk(targetTalk);
                        }
                    });
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc[" + anchor.toString() + "]\u306b\u30b8\u30e3\u30f3\u30d7\u3057\u307e\u3057\u305f");
                }
                catch (IOException e) {
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u307e\u3057\u305f");
                }
                finally {
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void submitReloadVillageList(final Land land) {
        Runnable heavyTask = new Runnable(){

            @Override
            public void run() {
                Controller.this.taskReloadVillageList(land);
            }
        };
        this.submitHeavyBusyTask(heavyTask, "\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026", "\u6751\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
    }

    private void taskReloadVillageList(Land land) {
        SortedSet<Village> villageList;
        try {
            villageList = land.downloadVillageList();
        }
        catch (IOException e) {
            this.showNetworkError(land, e);
            return;
        }
        land.updateVillageList(villageList);
        this.model.updateVillageList(land);
        LandsTree treePanel = this.topView.getLandsTree();
        treePanel.expandLand(land);
    }

    private void updatePeriod(final boolean force) {
        final TabBrowser tabBrowser = this.topView.getTabBrowser();
        final Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        this.setFrameTitle(village.getVillageFullName());
        final PeriodView periodView = this.currentPeriodView();
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        discussion.setTopicFilter(filterPanel);
        final Period period = discussion.getPeriod();
        if (period == null) {
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Controller.this.setBusy(true);
                try {
                    boolean wasHot = this.loadPeriod();
                    if (wasHot && !period.isHot() && !this.updatePeriodList()) {
                        return;
                    }
                    this.renderBrowser();
                }
                finally {
                    Controller.this.setBusy(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadPeriod() {
                boolean wasHot;
                Controller.this.updateStatusBar("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059\u2026");
                try {
                    wasHot = period.isHot();
                    try {
                        Period.parsePeriod(period, force);
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(village, e);
                    }
                }
                finally {
                    Controller.this.updateStatusBar("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f");
                }
                return wasHot;
            }

            private boolean updatePeriodList() {
                Controller.this.updateStatusBar("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u3066\u3044\u307e\u3059\u2026");
                try {
                    Village.updateVillage(village);
                }
                catch (IOException e) {
                    Controller.this.showNetworkError(village, e);
                    return false;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            tabBrowser.setVillage(village);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    LOGGER.log(Level.SEVERE, "\u30bf\u30d6\u64cd\u4f5c\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "\u30bf\u30d6\u64cd\u4f5c\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                }
                Controller.this.updateStatusBar("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u307e\u3057\u305f\u2026");
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void renderBrowser() {
                Controller.this.updateStatusBar("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u4e2d\u2026");
                try {
                    final int lastPos = periodView.getVerticalPosition();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                periodView.showTopics();
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        LOGGER.log(Level.SEVERE, "\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.SEVERE, "\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            periodView.setVerticalPosition(lastPos);
                        }
                    });
                }
                finally {
                    Controller.this.updateStatusBar("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u5b8c\u4e86");
                }
            }
        });
    }

    private void filterChanged() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        FilterPanel filterPanel = this.windowManager.getFilterPanel();
        discussion.setTopicFilter(filterPanel);
        discussion.filtering();
    }

    private PeriodView currentPeriodView() {
        TabBrowser tb = this.topView.getTabBrowser();
        PeriodView result = tb.currentPeriodView();
        return result;
    }

    private Discussion currentDiscussion() {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return null;
        }
        Discussion result = periodView.getDiscussion();
        return result;
    }

    private void toggleWindow(Window window) {
        if (window == null) {
            return;
        }
        if (window instanceof Frame) {
            boolean isIconified;
            Frame frame = (Frame)window;
            int winState = frame.getExtendedState();
            boolean bl = isIconified = (winState & 1) != 0;
            if (isIconified) {
                frame.setExtendedState(winState &= 0xFFFFFFFE);
                frame.setVisible(true);
                return;
            }
        }
        if (window.isVisible()) {
            window.setVisible(false);
            window.dispose();
        } else {
            window.setVisible(true);
        }
    }

    public void showNetworkError(Village village, IOException e) {
        Land land = village.getParentLand();
        this.showNetworkError(land, e);
    }

    public void showNetworkError(Land land, IOException e) {
        LOGGER.log(Level.WARNING, "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u3067\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        ServerAccess server = land.getServerAccess();
        String message = land.getLandDef().getLandName() + "\u3092\u904b\u55b6\u3059\u308b\u30b5\u30fc\u30d0\u3068\u306e\u9593\u306e\u901a\u4fe1\u3067" + "\u4f55\u3089\u304b\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n" + "\u76f8\u624b\u30b5\u30fc\u30d0\u306eURL\u306f [ " + server.getBaseURL() + " ] \u3060\u3088\u3002\n" + "\u30d7\u30ed\u30af\u30b7\u8a2d\u5b9a\u306f\u6b63\u3057\u3044\u304b\u306a\uff1f\n" + "Web\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u904a\u3079\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u307f\u3066\u306d!\n";
        JOptionPane pane = new JOptionPane(message, 2, -1);
        String title = VerInfo.getFrameTitle("\u901a\u4fe1\u7570\u5e38\u767a\u751f");
        JDialog dialog = pane.createDialog(this.getTopFrame(), title);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        Object selObj = path.getLastPathComponent();
        if (selObj instanceof Land) {
            Land land = (Land)selObj;
            this.setFrameTitle(land.getLandDef().getLandName());
            this.topView.showLandInfo(land);
            this.actionManager.appearVillage(false);
            this.actionManager.appearPeriod(false);
        } else if (selObj instanceof Village) {
            final Village village = (Village)selObj;
            ExecutorService executor = Executors.newCachedThreadPool();
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Controller.this.setBusy(true);
                    Controller.this.updateStatusBar("\u6751\u60c5\u5831\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                    try {
                        Village.updateVillage(village);
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(village, e);
                        return;
                    }
                    finally {
                        Controller.this.updateStatusBar("\u6751\u60c5\u5831\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                        Controller.this.setBusy(false);
                    }
                    Controller.this.actionManager.appearVillage(true);
                    Controller.this.setFrameTitle(village.getVillageFullName());
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Controller.this.topView.showVillageInfo(village);
                        }
                    });
                }
            });
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.windowManager.getFilterPanel()) {
            this.filterChanged();
        } else if (source instanceof TabBrowser) {
            this.updateFindPanel();
            this.updatePeriod(false);
            PeriodView periodView = this.currentPeriodView();
            if (periodView == null) {
                this.actionManager.appearPeriod(false);
            } else {
                this.actionManager.appearPeriod(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isBusyNow) {
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("ACCOUNT")) {
            this.actionShowAccount();
        } else if (cmd.equals("EXIT")) {
            this.actionExit();
        } else if (cmd.equals("COPY")) {
            this.actionCopySelected();
        } else if (cmd.equals("SHOWFIND")) {
            this.actionShowFind();
        } else if (cmd.equals("SEARCHNEXT")) {
            this.actionSearchNext();
        } else if (cmd.equals("SEARCHPREV")) {
            this.actionSearchPrev();
        } else if (cmd.equals("ALLPERIOD")) {
            this.actionLoadAllPeriod();
        } else if (cmd.equals("DIGEST")) {
            this.actionShowDigest();
        } else if (cmd.equals("WEBVILL")) {
            this.actionShowWebVillage();
        } else if (cmd.equals("WEBWIKI")) {
            this.actionShowWebWiki();
        } else if (cmd.equals("WEBCAST")) {
            this.actionShowWebCast();
        } else if (cmd.equals("RELOAD")) {
            this.actionReloadPeriod();
        } else if (cmd.equals("DAYSUMMARY")) {
            this.actionDaySummary();
        } else if (cmd.equals("DAYEXPCSV")) {
            this.actionDayExportCsv();
        } else if (cmd.equals("WEBDAY")) {
            this.actionShowWebDay();
        } else if (cmd.equals("OPTION")) {
            this.actionOption();
        } else if (cmd.equals("LANDF")) {
            this.actionChangeLaF();
        } else if (cmd.equals("SHOWFILT")) {
            this.actionShowFilter();
        } else if (cmd.equals("SHOWEDIT")) {
            this.actionTalkPreview();
        } else if (cmd.equals("SHOWLOG")) {
            this.actionShowLog();
        } else if (cmd.equals("HELPDOC")) {
            this.actionHelp();
        } else if (cmd.equals("SHOWPORTAL")) {
            this.actionShowPortal();
        } else if (cmd.equals("ABOUT")) {
            this.actionAbout();
        } else if (cmd.equals("VILLAGELIST")) {
            this.actionReloadVillageList();
        } else if (cmd.equals("COPYTALK")) {
            this.actionCopyTalk();
        } else if (cmd.equals("JUMPANCHOR")) {
            this.actionJumpAnchor();
        } else if (cmd.equals("WEBTALK")) {
            this.actionShowWebTalk();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        if (!(event.getSource() instanceof JTree)) {
            return;
        }
        TreePath path = event.getPath();
        Object lastObj = path.getLastPathComponent();
        if (!(lastObj instanceof Land)) {
            return;
        }
        Land land = (Land)lastObj;
        if (land.getVillageCount() > 0) {
            return;
        }
        this.submitReloadVillageList(land);
    }

    @Override
    public void anchorHitted(AnchorHitEvent event) {
        PeriodView periodView = this.currentPeriodView();
        if (periodView == null) {
            return;
        }
        Period period = periodView.getPeriod();
        if (period == null) {
            return;
        }
        final Village village = period.getVillage();
        final TalkDraw talkDraw = event.getTalkDraw();
        final Anchor anchor = event.getAnchor();
        final Discussion discussion = periodView.getDiscussion();
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Controller.this.setBusy(true);
                Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u2026");
                if (anchor.hasTalkNo()) {
                    Controller.this.taskLoadAllPeriod();
                }
                try {
                    final List<Talk> talkList = village.getTalkListFromAnchor(anchor);
                    if (talkList == null || talkList.size() <= 0) {
                        Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            talkDraw.showAnchorTalks(anchor, talkList);
                            discussion.layoutRows();
                        }
                    });
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc[" + anchor.toString() + "]\u306e\u5c55\u958b\u5b8c\u4e86");
                }
                catch (IOException e) {
                    Controller.this.updateStatusBar("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u307e\u3057\u305f");
                }
                finally {
                    Controller.this.setBusy(false);
                }
            }
        });
    }

    private void setBusy(final boolean isBusy) {
        this.isBusyNow = isBusy;
        Runnable microJob = new Runnable(){

            @Override
            public void run() {
                Cursor cursor = isBusy ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
                Component glass = Controller.this.getTopFrame().getGlassPane();
                glass.setCursor(cursor);
                glass.setVisible(isBusy);
                Controller.this.topView.setBusy(isBusy);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            microJob.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(microJob);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "\u30d3\u30b8\u30fc\u51e6\u7406\u3067\u5931\u6557", e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "\u30d3\u30b8\u30fc\u51e6\u7406\u3067\u5931\u6557", e);
            }
        }
    }

    private void updateStatusBar(String message) {
        this.topView.updateSysMessage(message);
    }

    private void setFrameTitle(String name) {
        String title = VerInfo.getFrameTitle(name);
        TopFrame topFrame = this.windowManager.getTopFrame();
        topFrame.setTitle(title);
    }

    private void shutdown() {
        JsObject draftConf;
        TalkPreview talkPreview;
        JsObject findConf;
        ConfigStore configStore = this.appSetting.getConfigStore();
        FindPanel findPanel = this.windowManager.getFindPanel();
        if (!findPanel.hasConfChanged(findConf = findPanel.getJson())) {
            configStore.saveHistoryConfig(findConf);
        }
        if (!(talkPreview = this.windowManager.getTalkPreview()).hasConfChanged(draftConf = talkPreview.getJson())) {
            configStore.saveDraftConfig(draftConf);
        }
        this.appSetting.saveConfig();
        LOGGER.info("VM\u3054\u3068\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
        System.exit(0);
        assert (false);
    }
}

