/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import jp.sfjp.jindolf.JindolfMain;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.VerInfo;

public final class JindolfJre17 {
    public static final int EXIT_CODE_HEADLESS = 1;
    public static final int EXIT_CODE_BUILDMISS = 1;
    public static final int EXIT_CODE_INVOKEDBL = 1;
    private static final PrintStream STDERR = System.err;
    private static final String ERRMSG_GUISESS = "ERROR : GUI session failed.";
    private static final String ERRMSG_DISPLAY = "{0}\nEnvironment: DISPLAY [{1}]";
    private static final String TITLE_SRCENC = "Build failed";
    private static final String ERRMSG_SRCENC = "ERROR : Invalid source-code encoding detected.\nLet's check encoding with compiler & source-file.";
    private static final String TITLE_PKGERR = "\u30d3\u30eb\u30c9\u30a8\u30e9\u30fc";
    private static final String ERRMSG_PKG = "\u30d1\u30c3\u30b1\u30fc\u30b8\u5b9a\u7fa9\u3068{0}\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002[{1}]\u2260[{2}]";
    private static final String TITLE_INVOKEDBL = "\u591a\u91cd\u8d77\u52d5";
    private static final String ERRMSG_INVOKEDBL = "ERROR : \u4e8c\u5ea6\u76ee\u4ee5\u964d\u306e\u8d77\u52d5\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002";
    private static final char[][] ENCODING_TEST = new char[][]{{'\u72fc', '\u72fc'}, {'\u3000', '\u3000'}, {'\\', '\\'}, {'\u00a5', '\u00a5'}, {'~', '~'}, {'\uff5e', '\uff5e'}, {'\u301c', '\u301c'}, {'\ufffd', '\ufffd'}};
    private static final AtomicBoolean INVOKE_FLAG = new AtomicBoolean(false);

    private JindolfJre17() {
        assert (false);
    }

    private static int proveGuiEnv() {
        String dispEnv;
        if (!GraphicsEnvironment.isHeadless()) {
            return 0;
        }
        String errMsg = ERRMSG_GUISESS;
        try {
            dispEnv = System.getenv("DISPLAY");
        }
        catch (SecurityException e) {
            dispEnv = null;
        }
        if (dispEnv != null) {
            errMsg = MessageFormat.format(ERRMSG_DISPLAY, errMsg, dispEnv);
        }
        STDERR.println(errMsg);
        STDERR.flush();
        return 1;
    }

    private static void showErrorDialog(String errmsg, String title) {
        Component parent = null;
        JOptionPane.showMessageDialog(parent, errmsg, title, 0);
    }

    private static int checkSourceEncoding() {
        boolean pass = true;
        for (char[] pair : ENCODING_TEST) {
            char compiled = pair[0];
            char expected = pair[1];
            if (compiled == expected) continue;
            pass = false;
            break;
        }
        if (pass) {
            return 0;
        }
        String errmsg = ERRMSG_SRCENC;
        JindolfJre17.showErrorDialog(errmsg, TITLE_SRCENC);
        return 1;
    }

    private static int checkPackageDefinition() {
        Package rootPkg = ResourceManager.DEF_ROOT_PACKAGE;
        String implTitle = rootPkg.getImplementationTitle();
        String implVersion = rootPkg.getImplementationVersion();
        String implVendor = rootPkg.getImplementationVendor();
        String title = TITLE_PKGERR;
        if (implTitle != null && !VerInfo.TITLE.equals(implTitle)) {
            String errmsg = MessageFormat.format(ERRMSG_PKG, "\u30bf\u30a4\u30c8\u30eb", implTitle, VerInfo.TITLE);
            JindolfJre17.showErrorDialog(errmsg, title);
            return 1;
        }
        if (implVersion != null && !VerInfo.VERSION.equals(implVersion)) {
            String errmsg = MessageFormat.format(ERRMSG_PKG, "\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7", implVersion, VerInfo.VERSION);
            JindolfJre17.showErrorDialog(errmsg, title);
            return 1;
        }
        if (implVendor != null && !VerInfo.AUTHOR.equals(implVendor)) {
            String errmsg = MessageFormat.format(ERRMSG_PKG, "\u30d9\u30f3\u30c0", implVendor, VerInfo.AUTHOR);
            JindolfJre17.showErrorDialog(errmsg, title);
            return 1;
        }
        return 0;
    }

    private static int checkHasInvoked() {
        boolean successed = INVOKE_FLAG.compareAndSet(false, true);
        if (successed) {
            return 0;
        }
        JindolfJre17.showErrorDialog(ERRMSG_INVOKEDBL, TITLE_INVOKEDBL);
        return 1;
    }

    public static int main(String ... args) {
        int exitCode = JindolfJre17.proveGuiEnv();
        if (exitCode != 0) {
            return exitCode;
        }
        exitCode = JindolfJre17.checkSourceEncoding();
        if (exitCode != 0) {
            return exitCode;
        }
        exitCode = JindolfJre17.checkPackageDefinition();
        if (exitCode != 0) {
            return exitCode;
        }
        exitCode = JindolfJre17.checkHasInvoked();
        if (exitCode != 0) {
            return exitCode;
        }
        exitCode = JindolfMain.main(args);
        return exitCode;
    }
}

