/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import jp.sfjp.jindolf.Controller;
import jp.sfjp.jindolf.Jindolf;
import jp.sfjp.jindolf.JreChecker;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.config.AppSetting;
import jp.sfjp.jindolf.config.CmdOption;
import jp.sfjp.jindolf.config.ConfigStore;
import jp.sfjp.jindolf.config.EnvInfo;
import jp.sfjp.jindolf.config.OptionInfo;
import jp.sfjp.jindolf.data.LandsModel;
import jp.sfjp.jindolf.log.LogUtils;
import jp.sfjp.jindolf.log.LoggingDispatcher;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sfjp.jindolf.view.ActionManager;
import jp.sfjp.jindolf.view.TopFrame;
import jp.sfjp.jindolf.view.WindowManager;

public final class JindolfMain {
    public static final long NANOCT_LOADED;
    public static final long EPOCHMS_LOADED;
    private static final Logger LOGGER;
    private static final String RES_LOGOICON = "resources/image/logo.png";
    private static final String LOG_LOADED = "{0} \u306f {1,date} {2,time} \u306bVM\u4e0a\u306e\u30af\u30e9\u30b9 {3} \u3068\u3057\u3066\u30ed\u30fc\u30c9\u3055\u308c\u307e\u3057\u305f\u3002 ";
    private static final String LOG_NANOCT = "Initial Nano-Count : {0}";
    private static final String LOG_HEAP = "Max-heap : {0} Bytes   Total-heap : {1} Bytes";
    private static final String LOG_CONF = "\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b[ {0} ]\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002";
    private static final String LOG_NOCONF = "\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u4f7f\u3044\u307e\u305b\u3093\u3002";
    private static final String WARNMSG_SPLASH = "JRE1.6\u4ee5\u964d\u3067\u306f\u3001Jindolf\u306e-nosplash\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u7121\u52b9\u3067\u3059\u3002Java\u5b9f\u884c\u7cfb\u306e\u65b9\u3067\u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u753b\u9762\u306e\u975e\u8868\u793a\u3092\u6307\u793a\u3057\u3066\u304f\u3060\u3055\u3044(\u304a\u305d\u3089\u304f\u7a7a\u306e-splash:\u30aa\u30d7\u30b7\u30e7\u30f3)";
    private static final String FATALMSG_INITFAIL = "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f";
    private static final String ERRMSG_HELP = "\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u4e00\u89a7\u306f\u3001\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u300c{0}\u300d\u3092\u6307\u5b9a\u3059\u308b\u3068\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002";
    private static final PrintStream STDOUT;
    private static final PrintStream STDERR;

    private JindolfMain() {
        assert (false);
    }

    private static void flush() {
        STDOUT.flush();
        STDERR.flush();
    }

    private static void showHelpMessage() {
        JindolfMain.flush();
        String helpText = CmdOption.getHelpText();
        STDOUT.print(helpText);
        JindolfMain.flush();
    }

    private static Window showSplash() {
        if (JreChecker.has16Runtime()) {
            return null;
        }
        JWindow splashWindow = new JWindow();
        ImageIcon logo = ResourceManager.getImageIcon(RES_LOGOICON);
        JLabel splashLabel = new JLabel(logo);
        splashWindow.add(splashLabel);
        splashWindow.pack();
        splashWindow.setLocationRelativeTo(null);
        splashWindow.setVisible(true);
        Thread.yield();
        return splashWindow;
    }

    private static void hideSplash(final Window splashWindow) {
        if (splashWindow == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                splashWindow.setVisible(false);
                splashWindow.dispose();
            }
        });
    }

    private static void dumpBootInfo(AppSetting appSetting) {
        Object[] logArgs = new Object[]{VerInfo.ID, EPOCHMS_LOADED, EPOCHMS_LOADED, Jindolf.class.getName()};
        LOGGER.log(Level.INFO, LOG_LOADED, logArgs);
        LOGGER.log(Level.INFO, LOG_NANOCT, NANOCT_LOADED);
        Runtime runtime = Runtime.getRuntime();
        logArgs = new Object[]{runtime.maxMemory(), runtime.totalMemory()};
        LOGGER.log(Level.INFO, LOG_HEAP, logArgs);
        OptionInfo optinfo = appSetting.getOptionInfo();
        StringBuilder bootArgs = new StringBuilder();
        bootArgs.append("\n\n").append("\u8d77\u52d5\u6642\u5f15\u6570:\n");
        for (String arg : optinfo.getInvokeArgList()) {
            bootArgs.append("  ").append(arg).append('\n');
        }
        bootArgs.append('\n');
        bootArgs.append(EnvInfo.getVMInfo());
        LOGGER.info(bootArgs.toString());
        ConfigStore configStore = appSetting.getConfigStore();
        if (configStore.useStoreFile()) {
            LOGGER.log(Level.INFO, LOG_CONF, configStore.getConfigPath());
        } else {
            LOGGER.info(LOG_NOCONF);
        }
        if (JreChecker.has16Runtime() && optinfo.hasOption(CmdOption.OPT_NOSPLASH)) {
            LOGGER.warning(WARNMSG_SPLASH);
        }
    }

    public static int main(String ... args) {
        OptionInfo optinfo;
        try {
            optinfo = OptionInfo.parseOptions(args);
        }
        catch (IllegalArgumentException e) {
            String message = e.getLocalizedMessage();
            STDERR.println(message);
            String info = MessageFormat.format(ERRMSG_HELP, new Object[]{CmdOption.OPT_HELP});
            STDERR.println(info);
            int exitCode = 1;
            return exitCode;
        }
        int exitCode = JindolfMain.main(optinfo);
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main(OptionInfo optinfo) {
        int exitCode;
        if (optinfo.hasOption(CmdOption.OPT_HELP)) {
            JindolfMain.showHelpMessage();
            int exitCode2 = 0;
            return exitCode2;
        }
        if (optinfo.hasOption(CmdOption.OPT_VERSION)) {
            STDOUT.println(VerInfo.ID);
            int exitCode3 = 0;
            return exitCode3;
        }
        Boolean boldFlag = optinfo.hasOption(CmdOption.OPT_BOLDMETAL) ? Boolean.TRUE : Boolean.FALSE;
        UIManager.put("swing.boldMetal", boldFlag);
        Window splashWindow = null;
        if (!optinfo.hasOption(CmdOption.OPT_NOSPLASH)) {
            splashWindow = JindolfMain.showSplash();
        }
        try {
            exitCode = JindolfMain.splashedMain(optinfo);
        }
        finally {
            JindolfMain.hideSplash(splashWindow);
        }
        return exitCode;
    }

    public static int splashedMain(OptionInfo optinfo) {
        if (optinfo.hasOption(CmdOption.OPT_VMINFO)) {
            STDOUT.println(EnvInfo.getVMInfo());
        }
        LogUtils.initRootLogger(optinfo.hasOption(CmdOption.OPT_CONSOLELOG));
        final AppSetting appSetting = new AppSetting(optinfo);
        JindolfMain.dumpBootInfo(appSetting);
        ConfigStore configStore = appSetting.getConfigStore();
        configStore.prepareConfigDir();
        configStore.tryLock();
        appSetting.loadConfig();
        final Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOGGER.info("\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u51e6\u7406\u306b\u5165\u308a\u307e\u3059\u2026");
                JindolfMain.flush();
                runtime.gc();
                Thread.yield();
                runtime.runFinalization();
                Thread.yield();
            }
        });
        LoggingDispatcher.replaceEventQueue();
        int exitCode = 0;
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JindolfMain.startGUI(appSetting);
                }
            });
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, FATALMSG_INITFAIL, e);
            e.printStackTrace(STDERR);
            exitCode = 1;
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, FATALMSG_INITFAIL, e);
            e.printStackTrace(STDERR);
            exitCode = 1;
        }
        return exitCode;
    }

    private static void startGUI(AppSetting appSetting) {
        JFrame topFrame = JindolfMain.buildMVC(appSetting);
        GUIUtils.modifyWindowAttributes(topFrame, true, false, true);
        topFrame.pack();
        Dimension initGeometry = new Dimension(appSetting.initialFrameWidth(), appSetting.initialFrameHeight());
        topFrame.setSize(initGeometry);
        if (appSetting.initialFrameXpos() <= Integer.MIN_VALUE || appSetting.initialFrameYpos() <= Integer.MIN_VALUE) {
            topFrame.setLocationByPlatform(true);
        } else {
            topFrame.setLocation(appSetting.initialFrameXpos(), appSetting.initialFrameYpos());
        }
        topFrame.setVisible(true);
    }

    private static JFrame buildMVC(AppSetting appSetting) {
        LandsModel model = new LandsModel();
        WindowManager windowManager = new WindowManager();
        ActionManager actionManager = new ActionManager();
        model.loadLandList();
        Controller controller = new Controller(model, windowManager, actionManager, appSetting);
        TopFrame topFrame = controller.getTopFrame();
        return topFrame;
    }

    static {
        LOGGER = Logger.getAnonymousLogger();
        STDOUT = System.out;
        STDERR = System.err;
        NANOCT_LOADED = System.nanoTime();
        EPOCHMS_LOADED = System.currentTimeMillis();
    }
}

