/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.dxchg;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.net.ServerAccess;

public final class Hon5 {
    private static final String URL_HON5CAST = "http://hon5.com/jinro/";

    private Hon5() {
        assert (false);
        throw new AssertionError();
    }

    public static String getCastGeneratorUrl(Village village) {
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        URL villageUrl = server.getVillageURL(village);
        String result = Hon5.getCastGeneratorUrl(villageUrl);
        return result;
    }

    public static String getCastGeneratorUrl(URL villageUrl) {
        String vcode;
        String vUrlTxt = villageUrl.toString();
        try {
            vcode = URLEncoder.encode(vUrlTxt, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            return null;
        }
        StringBuilder url = new StringBuilder();
        url.append(URL_HON5CAST);
        url.append("?u=");
        url.append(vcode);
        url.append("&s=1");
        String urlTxt = url.toString();
        return urlTxt;
    }
}

