/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.dxchg;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import jp.sfjp.jindolf.dxchg.XmlResourceResolver;
import jp.sourceforge.jindolf.corelib.XmlResource;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlUtils {
    private static final ErrorHandler STRICT_HANDLER = new StrictHandler();
    private static final XmlResourceResolver RESOLVER = new XmlResourceResolver();

    private XmlUtils() {
    }

    public static DocumentBuilder createDocumentBuilder() throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        Schema xsdSchema = XmlUtils.createCoreSchema(RESOLVER);
        DocumentBuilder builder = XmlUtils.createBuilder(xsdSchema, RESOLVER);
        return builder;
    }

    public static Schema createCoreSchema(LSResourceResolver resolver) throws URISyntaxException, IOException, SAXException {
        SchemaFactory xsdSchemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        xsdSchemaFactory.setResourceResolver(resolver);
        xsdSchemaFactory.setErrorHandler(STRICT_HANDLER);
        InputStream is = XmlResource.I_URL_COREXML.openStream();
        StreamSource source = new StreamSource(is);
        Schema schema = xsdSchemaFactory.newSchema(source);
        return schema;
    }

    public static DocumentBuilder createBuilder(Schema schema, EntityResolver resolver) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setSchema(schema);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(STRICT_HANDLER);
        builder.setEntityResolver(resolver);
        return builder;
    }

    public static class StrictHandler
    implements ErrorHandler {
        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

