/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import jp.sfjp.jindolf.editor.TalkEditor;

public class EditArray
extends JPanel
implements Scrollable,
FocusListener {
    private static final int MAX_EDITORS = 50;
    private final List<TalkEditor> editorList = new ArrayList<TalkEditor>();
    private boolean onAdjusting = false;
    private final NavigationFilter keyNavigator = new CustomNavigation();
    private final DocumentListener documentListener = new DocWatcher();
    private TalkEditor activeEditor;
    private Font textFont;

    public EditArray() {
        this.setOpaque(false);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        TalkEditor firstEditor = this.incrementTalkEditor();
        this.setActiveEditor(firstEditor);
    }

    private TalkEditor createTalkEditor() {
        TalkEditor editor = new TalkEditor();
        editor.setNavigationFilter(this.keyNavigator);
        editor.addTextFocusListener(this);
        Document document = editor.getDocument();
        document.addDocumentListener(this.documentListener);
        if (this.textFont == null) {
            this.textFont = editor.getTextFont();
        } else {
            editor.setTextFont(this.textFont);
        }
        return editor;
    }

    private TalkEditor incrementTalkEditor() {
        TalkEditor editor = this.createTalkEditor();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 12;
        this.add((Component)editor, constraints);
        this.editorList.add(editor);
        int sequenceNumber = this.editorList.size();
        editor.setSequenceNumber(sequenceNumber);
        return editor;
    }

    private TalkEditor getTalkEditor(int sequenceNumber) {
        while (this.editorList.size() < sequenceNumber) {
            this.incrementTalkEditor();
        }
        TalkEditor result = this.editorList.get(sequenceNumber - 1);
        return result;
    }

    private TalkEditor nextEditor(TalkEditor editor) {
        int sequenceNumber = editor.getSequenceNumber();
        TalkEditor nextEditor = this.getTalkEditor(sequenceNumber + 1);
        return nextEditor;
    }

    private TalkEditor prevEditor(TalkEditor editor) {
        int sequenceNumber = editor.getSequenceNumber();
        if (sequenceNumber <= 1) {
            return null;
        }
        TalkEditor prevEditor = this.getTalkEditor(sequenceNumber - 1);
        return prevEditor;
    }

    private boolean isLastEditor(TalkEditor editor) {
        int size;
        int seqNo = editor.getSequenceNumber();
        return seqNo >= (size = this.editorList.size());
    }

    private TalkEditor getEditorFromDocument(Document document) {
        for (TalkEditor editor : this.editorList) {
            if (editor.getDocument() != document) continue;
            return editor;
        }
        return null;
    }

    private void removeEditor(TalkEditor editor) {
        if (editor.getParent() != this) {
            return;
        }
        int seqNo = editor.getSequenceNumber();
        if (seqNo <= 1) {
            return;
        }
        TalkEditor prevEditor = this.prevEditor(editor);
        if (editor.isActive()) {
            this.setActiveEditor(prevEditor);
        }
        if (editor.hasEditorFocus()) {
            prevEditor.requestEditorFocus();
        }
        this.editorList.remove(seqNo - 1);
        editor.setNavigationFilter(null);
        editor.removeTextFocusListener(this);
        Document document = editor.getDocument();
        document.removeDocumentListener(this.documentListener);
        editor.clearText();
        this.remove(editor);
        this.revalidate();
        int renumber = 1;
        for (TalkEditor newEditor : this.editorList) {
            newEditor.setSequenceNumber(renumber++);
        }
    }

    private void detachAdjustTask(DocumentEvent triggerEvent) {
        if (this.onAdjusting) {
            return;
        }
        Document document = triggerEvent.getDocument();
        final TalkEditor triggerEditor = this.getEditorFromDocument(document);
        if (triggerEditor.onIMEoperation()) {
            return;
        }
        this.onAdjusting = true;
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    EditArray.this.adjustTask(triggerEditor);
                }
                finally {
                    EditArray.this.onAdjusting = false;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustTask(TalkEditor triggerEditor) {
        int initCaretPos = triggerEditor.getCaretPosition();
        TalkEditor newFocus = null;
        int newCaretPos = -1;
        TalkEditor current = triggerEditor;
        while (true) {
            TalkEditor next;
            block11: {
                block12: {
                    if (this.isLastEditor(current)) break block12;
                    next = this.nextEditor(current);
                    String nextContents = next.getText();
                    int nextLength = nextContents.length();
                    current.appendTail(nextContents);
                    String rest = current.chopRest();
                    int restLength = rest == null ? 0 : rest.length();
                    int chopLength = nextLength - restLength;
                    if (chopLength > 0) {
                        next.chopHead(chopLength);
                        break block11;
                    } else if (chopLength < 0) {
                        rest = rest.substring(0, -chopLength);
                        next.appendHead(rest);
                        break block11;
                    } else {
                        if (newFocus != null) break;
                        newFocus = current;
                        newCaretPos = initCaretPos;
                        break;
                    }
                }
                String rest = current.chopRest();
                if (rest == null || this.editorList.size() >= 50) {
                    if (newFocus != null) break;
                    newFocus = current;
                    if (current.getTextLength() >= initCaretPos) {
                        newCaretPos = initCaretPos;
                        break;
                    }
                    newCaretPos = current.getTextLength();
                    break;
                }
                next = this.nextEditor(current);
                next.appendHead(rest);
            }
            if (newFocus == null) {
                int currentLength = current.getTextLength();
                if (initCaretPos >= currentLength) {
                    initCaretPos -= currentLength;
                } else {
                    newFocus = current;
                    newCaretPos = initCaretPos;
                }
            }
            current = next;
        }
        if (newFocus != null) {
            newFocus.requestEditorFocus();
            newFocus.setCaretPosition(newCaretPos);
        }
        this.adjustEditorsTail();
    }

    private void adjustEditorsTail() {
        int textLength;
        int editorNum = this.editorList.size();
        if (editorNum <= 0) {
            return;
        }
        TalkEditor lastEditor = this.editorList.get(editorNum - 1);
        TalkEditor prevlostEditor = null;
        boolean lostFocusedEditor = false;
        while (true) {
            textLength = lastEditor.getTextLength();
            int seqNo = lastEditor.getSequenceNumber();
            if (lostFocusedEditor) {
                prevlostEditor = lastEditor;
            }
            if (textLength > 0 || seqNo <= 1) break;
            if (lastEditor.hasEditorFocus()) {
                lostFocusedEditor = true;
            }
            this.removeEditor(lastEditor);
            lastEditor = this.prevEditor(lastEditor);
        }
        if (prevlostEditor != null) {
            textLength = prevlostEditor.getTextLength();
            prevlostEditor.requestEditorFocus();
            prevlostEditor.setCaretPosition(textLength);
        }
    }

    public TalkEditor getFocusedTalkEditor() {
        for (TalkEditor editor : this.editorList) {
            if (!editor.hasEditorFocus()) continue;
            return editor;
        }
        return null;
    }

    public void forwardEditor() {
        TalkEditor editor = this.getFocusedTalkEditor();
        if (this.isLastEditor(editor)) {
            return;
        }
        TalkEditor next = this.nextEditor(editor);
        next.setCaretPosition(0);
        next.requestEditorFocus();
    }

    public void backwardEditor() {
        TalkEditor editor = this.getFocusedTalkEditor();
        TalkEditor prev = this.prevEditor(editor);
        if (prev == null) {
            return;
        }
        int length = prev.getTextLength();
        prev.setCaretPosition(length);
        prev.requestEditorFocus();
    }

    private void setActiveEditor(TalkEditor editor) {
        if (this.activeEditor != null) {
            this.activeEditor.setActive(false);
        }
        this.activeEditor = editor;
        if (this.activeEditor != null) {
            this.activeEditor.setActive(true);
        }
        this.fireChangeActive();
    }

    public TalkEditor getActiveEditor() {
        return this.activeEditor;
    }

    public CharSequence getAllText() {
        StringBuilder result = new StringBuilder();
        for (TalkEditor editor : this.editorList) {
            String text = editor.getText();
            result.append(text);
        }
        return result;
    }

    public void setAllText(CharSequence seq) {
        block2: {
            TalkEditor firstEditor = this.getTalkEditor(1);
            Document doc = firstEditor.getDocument();
            try {
                doc.insertString(0, seq.toString(), null);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void clearAllEditor() {
        int editorNum = this.editorList.size();
        if (editorNum <= 0) {
            return;
        }
        TalkEditor lastEditor = this.editorList.get(editorNum - 1);
        do {
            this.removeEditor(lastEditor);
        } while ((lastEditor = this.prevEditor(lastEditor)) != null);
        TalkEditor firstEditor = this.getTalkEditor(1);
        firstEditor.clearText();
        this.setActiveEditor(firstEditor);
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
        for (TalkEditor editor : this.editorList) {
            editor.setTextFont(this.textFont);
            editor.repaint();
        }
        this.revalidate();
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    private void fireChangeActive() {
        ChangeListener[] listeners;
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            listener.stateChanged(event);
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        Object source = event.getSource();
        if (!(source instanceof JTextComponent)) {
            return;
        }
        JTextComponent textComp = (JTextComponent)source;
        Document document = textComp.getDocument();
        TalkEditor editor = this.getEditorFromDocument(document);
        this.setActiveEditor(editor);
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension result = this.getPreferredSize();
        return result;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        return 10;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    private class DocWatcher
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent event) {
            EditArray.this.detachAdjustTask(event);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            EditArray.this.detachAdjustTask(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            EditArray.this.detachAdjustTask(event);
        }
    }

    private class CustomNavigation
    extends NavigationFilter {
        @Override
        public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
            int result = super.getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
            if (result != pos) {
                return result;
            }
            switch (direction) {
                case 1: 
                case 7: {
                    EditArray.this.backwardEditor();
                    break;
                }
                case 3: 
                case 5: {
                    EditArray.this.forwardEditor();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return result;
        }
    }
}

