/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.ImtblAffineTx;
import jp.sourceforge.jovsonz.JsBoolean;
import jp.sourceforge.jovsonz.JsNumber;
import jp.sourceforge.jovsonz.JsObject;
import jp.sourceforge.jovsonz.JsPair;
import jp.sourceforge.jovsonz.JsString;
import jp.sourceforge.jovsonz.JsValue;

public final class Font2Json {
    private static final String HASH_FAMILY = "family";
    private static final String HASH_SIZE = "size";
    private static final String HASH_ISBOLD = "isBold";
    private static final String HASH_ISITALIC = "isItalic";
    private static final String HASH_USEAA = "useAntiAlias";
    private static final String HASH_FRACTIONAL = "useFractional";

    private Font2Json() {
        assert (false);
    }

    public static JsObject buildJson(FontInfo fontInfo) {
        Font font = fontInfo.getFont();
        FontRenderContext frc = fontInfo.getFontRenderContext();
        JsPair family = new JsPair(HASH_FAMILY, fontInfo.getRootFamilyName());
        JsPair size = new JsPair(HASH_SIZE, font.getSize());
        JsPair bold = new JsPair(HASH_ISBOLD, font.isBold());
        JsPair italic = new JsPair(HASH_ISITALIC, font.isItalic());
        JsPair aa = new JsPair(HASH_USEAA, frc.isAntiAliased());
        JsPair frac = new JsPair(HASH_FRACTIONAL, frc.usesFractionalMetrics());
        JsObject result = new JsObject();
        result.putPair(family);
        result.putPair(size);
        result.putPair(bold);
        result.putPair(italic);
        result.putPair(aa);
        result.putPair(frac);
        return result;
    }

    private static Font decodeJsonFont(JsObject obj) {
        JsBoolean bool;
        JsString string;
        Font decoded;
        Font font = null;
        JsValue value = obj.getValue(HASH_FAMILY);
        if (value instanceof JsString && (decoded = Font.decode((string = (JsString)value).toRawString())) != null) {
            font = decoded;
        }
        if (font == null) {
            font = FontInfo.DEFAULT_FONTINFO.getFont();
        }
        boolean isBold = false;
        boolean isItalic = false;
        value = obj.getValue(HASH_ISBOLD);
        if (value instanceof JsBoolean) {
            bool = (JsBoolean)value;
            isBold = bool.booleanValue();
        }
        if ((value = obj.getValue(HASH_ISITALIC)) instanceof JsBoolean) {
            bool = (JsBoolean)value;
            isItalic = bool.booleanValue();
        }
        int style = 0;
        if (isBold) {
            style |= 1;
        }
        if (isItalic) {
            style |= 2;
        }
        int size = 16;
        value = obj.getValue(HASH_SIZE);
        if (value instanceof JsNumber) {
            JsNumber number = (JsNumber)value;
            size = number.intValue();
        }
        Font derivedFont = font.deriveFont(style, size);
        return derivedFont;
    }

    private static FontRenderContext decodeJsonFrc(JsObject obj, Font font) {
        JsBoolean jsAntiAlias = null;
        JsBoolean jsFractional = null;
        boolean isAntiAlias = false;
        boolean useFractional = false;
        JsValue value = obj.getValue(HASH_USEAA);
        if (value instanceof JsBoolean) {
            jsAntiAlias = (JsBoolean)value;
            isAntiAlias = jsAntiAlias.booleanValue();
        }
        if ((value = obj.getValue(HASH_FRACTIONAL)) instanceof JsBoolean) {
            jsFractional = (JsBoolean)value;
            useFractional = jsFractional.booleanValue();
        }
        if (jsAntiAlias == null || jsFractional == null) {
            FontRenderContext defFrc = FontInfo.createBestContext(font);
            if (jsAntiAlias == null) {
                isAntiAlias = defFrc.isAntiAliased();
            }
            if (jsFractional == null) {
                useFractional = defFrc.usesFractionalMetrics();
            }
        }
        FontRenderContext newFrc = new FontRenderContext(ImtblAffineTx.IDENTITY, isAntiAlias, useFractional);
        return newFrc;
    }

    public static FontInfo decodeJson(JsObject obj) {
        Font font = Font2Json.decodeJsonFont(obj);
        FontRenderContext frc = Font2Json.decodeJsonFrc(obj, font);
        FontInfo result = new FontInfo(font, frc);
        return result;
    }
}

