/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.text.CharacterIterator;

public class SequenceCharacterIterator
implements CharacterIterator,
Cloneable {
    private CharSequence source;
    private final int cursorBegin;
    private final int cursorEnd;
    private final int cursorLength;
    private int cursorPos;

    public SequenceCharacterIterator(CharSequence source, int cursorBegin, int cursorEnd) {
        if (cursorBegin > cursorEnd) {
            throw new IllegalArgumentException();
        }
        if (cursorBegin < 0 || source.length() < cursorEnd) {
            throw new IndexOutOfBoundsException();
        }
        this.source = source;
        this.cursorBegin = cursorBegin;
        this.cursorEnd = cursorEnd;
        this.cursorLength = this.cursorEnd - this.cursorBegin;
        this.cursorPos = this.cursorBegin;
    }

    public SequenceCharacterIterator(CharSequence source) {
        this.source = source;
        this.cursorBegin = 0;
        this.cursorEnd = source.length();
        this.cursorLength = this.cursorEnd - this.cursorBegin;
        this.cursorPos = this.cursorBegin;
    }

    @Override
    public char first() {
        this.cursorPos = this.cursorBegin;
        return this.current();
    }

    @Override
    public char last() {
        this.cursorPos = this.cursorEnd - 1;
        return this.current();
    }

    @Override
    public char current() {
        if (this.cursorLength <= 0 || this.cursorPos < this.cursorBegin) {
            this.cursorPos = this.cursorBegin;
            return '\uffff';
        }
        if (this.cursorPos >= this.cursorEnd) {
            this.cursorPos = this.cursorEnd;
            return '\uffff';
        }
        return this.source.charAt(this.cursorPos);
    }

    @Override
    public char next() {
        ++this.cursorPos;
        return this.current();
    }

    @Override
    public char previous() {
        --this.cursorPos;
        return this.current();
    }

    @Override
    public char setIndex(int newPos) throws IllegalArgumentException {
        if (newPos < this.cursorBegin || this.cursorEnd < newPos) {
            throw new IllegalArgumentException();
        }
        this.cursorPos = newPos;
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return this.cursorBegin;
    }

    @Override
    public int getEndIndex() {
        return this.cursorEnd;
    }

    @Override
    public int getIndex() {
        return this.cursorPos;
    }

    @Override
    public Object clone() {
        Object result;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
        SequenceCharacterIterator seq = (SequenceCharacterIterator)result;
        seq.source = this.source.toString();
        return seq;
    }
}

