/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.net;

import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

public class AuthManager {
    public static final String POST_LOGOUT;
    private static final String COOKIE_LOGIN = "login";
    private static final String ENC_POST = "UTF-8";
    private static final String PARAM_REDIR;
    private static final CookieManager COOKIE_MANAGER;
    private final URI baseURI;

    public AuthManager(URI bbsUri) throws NullPointerException {
        if (bbsUri == null) {
            throw new NullPointerException();
        }
        this.baseURI = bbsUri;
    }

    public AuthManager(URL bbsUrl) throws NullPointerException, IllegalArgumentException {
        this(AuthManager.urlToUri(bbsUrl));
    }

    private static URI urlToUri(URL url) throws NullPointerException, IllegalArgumentException {
        URI uri;
        if (url == null) {
            throw new NullPointerException();
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    public static String encodeForm4Post(String formData) {
        String result;
        if (formData == null) {
            return null;
        }
        try {
            result = URLEncoder.encode(formData, ENC_POST);
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            result = null;
        }
        return result;
    }

    public static String encodeForm4Post(char[] formData) {
        return AuthManager.encodeForm4Post(new String(formData));
    }

    public static String buildLoginPostData(String userID, char[] password) {
        String id = AuthManager.encodeForm4Post(userID);
        if (id == null || id.isEmpty()) {
            return null;
        }
        String pw = AuthManager.encodeForm4Post(password);
        if (pw == null || pw.isEmpty()) {
            return null;
        }
        StringBuilder postData = new StringBuilder();
        postData.append("cmd=login");
        postData.append('&').append(PARAM_REDIR);
        postData.append('&').append("user_id=").append(id);
        postData.append('&').append("password=").append(pw);
        String result = postData.toString();
        return result;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public List<HttpCookie> getCookieList(CookieStore cookieStore) {
        List<HttpCookie> cookieList = cookieStore.get(this.baseURI);
        return cookieList;
    }

    public HttpCookie getAuthCookie(CookieStore cookieStore) {
        List<HttpCookie> cookieList = this.getCookieList(cookieStore);
        for (HttpCookie cookie : cookieList) {
            String cookieName = cookie.getName();
            if (!COOKIE_LOGIN.equals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    public boolean hasLoggedIn() {
        assert (COOKIE_MANAGER == CookieHandler.getDefault());
        CookieStore cookieStore = COOKIE_MANAGER.getCookieStore();
        HttpCookie authCookie = this.getAuthCookie(cookieStore);
        if (authCookie == null) {
            this.clearAuthentication();
            return false;
        }
        return true;
    }

    public void clearAuthentication() {
        assert (COOKIE_MANAGER == CookieHandler.getDefault());
        CookieStore cookieStore = COOKIE_MANAGER.getCookieStore();
        HttpCookie authCookie = this.getAuthCookie(cookieStore);
        if (authCookie != null) {
            cookieStore.remove(this.baseURI, authCookie);
        }
    }

    static {
        PARAM_REDIR = "cgi_param=" + AuthManager.encodeForm4Post("&#bottom");
        POST_LOGOUT = "cmd=logout&" + PARAM_REDIR;
        COOKIE_MANAGER = new CookieManager();
        CookieHandler.setDefault(COOKIE_MANAGER);
    }
}

