/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.summary;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Player;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.dxchg.ClipboardAction;
import jp.sfjp.jindolf.dxchg.FaceIconSet;
import jp.sfjp.jindolf.dxchg.TextPopup;
import jp.sfjp.jindolf.dxchg.WebButton;
import jp.sfjp.jindolf.dxchg.WolfBBS;
import jp.sfjp.jindolf.summary.GameSummary;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sfjp.jindolf.util.Monodizer;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.Team;

public class VillageDigest
extends JDialog
implements ActionListener,
ItemListener {
    private static final String ITEMDELIM = " : ";
    private final JComponent summaryPanel = this.buildSummaryPanel();
    private final JLabel faceLabel = new JLabel();
    private final ImageIcon faceIcon = new ImageIcon();
    private final JComboBox<Avatar> playerBox = new JComboBox();
    private final DefaultComboBoxModel<Avatar> playerListModel = new DefaultComboBoxModel();
    private final JButton prevPlayer = new JButton("\u2191");
    private final JButton nextPlayer = new JButton("\u2193");
    private final JLabel roleLabel = new JLabel();
    private final JLabel destinyLabel = new JLabel();
    private final JLabel specialSkillLabel = new JLabel();
    private final JLabel entryLabel = new JLabel();
    private final JLabel idLabel = new JLabel();
    private final WebButton urlLine = new WebButton();
    private final JComponent playerPanel = this.buildPlayerPanel();
    private final JComboBox<FaceIconSet> iconSetBox = new JComboBox();
    private final DefaultComboBoxModel<FaceIconSet> iconSetListModel = new DefaultComboBoxModel();
    private final JLabel authorLabel = new JLabel();
    private final JLabel authorUrlLabel = new JLabel();
    private final WebButton iconCatalog = new WebButton();
    private final JButton genCastTableButton = new JButton("\u30ad\u30e3\u30b9\u30c8\u8868Wiki\u751f\u6210");
    private final JButton copyClipButton = new JButton("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc");
    private final JTextArea templateArea = new JTextArea();
    private final JButton voteButton = new JButton("\u6295\u7968Wiki\u751f\u6210");
    private final JButton vlgWikiButton = new JButton("\u6751\u8a73\u7d30Wiki\u751f\u6210");
    private final JComponent clipboardPanel = this.buildClipboardPanel();
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");
    private Village village;
    private GameSummary gameSummary;

    public VillageDigest(Frame owner) {
        super(owner);
        this.setModal(true);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                VillageDigest.this.actionClose();
            }
        });
        this.faceLabel.setIcon(this.faceIcon);
        this.playerBox.setModel(this.playerListModel);
        this.playerBox.addItemListener(this);
        this.prevPlayer.setMargin(new Insets(1, 1, 1, 1));
        this.prevPlayer.addActionListener(this);
        this.prevPlayer.setToolTipText("\u524d\u306e\u30d7\u30ec\u30a4\u30e4\u30fc");
        this.nextPlayer.setMargin(new Insets(1, 1, 1, 1));
        this.nextPlayer.addActionListener(this);
        this.nextPlayer.setToolTipText("\u6b21\u306e\u30d7\u30ec\u30a4\u30e4\u30fc");
        this.iconSetBox.setModel(this.iconSetListModel);
        this.iconSetBox.addItemListener(this);
        for (FaceIconSet iconSet : WolfBBS.getFaceIconSetList()) {
            this.iconSetListModel.addElement(iconSet);
        }
        this.iconCatalog.setURLText("http://wolfbbs.jp/%A4%DE%A4%C8%A4%E1%A5%B5%A5%A4%A5%C8%A4%C7%CD%F8%CD%D1%B2%C4%C7%BD%A4%CA%A5%A2%A5%A4%A5%B3%A5%F3%B2%E8%C1%FC.html");
        this.iconCatalog.setCaption("\u9854\u30a2\u30a4\u30b3\u30f3\u898b\u672c\u30da\u30fc\u30b8");
        this.templateArea.setEditable(true);
        this.templateArea.setLineWrap(true);
        Monodizer.monodize(this.templateArea);
        TextPopup popup = new TextPopup();
        this.templateArea.setComponentPopupMenu(popup);
        this.genCastTableButton.addActionListener(this);
        this.voteButton.addActionListener(this);
        this.vlgWikiButton.addActionListener(this);
        this.copyClipButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        Monodizer.monodize(this.idLabel);
        Monodizer.monodize(this.authorUrlLabel);
        Container content = this.getContentPane();
        this.design(content);
    }

    private static void addCaptionedItem(Container container, CharSequence caption, CharSequence delimiter, Object item) {
        LayoutManager layout = container.getLayout();
        if (!(layout instanceof GridBagLayout)) {
            throw new IllegalArgumentException();
        }
        JLabel captionLabel = new JLabel(caption.toString());
        JLabel delimiterLabel = new JLabel(delimiter.toString());
        JComponent itemComp = item instanceof JComponent ? (JComponent)item : new JLabel(item.toString());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.gridwidth = 1;
        constraints.anchor = 12;
        container.add((Component)captionLabel, constraints);
        container.add((Component)delimiterLabel, constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        container.add((Component)itemComp, constraints);
    }

    private static void addCaptionedItem(Container container, CharSequence caption, Object item) {
        VillageDigest.addCaptionedItem(container, caption, ITEMDELIM, item);
    }

    private static void addFatPad(Container container) {
        LayoutManager layout = container.getLayout();
        if (!(layout instanceof GridBagLayout)) {
            throw new IllegalArgumentException();
        }
        JPanel pad = new JPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        container.add((Component)pad, constraints);
    }

    private static JComponent createGridBagComponent() {
        JPanel result = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        result.setLayout(layout);
        return result;
    }

    private JComponent buildSummaryPanel() {
        JComponent result = VillageDigest.createGridBagComponent();
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        result.setBorder(border);
        return result;
    }

    private JComponent buildPlayerPanel() {
        JComponent result = VillageDigest.createGridBagComponent();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 12;
        constraints.insets = new Insets(2, 2, 2, 2);
        result.add((Component)this.faceLabel, constraints);
        result.add((Component)new JLabel(ITEMDELIM), constraints);
        constraints.anchor = 18;
        result.add(this.playerBox, constraints);
        result.add((Component)this.prevPlayer, constraints);
        constraints.gridwidth = 0;
        result.add((Component)this.nextPlayer, constraints);
        VillageDigest.addCaptionedItem(result, "\u5f79\u8077", this.roleLabel);
        VillageDigest.addCaptionedItem(result, "\u904b\u547d", this.destinyLabel);
        VillageDigest.addCaptionedItem(result, "\u7279\u6b8a\u6280\u80fd", this.specialSkillLabel);
        VillageDigest.addCaptionedItem(result, "\u30a8\u30f3\u30c8\u30ea#", this.entryLabel);
        VillageDigest.addCaptionedItem(result, "ID", this.idLabel);
        VillageDigest.addCaptionedItem(result, "URL", this.urlLine);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        result.add((Component)new JPanel(), constraints);
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        result.setBorder(border);
        return result;
    }

    private JComponent buildCastPanel() {
        JComponent result = VillageDigest.createGridBagComponent();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 12;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        result.add((Component)this.iconCatalog, constraints);
        VillageDigest.addCaptionedItem(result, "\u9854\u30a2\u30a4\u30b3\u30f3\u30bb\u30c3\u30c8\u3092\u9078\u629e", this.iconSetBox);
        VillageDigest.addCaptionedItem(result, "\u4f5c\u8005", this.authorLabel);
        VillageDigest.addCaptionedItem(result, "URL", this.authorUrlLabel);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 12;
        constraints.gridwidth = 0;
        result.add((Component)this.genCastTableButton, constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u30ad\u30e3\u30b9\u30c8\u8868Wiki\u751f\u6210");
        result.setBorder(border);
        return result;
    }

    private JComponent buildVotePanel() {
        JComponent result = VillageDigest.createGridBagComponent();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 12;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        result.add((Component)this.voteButton, constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u6295\u7968Wiki\u751f\u6210");
        result.setBorder(border);
        return result;
    }

    private JComponent buildVillageWikiPanel() {
        JComponent result = VillageDigest.createGridBagComponent();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 12;
        constraints.gridwidth = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        result.add((Component)this.vlgWikiButton, constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u6751\u8a73\u7d30Wiki\u751f\u6210");
        result.setBorder(border);
        return result;
    }

    private JComponent buildClipText() {
        JComponent result = VillageDigest.createGridBagComponent();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 12;
        constraints.gridwidth = 0;
        result.add((Component)this.copyClipButton, constraints);
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.templateArea.setBorder(border);
        JScrollPane scroller = new JScrollPane();
        JViewport viewPort = scroller.getViewport();
        viewPort.setView(this.templateArea);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.setMinimumSize(new Dimension(10, 50));
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        result.add((Component)scroller, constraints);
        border = BorderFactory.createTitledBorder("PukiWiki\u30c6\u30ad\u30b9\u30c8");
        result.setBorder(border);
        return result;
    }

    private JComponent buildClipboardPanel() {
        JComponent result = VillageDigest.createGridBagComponent();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.gridwidth = 0;
        JComponent castPanel = this.buildCastPanel();
        result.add((Component)castPanel, constraints);
        JComponent vlgWikiPanel = this.buildVillageWikiPanel();
        result.add((Component)vlgWikiPanel, constraints);
        JComponent votePanel = this.buildVotePanel();
        result.add((Component)votePanel, constraints);
        constraints.fill = 0;
        constraints.anchor = 10;
        result.add((Component)new JLabel("\u2193\u2193\u2193"), constraints);
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        JComponent clipText = this.buildClipText();
        result.add((Component)clipText, constraints);
        return result;
    }

    private void design(Container container) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        container.setLayout(layout);
        JScrollPane scroller1 = new JScrollPane();
        scroller1.getVerticalScrollBar().setUnitIncrement(15);
        scroller1.getHorizontalScrollBar().setUnitIncrement(15);
        JViewport viewPort1 = scroller1.getViewport();
        viewPort1.setView(this.summaryPanel);
        JScrollPane scroller2 = new JScrollPane();
        scroller2.getVerticalScrollBar().setUnitIncrement(15);
        scroller2.getHorizontalScrollBar().setUnitIncrement(15);
        JViewport viewPort2 = scroller2.getViewport();
        viewPort2.setView(this.playerPanel);
        JTabbedPane tabComp = new JTabbedPane();
        tabComp.add("\u6751\u8a73\u7d30", scroller1);
        tabComp.add("\u30d7\u30ec\u30a4\u30e4\u30fc\u8a73\u7d30", scroller2);
        tabComp.add("\u307e\u3068\u3081\u30b5\u30a4\u30c8\u7528Wiki\u751f\u6210", this.clipboardPanel);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.gridwidth = 0;
        container.add((Component)tabComp, constraints);
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 14;
        container.add((Component)this.closeButton, constraints);
    }

    private void actionClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void setVillage(Village village) {
        this.clear();
        this.village = village;
        if (village == null) {
            return;
        }
        this.gameSummary = new GameSummary(this.village);
        this.updateSummary();
        for (Player player : this.gameSummary.getPlayerList()) {
            Avatar avatar = player.getAvatar();
            this.playerListModel.addElement(avatar);
        }
        if (this.playerListModel.getSize() >= 2) {
            Avatar player2nd = this.playerListModel.getElementAt(1);
            this.playerListModel.setSelectedItem(player2nd);
            Avatar player1st = this.playerListModel.getElementAt(0);
            this.playerListModel.setSelectedItem(player1st);
        }
    }

    private void updateSummary() {
        String villageName = this.village.getVillageFullName();
        Team winnerTeam = this.gameSummary.getWinnerTeam();
        String wonTeam = winnerTeam.getTeamName();
        int avatarNum = this.gameSummary.countAvatarNum();
        String totalMember = "\u30b2\u30eb\u30c8 + " + (avatarNum - 1) + "\u540d = " + avatarNum + "\u540d";
        JComponent roleDetail = VillageDigest.createGridBagComponent();
        for (GameRole role : GameRole.values()) {
            List<Player> players = this.gameSummary.getRoledPlayerList(role);
            if (players.size() <= 0) continue;
            String roleName = role.getRoleName();
            VillageDigest.addCaptionedItem(roleDetail, roleName, " \u00d7 ", players.size());
        }
        String suddenDeath = this.gameSummary.countSuddenDeath() + "\u540d";
        DateFormat dform = DateFormat.getDateTimeInstance(0, 0);
        Date date = this.gameSummary.get1stTalkDate();
        String talk1st = dform.format(date);
        date = this.gameSummary.getLastTalkDate();
        String talkLast = dform.format(date);
        int limitHour = this.village.getLimitHour();
        int limitMinute = this.village.getLimitMinute();
        StringBuilder limit = new StringBuilder();
        if (limitHour < 10) {
            limit.append('0');
        }
        limit.append(limitHour).append(':');
        if (limitMinute < 10) {
            limit.append('0');
        }
        limit.append(limitMinute);
        JComponent transition = VillageDigest.createGridBagComponent();
        for (int day = 1; day < this.village.getPeriodSize(); ++day) {
            List<Player> players = this.gameSummary.getSurvivorList(day);
            String roleSeq = GameSummary.getRoleBalanceSequence(players);
            Period period = this.village.getPeriod(day);
            String daySeq = period.getCaption();
            VillageDigest.addCaptionedItem(transition, daySeq, roleSeq);
        }
        StringBuilder schedule = new StringBuilder();
        int progressDays = this.village.getProgressDays();
        schedule.append("\u30d7\u30ed\u30ed\u30fc\u30b0 + ").append(progressDays).append("\u65e5 + \u30a8\u30d4\u30ed\u30fc\u30b0");
        CharSequence exeInfo = this.gameSummary.dumpExecutionInfo();
        CharSequence eatInfo = this.gameSummary.dumpAssaultInfo();
        CharSequence scoreSeer = this.gameSummary.dumpSeerActivity();
        CharSequence scoreHunter = this.gameSummary.dumpHunterActivity();
        this.summaryPanel.removeAll();
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u6751\u540d", villageName);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u52dd\u8005", wonTeam);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u6240\u8981\u65e5\u6570", schedule);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u66f4\u65b0\u6642\u523b", limit);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u767a\u8a00\u958b\u59cb", talk1st);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u6700\u7d42\u767a\u8a00", talkLast);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u53c2\u52a0\u4eba\u6570", totalMember);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u5f79\u8077\u5185\u8a33", roleDetail);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u51e6\u5211\u5185\u8a33", exeInfo);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u8972\u6483\u5185\u8a33", eatInfo);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u7a81\u7136\u6b7b", suddenDeath);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u4eba\u53e3\u63a8\u79fb", transition);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u5360\u6210\u7e3e", scoreSeer);
        VillageDigest.addCaptionedItem(this.summaryPanel, "\u72e9\u6210\u7e3e", scoreHunter);
        VillageDigest.addFatPad(this.summaryPanel);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.actionClose();
        } else if (source == this.copyClipButton) {
            this.actionCopyToClipboard();
        } else if (source == this.genCastTableButton) {
            this.actionGenCastTable();
        } else if (source == this.voteButton) {
            this.actionGenVoteBox();
        } else if (source == this.vlgWikiButton) {
            this.actionGenVillageWiki();
        } else if (source == this.prevPlayer) {
            int index = this.playerBox.getSelectedIndex();
            if (index <= 0) {
                return;
            }
            this.playerBox.setSelectedIndex(--index);
        } else if (source == this.nextPlayer) {
            int playerNum;
            int index = this.playerBox.getSelectedIndex();
            if (index >= (playerNum = this.playerBox.getItemCount()) - 1) {
                return;
            }
            this.playerBox.setSelectedIndex(++index);
        }
    }

    private void actionGenCastTable() {
        Object selected = this.iconSetListModel.getSelectedItem();
        if (!(selected instanceof FaceIconSet)) {
            return;
        }
        FaceIconSet iconSet = (FaceIconSet)selected;
        CharSequence wikiText = this.gameSummary.dumpCastingBoard(iconSet);
        this.putWikiText(wikiText);
    }

    private void actionGenVoteBox() {
        CharSequence wikiText = this.gameSummary.dumpVoteBox();
        this.putWikiText(wikiText);
    }

    private void actionGenVillageWiki() {
        CharSequence wikiText = this.gameSummary.dumpVillageWiki();
        this.putWikiText(wikiText);
    }

    private void putWikiText(CharSequence wikiText) {
        this.templateArea.setText(wikiText.toString());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTextArea area = VillageDigest.this.templateArea;
                area.scrollRectToVisible(new Rectangle());
            }
        });
    }

    private void actionCopyToClipboard() {
        String text = this.templateArea.getText();
        ClipboardAction.copyToClipboard(text);
    }

    private void selectPlayer(Avatar avatar) {
        String urlText;
        if (avatar == this.playerBox.getItemAt(0)) {
            this.prevPlayer.setEnabled(false);
        } else {
            this.prevPlayer.setEnabled(true);
        }
        int playerNum = this.playerBox.getItemCount();
        if (avatar == this.playerBox.getItemAt(playerNum - 1)) {
            this.nextPlayer.setEnabled(false);
        } else {
            this.nextPlayer.setEnabled(true);
        }
        BufferedImage image = this.village.getAvatarFaceImage(avatar);
        this.faceIcon.setImage(image);
        this.faceLabel.setIcon(null);
        this.faceLabel.setIcon(this.faceIcon);
        Player player = this.gameSummary.getPlayer(avatar);
        GameRole role = player.getRole();
        this.roleLabel.setText(role.getRoleName());
        String destinyMessage = player.getDestinyMessage();
        this.destinyLabel.setText(destinyMessage);
        CharSequence specialSkill = "";
        switch (role) {
            case SEER: {
                specialSkill = this.gameSummary.dumpSeerActivity();
                break;
            }
            case HUNTER: {
                specialSkill = this.gameSummary.dumpHunterActivity();
                break;
            }
        }
        this.specialSkillLabel.setText(specialSkill.toString());
        this.entryLabel.setText(String.valueOf(player.getEntryNo()));
        String userId = player.getIdName();
        this.idLabel.setText(userId);
        String caption = urlText = player.getUrlText();
        if (urlText == null || urlText.length() <= 0) {
            urlText = WolfBBS.encodeURLFromId(userId);
            caption = "\u3082\u3057\u304b\u3057\u3066 " + urlText;
        }
        this.urlLine.setURLText(urlText);
        this.urlLine.setCaption(caption);
    }

    private void selectIconSet(FaceIconSet iconSet) {
        String author = iconSet.getAuthor();
        String urlText = iconSet.getUrlText();
        this.authorLabel.setText(author + "\u6c0f");
        this.authorUrlLabel.setText(urlText);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        int state = event.getStateChange();
        if (state != 1) {
            return;
        }
        Object source = event.getSource();
        Object item = event.getItem();
        if (item == null) {
            return;
        }
        if (source == this.playerBox) {
            if (!(item instanceof Avatar)) {
                return;
            }
            Avatar avatar = (Avatar)item;
            this.selectPlayer(avatar);
        } else if (source == this.iconSetBox) {
            if (!(item instanceof FaceIconSet)) {
                return;
            }
            FaceIconSet iconSet = (FaceIconSet)item;
            this.selectIconSet(iconSet);
        }
    }

    private void clear() {
        this.templateArea.setText("");
        this.playerListModel.removeAllElements();
    }
}

