/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.config.ConfigStore;
import jp.sfjp.jindolf.config.EnvInfo;
import jp.sfjp.jindolf.config.OptionInfo;
import jp.sfjp.jindolf.dxchg.TextPopup;
import jp.sfjp.jindolf.util.GUIUtils;

public class HelpFrame
extends JFrame
implements ActionListener,
HyperlinkListener {
    private static final String HELP_HTML = "resources/html/help.html";
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final JTabbedPane tabPanel = new JTabbedPane();
    private final JEditorPane htmlView = new JEditorPane();
    private final JTextArea vmInfo = new JTextArea();
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");

    public HelpFrame() {
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.htmlView.setEditable(false);
        this.htmlView.setContentType("text/html");
        this.htmlView.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.htmlView.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.htmlView.setBorder(border);
        this.htmlView.addHyperlinkListener(this);
        this.htmlView.setComponentPopupMenu(new TextPopup());
        this.vmInfo.setEditable(false);
        this.vmInfo.setLineWrap(true);
        this.vmInfo.setComponentPopupMenu(new TextPopup());
        this.closeButton.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                HelpFrame.this.close();
            }
        });
        URL topUrl = ResourceManager.getResource(HELP_HTML);
        this.loadURL(topUrl);
        this.design();
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.gridwidth = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        JScrollPane sc = new JScrollPane(this.htmlView);
        this.tabPanel.add("\u30d8\u30eb\u30d7", sc);
        sc = new JScrollPane(this.vmInfo);
        this.tabPanel.add("\u5b9f\u884c\u74b0\u5883", sc);
        content.add((Component)this.tabPanel, constraints);
        constraints.weighty = 0.0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        constraints.fill = 0;
        content.add((Component)this.closeButton, constraints);
    }

    private void close() {
        this.setVisible(false);
    }

    private void loadURL(URL url) {
        block3: {
            if (url == null) {
                return;
            }
            try {
                this.htmlView.setPage(url);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "\u30d8\u30eb\u30d7\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093", e);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void updateVmInfo(OptionInfo optinfo, ConfigStore configStore) {
        StringBuilder info = new StringBuilder();
        info.append("\u8d77\u52d5\u6642\u5f15\u6570:\n");
        for (String arg : optinfo.getInvokeArgList()) {
            info.append("  ").append(arg).append('\n');
        }
        info.append('\n');
        info.append(EnvInfo.getVMInfo());
        if (configStore.useStoreFile()) {
            info.append("\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea : ").append(configStore.getConfigPath().getPath());
        } else {
            info.append("\u203b \u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u4f7f\u3063\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.vmInfo.setText(info.toString());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() != this.closeButton) {
            return;
        }
        this.close();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL url = event.getURL();
        this.loadURL(url);
    }
}

