/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.dxchg.WebButton;
import jp.sfjp.jindolf.util.Monodizer;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.LandState;

public class LandInfoPanel
extends JPanel {
    private final JLabel landName = new JLabel();
    private final JLabel landIdentifier = new JLabel();
    private final WebButton webURL = new WebButton();
    private final JLabel startDate = new JLabel();
    private final JLabel endDate = new JLabel();
    private final JLabel landState = new JLabel();
    private final JLabel locale = new JLabel();
    private final JLabel timezone = new JLabel();
    private final WebButton contact = new WebButton();
    private final JLabel description = new JLabel();

    public LandInfoPanel() {
        Monodizer.monodize(this.landIdentifier);
        Monodizer.monodize(this.locale);
        this.design();
    }

    private static String getStatusMark(LandState state) {
        String result;
        switch (state) {
            case CLOSED: {
                result = "\u30b5\u30fc\u30d3\u30b9\u7d42\u4e86";
                break;
            }
            case HISTORICAL: {
                result = "\u904e\u53bb\u30ed\u30b0\u63d0\u4f9b\u306e\u307f";
                break;
            }
            case ACTIVE: {
                result = "\u7a3c\u52d5\u4e2d";
                break;
            }
            default: {
                assert (false);
                result = "";
            }
        }
        return result;
    }

    private void layoutRow(String item, JComponent comp) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2, 2, 2, 2);
        String itemCaption = item + " : ";
        JLabel itemLabel = new JLabel(itemCaption);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.add((Component)itemLabel, constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.add((Component)comp, constraints);
    }

    private void design() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.layoutRow("\u56fd\u540d", this.landName);
        this.layoutRow("\u8b58\u5225\u540d", this.landIdentifier);
        this.layoutRow("Web\u30b5\u30a4\u30c8", this.webURL);
        this.layoutRow("\u5efa\u56fd", this.startDate);
        this.layoutRow("\u4ea1\u56fd", this.endDate);
        this.layoutRow("\u72b6\u614b", this.landState);
        this.layoutRow("\u30ed\u30b1\u30fc\u30eb", this.locale);
        this.layoutRow("\u6642\u9593\u5e2f", this.timezone);
        this.layoutRow("\u9023\u7d61\u5148", this.contact);
        this.layoutRow("\u8aac\u660e", this.description);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        this.add((Component)new JPanel(), constraints);
    }

    public void update(Land land) {
        LandDef landDef = land.getLandDef();
        DateFormat dform = DateFormat.getDateTimeInstance(0, 0);
        long start = landDef.getStartDateTime();
        String startStr = dform.format(new Date(start));
        if (start < 0L) {
            startStr = "(\u4e0d\u660e)";
        }
        long end = landDef.getEndDateTime();
        String endStr = dform.format(new Date(end));
        if (end < 0L) {
            endStr = "\u307e\u3060\u307e\u3060";
        }
        String status = LandInfoPanel.getStatusMark(land.getLandDef().getLandState());
        this.landName.setText(landDef.getLandName());
        this.landIdentifier.setText(landDef.getLandId());
        this.webURL.setURI(land.getLandDef().getWebURI());
        this.startDate.setText(startStr);
        this.endDate.setText(endStr);
        this.landState.setText(status);
        this.locale.setText(landDef.getLocale().toString());
        this.timezone.setText(landDef.getTimeZone().getDisplayName());
        this.contact.setURLText(landDef.getContactInfo());
        this.description.setText(landDef.getDescription());
        this.revalidate();
    }
}

