/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import jp.sourceforge.jovsonz.JsParseException;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsValue;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.JsonSource;
import jp.sourceforge.jovsonz.ValueVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsNumber
implements JsValue,
Comparable<JsNumber> {
    private static final MathContext DEF_MC = new MathContext(0, RoundingMode.UNNECESSARY);
    private static final String ERRMSG_INVFRAC = "invalid fractional number";
    private static final String ERRMSG_NONUMBER = "no number";
    private static final String ERRMSG_EXTRAZERO = "extra zero found";
    private final BigDecimal decimal;

    public JsNumber(long val) {
        this(BigDecimal.valueOf(val));
    }

    public JsNumber(double val) {
        this(BigDecimal.valueOf(val));
    }

    public JsNumber(BigInteger val) throws ArithmeticException {
        this(new BigDecimal(val, DEF_MC));
    }

    public JsNumber(CharSequence val) throws NumberFormatException, ArithmeticException {
        this(new BigDecimal(val.toString(), DEF_MC));
    }

    public JsNumber(BigDecimal val) throws NullPointerException {
        if (val == null) {
            throw new NullPointerException();
        }
        this.decimal = val;
    }

    public static boolean isLatinDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static Appendable appendDigitText(JsonSource source, Appendable app, boolean allowZeroTrail) throws IOException, JsParseException {
        char head = source.readOrDie();
        if (head == '-') {
            app.append('-');
        } else if (head != '+') {
            source.unread(head);
        }
        boolean hasAppended = false;
        boolean zeroStarted = false;
        while (source.hasMore() || !hasAppended) {
            char readedCh = source.readOrDie();
            if (!JsNumber.isLatinDigit(readedCh)) {
                if (!hasAppended) {
                    throw new JsParseException(ERRMSG_NONUMBER, source.getLineNumber());
                }
                source.unread(readedCh);
                break;
            }
            if (hasAppended) {
                if (zeroStarted && !allowZeroTrail) {
                    throw new JsParseException(ERRMSG_EXTRAZERO, source.getLineNumber());
                }
            } else if (readedCh == '0') {
                zeroStarted = true;
            }
            app.append(readedCh);
            hasAppended = true;
        }
        return app;
    }

    private static Appendable appendFractionPart(JsonSource source, Appendable app) throws IOException, JsParseException {
        if (!source.hasMore()) {
            return app;
        }
        char chData = source.readOrDie();
        if (chData != '.') {
            source.unread(chData);
            return app;
        }
        app.append(".");
        boolean hasAppended = false;
        while (source.hasMore() || !hasAppended) {
            chData = source.readOrDie();
            if (!JsNumber.isLatinDigit(chData)) {
                if (!hasAppended) {
                    throw new JsParseException(ERRMSG_INVFRAC, source.getLineNumber());
                }
                source.unread(chData);
                break;
            }
            app.append(chData);
            hasAppended = true;
        }
        return app;
    }

    private static Appendable appendExpPart(JsonSource source, Appendable app) throws IOException, JsParseException {
        if (!source.hasMore()) {
            return app;
        }
        char chData = source.readOrDie();
        if (chData != 'e' && chData != 'E') {
            source.unread(chData);
            return app;
        }
        app.append('E');
        JsNumber.appendDigitText(source, app, true);
        return app;
    }

    static JsNumber parseNumber(JsonSource source) throws IOException, JsParseException {
        char charHead = source.readOrDie();
        source.unread(charHead);
        if (charHead != '-' && !JsNumber.isLatinDigit(charHead)) {
            return null;
        }
        StringBuilder numText = new StringBuilder();
        JsNumber.appendDigitText(source, numText, false);
        JsNumber.appendFractionPart(source, numText);
        JsNumber.appendExpPart(source, numText);
        JsNumber result = new JsNumber(numText);
        return result;
    }

    @Override
    public JsTypes getJsTypes() {
        return JsTypes.NUMBER;
    }

    @Override
    public void traverse(ValueVisitor visitor) throws JsVisitException {
        visitor.visitValue(this);
    }

    public int hashCode() {
        return this.decimal.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsNumber)) {
            return false;
        }
        JsNumber number = (JsNumber)obj;
        return this.decimal.equals(number.decimal);
    }

    @Override
    public int compareTo(JsNumber value) {
        if (this == value) {
            return 0;
        }
        return this.decimal.compareTo(value.decimal);
    }

    public int intValue() {
        return this.decimal.intValue();
    }

    public long longValue() {
        return this.decimal.longValue();
    }

    public float floatValue() {
        return this.decimal.floatValue();
    }

    public double doubleValue() {
        return this.decimal.doubleValue();
    }

    public BigDecimal decimalValue() {
        return this.decimal;
    }

    public int scale() {
        return this.decimal.scale();
    }

    public String toString() {
        return this.decimal.toString();
    }
}

