/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.jindolf.archiver.XmlOut;
import jp.sourceforge.jindolf.corelib.PreDefAvatar;
import org.xml.sax.SAXException;

public class AvatarData {
    private static final List<PreDefAvatar> PREDEF_AVATAR_LIST;
    private String fullName;
    private String shortName;
    private String avatarId;
    private String faceIconUri;

    public AvatarData() {
    }

    public AvatarData(PreDefAvatar predefAvatar) {
        this();
        this.fullName = predefAvatar.getFullName();
        this.shortName = predefAvatar.getShortName();
        this.avatarId = predefAvatar.getAvatarId();
        this.faceIconUri = null;
    }

    public static PreDefAvatar getPreDefAvatar(CharSequence seq) {
        for (PreDefAvatar avatar : PREDEF_AVATAR_LIST) {
            String fullName = avatar.getFullName();
            if (!fullName.contentEquals(seq)) continue;
            return avatar;
        }
        return null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(String avatarId) {
        this.avatarId = avatarId;
    }

    public String getFaceIconUri() {
        return this.faceIconUri;
    }

    public void setFaceIconUri(String faceIconUri) {
        this.faceIconUri = faceIconUri;
    }

    public void dumpXml(XmlOut writer) throws IOException {
        writer.append("<avatar");
        writer.nl();
        writer.indent(1);
        writer.attrOut("avatarId", this.avatarId);
        writer.nl();
        writer.indent(1);
        writer.attrOut("fullName", this.fullName);
        writer.sp();
        writer.attrOut("shortName", this.shortName);
        writer.nl();
        if (this.faceIconUri != null) {
            writer.indent(1);
            writer.attrOut("faceIconURI", this.faceIconUri);
            writer.nl();
        }
        writer.append("/>");
        writer.nl();
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            PREDEF_AVATAR_LIST = PreDefAvatar.buildPreDefAvatarList(builder);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

