/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import jp.sourceforge.jindolf.archiver.Handler;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.parser.ContentBuilder;
import jp.sourceforge.jindolf.parser.ContentBuilderSJ;
import jp.sourceforge.jindolf.parser.ContentBuilderUCS2;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import jp.sourceforge.jindolf.parser.HtmlParser;
import jp.sourceforge.jindolf.parser.SjisDecoder;
import jp.sourceforge.jindolf.parser.StreamDecoder;

public final class Builder {
    private static final int BUF_SZ = 102400;

    private Builder() {
        assert (false);
        throw new AssertionError();
    }

    public static DecodedContent contentFromStream(Charset charset, InputStream istream) throws IOException, DecodeException {
        ContentBuilder builder;
        StreamDecoder decoder;
        String name = charset.name();
        if ("Shift_JIS".equalsIgnoreCase(name)) {
            decoder = new SjisDecoder();
            builder = new ContentBuilderSJ(102400);
        } else if ("UTF-8".equalsIgnoreCase(name)) {
            decoder = new StreamDecoder(charset.newDecoder());
            builder = new ContentBuilderUCS2(102400);
        } else {
            assert (false);
            return null;
        }
        decoder.setDecodeHandler(builder);
        decoder.decode(istream);
        DecodedContent content = builder.getContent();
        return content;
    }

    public static void fillVillageData(VillageData villageData) throws IOException, DecodeException, HtmlParseException {
        HtmlParser parser = new HtmlParser();
        Handler handler = new Handler();
        parser.setBasicHandler(handler);
        parser.setTalkHandler(handler);
        parser.setSysEventHandler(handler);
        handler.initVillageData(villageData);
        Charset charset = villageData.getLandDef().getEncoding();
        for (PeriodResource resource : villageData.getPeriodResourceList()) {
            DecodedContent content;
            handler.initPeriodResource(resource);
            URL url = resource.getResourceUrl();
            if (url == null) {
                url = new URL(resource.getOrigUrlText());
            }
            URLConnection conn = url.openConnection();
            try (InputStream istream = conn.getInputStream();){
                if (resource.getDownTimeMs() <= 0L) {
                    long downTimeMs = conn.getDate();
                    resource.setDownTimeMs(downTimeMs);
                }
                content = Builder.contentFromStream(charset, istream);
            }
            parser.parseAutomatic(content);
        }
    }
}

