/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import javax.xml.validation.Validator;
import jp.sourceforge.jindolf.archiver.Builder;
import jp.sourceforge.jindolf.archiver.DumpXmlTask;
import jp.sourceforge.jindolf.archiver.HttpAccess;
import jp.sourceforge.jindolf.archiver.OptArg;
import jp.sourceforge.jindolf.archiver.OptInfo;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.ProdCons;
import jp.sourceforge.jindolf.archiver.SnifWriter;
import jp.sourceforge.jindolf.archiver.ValidateTask;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.archiver.XmlOut;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import org.xml.sax.SAXException;

public final class JinArchiver {
    public static final String GENERATOR;
    private static final Class<?> SELF_KLASS;
    private static final Package SELF_PACKAGE;
    private static final String TITLE;
    private static final String VERSION;
    private static final String RES_VERDEF = "resources/version.properties";
    private static final String FORM_FILENAME = "jin_{0}_{1,number,#00000}.xml";
    private static final Charset CS_UTF8;

    private JinArchiver() {
        assert (false);
        throw new AssertionError();
    }

    private static Properties loadVersionDefinition(Class<?> klass) {
        Properties result = new Properties();
        try (InputStream istream = klass.getResourceAsStream(RES_VERDEF);){
            result.load(istream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static String getPackageInfo(Properties prop, String prefix, String defValue) {
        return JinArchiver.getPackageInfo(prop, SELF_PACKAGE, prefix, defValue);
    }

    private static String getPackageInfo(Properties prop, Package pkg, String prefix, String defValue) {
        String propName = prefix + pkg.getName();
        String result = prop.getProperty(propName, defValue);
        return result;
    }

    private static void errprintln(CharSequence text) {
        System.err.println(text);
    }

    private static void exit(int code) {
        System.exit(code);
        assert (false);
    }

    private static void helpMessage() {
        String msg = OptArg.getHelpMessage(GENERATOR);
        JinArchiver.errprintln(msg);
    }

    private static void dumpOut(OptInfo optInfo) {
        VillageData villageData;
        Validator validator;
        String outdir = optInfo.getOutdir();
        LandDef landDef = optInfo.getLandDef();
        int vid = optInfo.getVid();
        try {
            validator = XmlUtils.createValidator();
        }
        catch (SAXException e) {
            JinArchiver.abortWithException(e, "\u51e6\u7406\u3092\u7d9a\u884c\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        Writer writer = outdir != null ? JinArchiver.getFileWriter(outdir, landDef, vid) : JinArchiver.getStdOutWriter();
        try {
            villageData = JinArchiver.load(landDef, vid);
        }
        catch (IOException e) {
            JinArchiver.abortWithException(e);
            return;
        }
        catch (DecodeException e) {
            JinArchiver.abortWithException(e);
            return;
        }
        catch (HtmlParseException e) {
            JinArchiver.abortWithException(e);
            return;
        }
        SnifWriter snifWriter = new SnifWriter(writer);
        Reader reader = snifWriter.getSnifReader();
        writer = new BufferedWriter(snifWriter);
        reader = new BufferedReader(reader);
        XmlOut xmlOut = new XmlOut(writer);
        Charset cs = landDef.getEncoding();
        xmlOut.setSourceCharset(cs);
        ValidateTask valTask = new ValidateTask(reader, validator);
        DumpXmlTask dumpTask = new DumpXmlTask(villageData, xmlOut);
        ProdCons taskman = new ProdCons(dumpTask, valTask);
        try {
            taskman.submit();
        }
        catch (InterruptedException e) {
            JinArchiver.abortWithException(e);
        }
        if (taskman.hasError()) {
            Throwable cause = taskman.getCause();
            String desc = taskman.getErrDescription();
            JinArchiver.abortWithException(cause, desc);
            assert (false);
        }
    }

    private static void abortWithException(Throwable e) {
        JinArchiver.abortWithException(e, "\u51e6\u7406\u3092\u7d9a\u884c\u3067\u304d\u307e\u305b\u3093\u3002");
        JinArchiver.exit(1);
    }

    private static void abortWithException(Throwable e, String desc) {
        e.printStackTrace(System.err);
        JinArchiver.errprintln(desc);
        JinArchiver.exit(1);
    }

    public static VillageData load(LandDef landDef, int vid) throws IOException, DecodeException, HtmlParseException {
        List<PeriodResource> resourceList = HttpAccess.loadResourceList(landDef, vid);
        VillageData villageData = new VillageData(resourceList);
        Builder.fillVillageData(villageData);
        return villageData;
    }

    public static Writer getStdOutWriter() {
        Writer writer;
        BufferedOutputStream ostream = new BufferedOutputStream(System.out);
        try {
            writer = new OutputStreamWriter((OutputStream)ostream, "UTF-8");
            writer = new BufferedWriter(writer, 4096);
        }
        catch (IOException e) {
            JinArchiver.errprintln("\u6a19\u6e96\u51fa\u529b\u306b\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093\u3002");
            JinArchiver.exit(1);
            return null;
        }
        return writer;
    }

    private static void probeOutDirectory(File outFile) {
        String errMsg = null;
        if (!outFile.exists()) {
            errMsg = outFile.toString() + " \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
        } else if (!outFile.isDirectory()) {
            errMsg = outFile.toString() + " \u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002";
        } else if (!outFile.canWrite()) {
            errMsg = outFile.toString() + " \u306b\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093\u3002";
        }
        if (errMsg != null) {
            JinArchiver.errprintln(errMsg);
            JinArchiver.exit(1);
            assert (false);
        }
    }

    private static void createFile(File file) {
        String errMsg = null;
        try {
            boolean created = file.createNewFile();
            if (!created) {
                errMsg = file.getName() + " \u304c\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002";
            }
        }
        catch (IOException e) {
            errMsg = file.getName() + " \u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002";
        }
        if (errMsg != null) {
            JinArchiver.errprintln(errMsg);
            JinArchiver.exit(1);
            assert (false);
        }
    }

    public static Writer getFileWriter(String outdir, LandDef landDef, int vid) {
        OutputStream ostream;
        File outFile = new File(outdir);
        JinArchiver.probeOutDirectory(outFile);
        String fname = MessageFormat.format(FORM_FILENAME, landDef.getLandId(), vid);
        File xmlFile = new File(outFile, fname);
        JinArchiver.createFile(xmlFile);
        try {
            ostream = new FileOutputStream(xmlFile);
        }
        catch (FileNotFoundException e) {
            JinArchiver.errprintln(xmlFile.getName() + " \u306b\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093\u3002");
            JinArchiver.exit(1);
            return null;
        }
        ostream = new BufferedOutputStream(ostream, 4096);
        Writer writer = new OutputStreamWriter(ostream, CS_UTF8);
        writer = new BufferedWriter(writer, 4096);
        return writer;
    }

    public static void main(String[] args) {
        OptInfo optInfo = OptInfo.parseOptInfo(args);
        if (optInfo.isHelp()) {
            JinArchiver.helpMessage();
            JinArchiver.exit(0);
            assert (false);
            return;
        }
        if (optInfo.hasError()) {
            String errMsg = optInfo.getErrMsg();
            JinArchiver.errprintln(errMsg);
            JinArchiver.exit(1);
            assert (false);
            return;
        }
        JinArchiver.dumpOut(optInfo);
        JinArchiver.exit(0);
        assert (false);
    }

    static {
        CS_UTF8 = Charset.forName("UTF-8");
        SELF_KLASS = JinArchiver.class;
        SELF_PACKAGE = SELF_KLASS.getPackage();
        Properties verProp = JinArchiver.loadVersionDefinition(SELF_KLASS);
        TITLE = JinArchiver.getPackageInfo(verProp, "pkg-title.", "Unknown");
        VERSION = JinArchiver.getPackageInfo(verProp, "pkg-version.", "0");
        GENERATOR = TITLE + " " + VERSION;
    }
}

