/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.Callable;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class ValidateTask
implements Callable<Void> {
    private static final String ERR_IO = "XML\u5165\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    private static final String ERR_XSD = "XML\u691c\u8a3c\u304c\u5931\u6557\u3057\u307e\u3057\u305f";
    private static final String ERR_ABORT = "XML\u691c\u8a3c\u304c\u4e2d\u65ad\u3055\u308c\u307e\u3057\u305f";
    private final Reader reader;
    private final Source source;
    private final Validator validator;

    public ValidateTask(Reader reader, Validator valid) {
        this.reader = reader;
        this.source = new StreamSource(this.reader);
        this.validator = valid;
    }

    public static String getErrDescription(Throwable cause) {
        String desc = cause instanceof IOException ? ERR_IO : (cause instanceof SAXException ? ERR_XSD : ERR_ABORT);
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws IOException, SAXException {
        try {
            this.validator.validate(this.source);
        }
        finally {
            this.reader.close();
        }
        return null;
    }
}

