/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import jp.sourceforge.jindolf.parser.DecodeErrorInfo;
import jp.sourceforge.jindolf.parser.DecodedContent;

public final class Win31j {
    public static final char REP_CHAR = '\ufffd';
    public static final Charset CS_WIN31J = Charset.forName("windows-31j");
    private static final CharsetDecoder WIN31JDECODER;
    private static final ByteBuffer BYTEBUFFER;

    private Win31j() {
        assert (false);
        throw new AssertionError();
    }

    public static synchronized char getWin31jChar(byte b1, byte b2) {
        char replaced;
        WIN31JDECODER.reset();
        BYTEBUFFER.clear();
        BYTEBUFFER.put(b1).put(b2);
        BYTEBUFFER.flip();
        try {
            replaced = WIN31JDECODER.decode(BYTEBUFFER).charAt(0);
        }
        catch (CharacterCodingException e) {
            replaced = '\ufffd';
        }
        return replaced;
    }

    public static char getWin31jChar(DecodeErrorInfo info) {
        if (!info.has2nd()) {
            return '\ufffd';
        }
        byte b1 = info.getRawByte1st();
        byte b2 = info.getRawByte2nd();
        char replaceChar = Win31j.getWin31jChar(b1, b2);
        return replaceChar;
    }

    public static void supplyWin31jChar(DecodedContent content) {
        if (!content.hasDecodeError()) {
            return;
        }
        for (DecodeErrorInfo info : content.getDecodeErrorList()) {
            int pos = info.getCharPosition();
            char replaceChar = Win31j.getWin31jChar(info);
            content.setCharAt(pos, replaceChar);
        }
    }

    static {
        BYTEBUFFER = ByteBuffer.allocate(2);
        WIN31JDECODER = CS_WIN31J.newDecoder();
        WIN31JDECODER.onMalformedInput(CodingErrorAction.REPORT);
        WIN31JDECODER.onUnmappableCharacter(CodingErrorAction.REPORT);
        WIN31JDECODER.reset();
        BYTEBUFFER.clear();
    }
}

