/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XmlResolver
implements LSResourceResolver {
    private static final String RES_XMLXSD = "resources/xmldummy.xsd";
    private static final String RES_COREXSD = "resources/coreType-090929.xsd";
    private static final String RES_BBSXSD = "resources/bbsArchive-110421.xsd";
    private static final String RES_BBSDTD = "resources/bbsArchive-110421.dtd";
    private static final String URI_XMLXSD = "http://www.w3.org/2001/xml.xsd";
    private static final String URI_COREXSD = "http://jindolf.sourceforge.jp/xml/xsd/coreType-090929.xsd";
    private static final String URI_BBSXSD = "http://jindolf.sourceforge.jp/xml/xsd/bbsArchive-110421.xsd";
    private static final String URI_BBSDTD = "http://jindolf.sourceforge.jp/xml/dtd/bbsArchive-110421.dtd";
    private static final DOMImplementationLS DOM_LS;
    private final Map<URI, URI> uriMap = new HashMap<URI, URI>();

    public XmlResolver() {
        this.setUriMap();
    }

    private static DOMImplementationLS buildDomImplLS() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation domImp = builder.getDOMImplementation();
        Object feature = domImp.getFeature("LS", "3.0");
        assert (feature instanceof DOMImplementationLS);
        DOMImplementationLS result = (DOMImplementationLS)feature;
        return result;
    }

    public static URI buildBaseRelativeURI(String base, String relative) throws URISyntaxException, IllegalArgumentException {
        URI baseURI;
        if (base != null) {
            baseURI = new URI(base);
            if (!baseURI.isAbsolute()) {
                throw new IllegalArgumentException();
            }
        } else {
            baseURI = null;
        }
        URI relativeURI = relative != null ? new URI(relative) : URI.create("");
        URI resultURI = baseURI == null || relativeURI.isAbsolute() ? relativeURI : baseURI.resolve(relativeURI);
        if (!resultURI.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        resultURI = resultURI.normalize();
        return resultURI;
    }

    private void setUriMap() {
        try {
            this.putMap(URI_BBSDTD, RES_BBSDTD);
            this.putMap(URI_BBSXSD, RES_BBSXSD);
            this.putMap(URI_COREXSD, RES_COREXSD);
            this.putMap(URI_XMLXSD, RES_XMLXSD);
        }
        catch (URISyntaxException e) {
            assert (false);
            return;
        }
    }

    private void putMap(String uri, String resource) throws URISyntaxException {
        URI orig = new URI(uri);
        Class<?> klass = this.getClass();
        URL resUrl = klass.getResource(resource);
        URI resUri = resUrl.toURI();
        orig = orig.normalize();
        resUri = resUri.normalize();
        this.uriMap.put(orig, resUri);
    }

    private URI resolveMap(URI origUri) {
        URI key = origUri.normalize();
        URI result = this.uriMap.get(key);
        if (result == null) {
            result = origUri;
        }
        return result;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputStream resourceStream;
        URL resourceUrl;
        URI origUri;
        try {
            origUri = XmlResolver.buildBaseRelativeURI(baseURI, systemId);
        }
        catch (URISyntaxException e) {
            assert (false);
            return null;
        }
        URI resourceUri = this.resolveMap(origUri);
        try {
            resourceUrl = resourceUri.toURL();
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        try {
            resourceStream = resourceUrl.openStream();
        }
        catch (IOException e) {
            assert (false);
            return null;
        }
        LSInput result = DOM_LS.createLSInput();
        result.setBaseURI(baseURI);
        result.setPublicId(publicId);
        result.setSystemId(systemId);
        result.setByteStream(resourceStream);
        return result;
    }

    static {
        try {
            DOM_LS = XmlResolver.buildDomImplLS();
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

