/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.corelib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import jp.sourceforge.jindolf.corelib.DomUtils;
import jp.sourceforge.jindolf.corelib.XmlResource;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class PreDefAvatar {
    private final String avatarId;
    private final String fullName;
    private final String jobTitle;
    private final String shortName;
    private final int serialNo;

    private PreDefAvatar(String avatarId, String fullName, String jobTitle, String shortName, int serialNo) {
        if (avatarId == null || fullName == null || jobTitle == null || shortName == null) {
            throw new NullPointerException();
        }
        if (avatarId.length() <= 0 || fullName.length() <= 0 || serialNo < 0) {
            throw new IllegalArgumentException();
        }
        this.avatarId = avatarId.intern();
        this.fullName = fullName.intern();
        this.jobTitle = jobTitle.intern();
        this.shortName = shortName.intern();
        this.serialNo = serialNo;
    }

    public static List<PreDefAvatar> buildPreDefAvatarList(DocumentBuilder builder) throws IOException, SAXException {
        List<Element> elemList = DomUtils.loadElemList(builder, XmlResource.I_URL_AVATARDEF, "preDefinedAvatar");
        ArrayList<PreDefAvatar> result = new ArrayList(elemList.size());
        for (Element elem : elemList) {
            PreDefAvatar avatar = PreDefAvatar.buildAvatar(elem);
            result.add(avatar);
        }
        result = Collections.unmodifiableList(result);
        return result;
    }

    private static PreDefAvatar buildAvatar(Element avatarDef) throws SAXException {
        int serialNo;
        String avatarId = avatarDef.getAttribute("avatarId");
        String jobTitle = avatarDef.getAttribute("jobTitle");
        String shortName = avatarDef.getAttribute("shortName");
        String serialNum = avatarDef.getAttribute("serialNum");
        String fullName = jobTitle + " " + shortName;
        try {
            serialNo = Integer.parseInt(serialNum);
        }
        catch (NumberFormatException e) {
            throw new SAXException("illegal number form", e);
        }
        PreDefAvatar avatar = new PreDefAvatar(avatarId, fullName, jobTitle, shortName, serialNo);
        return avatar;
    }

    public String getAvatarId() {
        return this.avatarId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getSerialNo() {
        return this.serialNo;
    }
}

