/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.SeqRange;

public class EntityConverter {
    private static final char DQ_CH = '\"';
    private static final String DQ_STR = Character.toString('\"');
    private static final String YEN_STR = "\u00a5";
    private static final char BS_CH = '\\';
    private static final String BS_STR = Character.toString('\\');
    private static final String BS_PATTERN = BS_STR + BS_STR;
    private static final String UCS4_PATTERN = "[\\x{10000}-\\x{10ffff}]";
    private static final RegexRep[] VALUES_CACHE = RegexRep.values();
    private final Matcher matcher = RegexRep.access$000();
    private final boolean replaceSmp;

    public EntityConverter() {
        this(false);
    }

    public EntityConverter(boolean replaceSmp) {
        this.replaceSmp = replaceSmp;
    }

    public DecodedContent convert(DecodedContent content) {
        int startPos = 0;
        int endPos = content.length();
        return this.append(null, content, startPos, endPos);
    }

    public DecodedContent convert(DecodedContent content, SeqRange range) throws IndexOutOfBoundsException {
        int startPos = range.getStartPos();
        int endPos = range.getEndPos();
        return this.append(null, content, startPos, endPos);
    }

    public DecodedContent convert(DecodedContent content, int startPos, int endPos) throws IndexOutOfBoundsException {
        return this.append(null, content, startPos, endPos);
    }

    public DecodedContent append(DecodedContent target, DecodedContent content) throws IndexOutOfBoundsException {
        int startPos = 0;
        int endPos = content.length();
        return this.append(target, content, startPos, endPos);
    }

    public DecodedContent append(DecodedContent target, DecodedContent content, SeqRange range) throws IndexOutOfBoundsException {
        int startPos = range.getStartPos();
        int endPos = range.getEndPos();
        return this.append(target, content, startPos, endPos);
    }

    public DecodedContent append(DecodedContent target, DecodedContent content, int startPos, int endPos) throws IndexOutOfBoundsException {
        DecodedContent result;
        if (startPos > endPos || startPos < 0 || content.length() < endPos) {
            throw new IndexOutOfBoundsException();
        }
        if (target == null) {
            int length = endPos - startPos;
            result = new DecodedContent(length);
        } else {
            result = target;
        }
        this.matcher.reset(content.getRawContent());
        this.matcher.region(startPos, endPos);
        int copiedPos = startPos;
        while (this.matcher.find()) {
            int group = -1;
            int matchStart = -1;
            String altTxt = "";
            for (RegexRep rr : VALUES_CACHE) {
                group = rr.getGroupNo();
                matchStart = this.matcher.start(group);
                if (matchStart < 0) continue;
                if (rr == RegexRep.UCS4 && !this.replaceSmp) {
                    altTxt = this.matcher.group(group);
                    break;
                }
                altTxt = rr.getAltTxt();
                break;
            }
            assert (group >= 1);
            int matchEnd = this.matcher.end(group);
            result.append(content, copiedPos, matchStart);
            result.append(altTxt);
            copiedPos = matchEnd;
        }
        result.append(content, copiedPos, endPos);
        this.matcher.reset("");
        return result;
    }

    static /* synthetic */ String access$300() {
        return DQ_STR;
    }

    static /* synthetic */ String access$400() {
        return BS_PATTERN;
    }

    private static enum RegexRep {
        GT("&gt;", ">"),
        LT("&lt;", "<"),
        AMP("&amp;", "&"),
        QUAT("&quot;", EntityConverter.access$300()),
        BS(EntityConverter.access$400(), "\u00a5"),
        UCS4("[\\x{10000}-\\x{10ffff}]", "?");

        private final String regex;
        private final String altTxt;

        private RegexRep(String regex, String altTxt) {
            this.regex = regex;
            this.altTxt = altTxt;
        }

        private static Pattern buildPattern() {
            StringBuilder orRegex = new StringBuilder();
            for (RegexRep rr : RegexRep.values()) {
                if (orRegex.length() > 0) {
                    orRegex.append('|');
                }
                orRegex.append('(');
                orRegex.append(rr.regex);
                orRegex.append(')');
            }
            Pattern result = Pattern.compile(orRegex.toString());
            return result;
        }

        private static Matcher buildMatcher() {
            Pattern pattern = RegexRep.buildPattern();
            Matcher result = pattern.matcher("");
            return result;
        }

        private String getAltTxt() {
            return this.altTxt;
        }

        private int getGroupNo() {
            int group = this.ordinal() + 1;
            return group;
        }

        static /* synthetic */ Matcher access$000() {
            return RegexRep.buildMatcher();
        }
    }
}

