/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Locale;

public final class FileUtils {
    private static final Class<?> THISKLASS;
    private static final String LANG_JA = "ja";
    private static final String SYSPROP_OSNAME = "os.name";
    private static final String SCHEME_FILE = "file";
    private static final String ENTITY_YEN = "&yen;";
    private static final Method METHOD_SETREADABLE;
    private static final Method METHOD_SETWRITABLE;
    private static final Locale ROOT;

    private FileUtils() {
        assert (this.getClass() == THISKLASS);
    }

    private static boolean reflectFilePermOp(Method method, File file, boolean flag, boolean ownerOnly) throws InvocationTargetException {
        Object result;
        try {
            result = method.invoke((Object)file, flag, ownerOnly);
        }
        catch (IllegalAccessException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        catch (ExceptionInInitializerError e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        assert (result instanceof Boolean);
        Boolean boolResult = (Boolean)result;
        return boolResult;
    }

    private static boolean invokeFilePermOp(Method method, File file, boolean flag, boolean ownerOnly) throws SecurityException {
        boolean result;
        try {
            result = FileUtils.reflectFilePermOp(method, file, flag, ownerOnly);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SecurityException) {
                throw (SecurityException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            assert (false);
            throw new AssertionError((Object)e);
        }
        return result;
    }

    public static boolean setReadable(File file, boolean flag, boolean ownerOnly) throws SecurityException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (METHOD_SETREADABLE == null) {
            return false;
        }
        boolean result = FileUtils.invokeFilePermOp(METHOD_SETREADABLE, file, flag, ownerOnly);
        return result;
    }

    public static boolean setWritable(File file, boolean flag, boolean ownerOnly) throws SecurityException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (METHOD_SETWRITABLE == null) {
            return false;
        }
        boolean result = FileUtils.invokeFilePermOp(METHOD_SETWRITABLE, file, flag, ownerOnly);
        return result;
    }

    public static boolean setOwnerOnlyAccess(File file) throws SecurityException {
        boolean result = true;
        result &= FileUtils.setReadable(file, false, false);
        result &= FileUtils.setReadable(file, true, true);
        result &= FileUtils.setWritable(file, false, false);
        return result &= FileUtils.setWritable(file, true, true);
    }

    public static File findExistsAncestor(File file) throws IllegalArgumentException {
        if (file == null) {
            return null;
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (file.exists()) {
            return file;
        }
        File parent = file.getParentFile();
        return FileUtils.findExistsAncestor(parent);
    }

    public static File findRootFile(File file) throws IllegalArgumentException {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return file;
        }
        return FileUtils.findRootFile(parent);
    }

    public static File supplyFullPath(File file) {
        File absFile;
        if (file.isAbsolute()) {
            return file;
        }
        try {
            absFile = file.getAbsoluteFile();
        }
        catch (SecurityException e) {
            return file;
        }
        return absFile;
    }

    public static boolean isAccessibleDirectory(File path) {
        if (path == null) {
            return false;
        }
        boolean result = true;
        if (!path.exists()) {
            result = false;
        } else if (!path.isDirectory()) {
            result = false;
        } else if (!path.canRead()) {
            result = false;
        } else if (!path.canWrite()) {
            result = false;
        }
        return result;
    }

    public static File getClassSourceFile(Class<?> klass) {
        URI uri;
        ProtectionDomain domain;
        try {
            domain = klass.getProtectionDomain();
        }
        catch (SecurityException e) {
            return null;
        }
        CodeSource src = domain.getCodeSource();
        URL location = src.getLocation();
        String scheme = location.getProtocol();
        if (!scheme.equals(SCHEME_FILE)) {
            return null;
        }
        try {
            uri = location.toURI();
        }
        catch (URISyntaxException e) {
            assert (false);
            return null;
        }
        File file = new File(uri);
        return file;
    }

    public static boolean isExistsJarFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        String name = file.getName();
        return name.matches("^.+\\.[jJ][aA][rR]$");
    }

    public static File getJarDirectory(Class<?> klass) {
        File jarFile = FileUtils.getClassSourceFile(klass);
        if (jarFile == null) {
            return null;
        }
        if (!FileUtils.isExistsJarFile(jarFile)) {
            return null;
        }
        return jarFile.getParentFile();
    }

    public static File getJarDirectory() {
        return FileUtils.getJarDirectory(THISKLASS);
    }

    public static File getHomeDirectory() {
        String homeProp;
        try {
            homeProp = System.getProperty("user.home");
        }
        catch (SecurityException e) {
            return null;
        }
        File homeFile = new File(homeProp);
        return homeFile;
    }

    public static boolean isMacOSXFs() {
        String osName;
        if (File.separatorChar != '/') {
            return false;
        }
        try {
            osName = System.getProperty(SYSPROP_OSNAME);
        }
        catch (SecurityException e) {
            return false;
        }
        if (osName == null) {
            return false;
        }
        return (osName = osName.toLowerCase(ROOT)).startsWith("mac os x");
    }

    public static boolean isWindowsOSFs() {
        String osName;
        if (File.separatorChar != '\\') {
            return false;
        }
        try {
            osName = System.getProperty(SYSPROP_OSNAME);
        }
        catch (SecurityException e) {
            return false;
        }
        if (osName == null) {
            return false;
        }
        return (osName = osName.toLowerCase(ROOT)).startsWith("windows");
    }

    public static File getAppSetDir() {
        File home = FileUtils.getHomeDirectory();
        if (home == null) {
            return null;
        }
        File result = home;
        if (FileUtils.isMacOSXFs()) {
            result = new File(result, "Library");
            result = new File(result, "Application Support");
        }
        return result;
    }

    public static String getHtmledFileName(File file) {
        String pathName = file.getPath();
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        if (FileUtils.isWindowsOSFs() && lang.equals(LANG_JA)) {
            pathName = pathName.replace(File.separator, ENTITY_YEN);
        }
        return "<code>" + pathName + "</code>";
    }

    static {
        int modifiers;
        Method method;
        THISKLASS = FileUtils.class;
        ROOT = new Locale("", "", "");
        try {
            method = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                method = null;
            }
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        catch (SecurityException e) {
            method = null;
        }
        METHOD_SETREADABLE = method;
        try {
            method = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
            modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                method = null;
            }
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        catch (SecurityException e) {
            method = null;
        }
        METHOD_SETWRITABLE = method;
        assert (!FileUtils.isMacOSXFs() || !FileUtils.isWindowsOSFs());
        new FileUtils().hashCode();
    }
}

