/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.nio.charset.Charset;

public final class ShiftJis {
    public static final String ENCODE_NAME = "Shift_JIS";
    public static final Charset CHARSET = Charset.forName("Shift_JIS");
    public static final int MAX_BYTES_PER_CHAR = 2;

    private ShiftJis() {
    }

    public static boolean isShiftJIS1stByte(byte bval) {
        boolean result = -127 <= bval && bval <= -97 || -32 <= bval && bval <= -4;
        return result;
    }

    public static boolean isShiftJIS2ndByte(byte bval) {
        boolean result = 64 <= bval && bval <= 126 || -128 <= bval && bval <= -4;
        return result;
    }

    public static boolean isShiftJIS(byte b1st, byte b2nd) {
        boolean result = ShiftJis.isShiftJIS1stByte(b1st) && ShiftJis.isShiftJIS2ndByte(b2nd);
        return result;
    }
}

