/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.DecodeHandler;

public class StreamDecoder {
    public static final int BYTEBUF_DEFSZ = 4096;
    public static final int CHARBUF_DEFSZ = 4096;
    private final CharsetDecoder decoder;
    private ReadableByteChannel channel;
    private final ByteBuffer byteBuffer;
    private final CharBuffer charBuffer;
    private boolean isEndOfInput;
    private boolean isFlushing;
    private DecodeHandler decodeHandler;
    private byte[] errorData = new byte[4];

    public StreamDecoder(CharsetDecoder decoder) {
        this(decoder, 4096, 4096);
    }

    public StreamDecoder(CharsetDecoder decoder, int inbufSz, int outbufSz) throws NullPointerException, IllegalArgumentException {
        if (decoder == null) {
            throw new NullPointerException();
        }
        if (inbufSz <= 0 || outbufSz <= 0) {
            throw new IllegalArgumentException();
        }
        this.decoder = decoder;
        this.byteBuffer = ByteBuffer.allocate(inbufSz);
        this.charBuffer = CharBuffer.allocate(outbufSz);
        this.channel = null;
        this.initDecoderImpl();
    }

    private void initDecoderImpl() {
        this.byteBuffer.clear().flip();
        this.charBuffer.clear();
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.decoder.reset();
        this.isEndOfInput = false;
        this.isFlushing = false;
        Arrays.fill(this.errorData, (byte)0);
    }

    protected void initDecoder() {
        this.initDecoderImpl();
    }

    protected ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    protected CharBuffer getCharBuffer() {
        return this.charBuffer;
    }

    public void setDecodeHandler(DecodeHandler decodeHandler) {
        this.decodeHandler = decodeHandler;
    }

    protected void reassignErrorData(int size) {
        int oldLength = this.errorData.length;
        if (oldLength >= size) {
            return;
        }
        int newSize = size;
        if (oldLength * 2 > newSize) {
            newSize = oldLength * 2;
        }
        byte[] newData = new byte[newSize];
        System.arraycopy(this.errorData, 0, newData, 0, oldLength);
        this.errorData = newData;
    }

    protected void flushContent() throws DecodeException {
        if (this.charBuffer.position() <= 0) {
            return;
        }
        this.charBuffer.flip();
        this.decodeHandler.charContent(this.charBuffer);
        this.charBuffer.clear();
    }

    protected void putDecodeError(CoderResult result) throws IOException, DecodeException {
        int length = this.chopErrorSequence(result);
        this.decodeHandler.decodingError(this.errorData, 0, length);
    }

    protected int chopErrorSequence(CoderResult result) throws IOException {
        int errorLength = result.length();
        this.reassignErrorData(errorLength);
        this.byteBuffer.get(this.errorData, 0, errorLength);
        return errorLength;
    }

    protected int readByteBuffer() throws IOException {
        this.byteBuffer.compact();
        int length = this.channel.read(this.byteBuffer);
        if (length <= 0) {
            this.isEndOfInput = true;
        }
        this.byteBuffer.flip();
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(InputStream istream) throws IOException, DecodeException {
        this.channel = Channels.newChannel(istream);
        try {
            this.decodeChannel();
        }
        finally {
            this.channel.close();
            this.channel = null;
            istream.close();
        }
    }

    protected void decodeChannel() throws IOException, DecodeException {
        block6: {
            this.initDecoder();
            this.decodeHandler.startDecoding(this.decoder);
            while (true) {
                CoderResult result;
                if ((result = this.isFlushing ? this.decoder.flush(this.charBuffer) : this.decoder.decode(this.byteBuffer, this.charBuffer, this.isEndOfInput)).isError()) {
                    this.flushContent();
                    this.putDecodeError(result);
                    continue;
                }
                if (result.isOverflow()) {
                    this.flushContent();
                    continue;
                }
                if (result.isUnderflow()) {
                    if (!this.isEndOfInput) {
                        this.readByteBuffer();
                        continue;
                    }
                    if (!this.isFlushing) {
                        this.isFlushing = true;
                        continue;
                    }
                    break block6;
                }
                if (!$assertionsDisabled) break;
            }
            throw new AssertionError();
        }
        this.flushContent();
        this.decodeHandler.endDecoding();
    }
}

