/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.jindolf.parser.content;

import io.bitbucket.olyutorskii.jiocema.CharDecodeListener;
import io.bitbucket.olyutorskii.jiocema.DecodeBreakException;
import java.nio.charset.CharsetDecoder;
import jp.osdn.jindolf.parser.content.DecodedContent;

public class ContentBuilder
implements CharDecodeListener {
    private static final int DEF_CAPA_SZ = 128;
    private final DecodedContent content;

    public ContentBuilder() {
        this(128);
    }

    public ContentBuilder(int capacity) throws NegativeArraySizeException {
        this.content = new DecodedContent(capacity);
    }

    public DecodedContent getContent() {
        return this.content;
    }

    @Override
    public void startDecoding(CharsetDecoder decoder) throws DecodeBreakException {
        this.content.init();
    }

    @Override
    public void endDecoding() throws DecodeBreakException {
    }

    @Override
    public void rawBytes(byte[] byteArray, int offset, int length) {
    }

    @Override
    public void charContent(char[] charArray, int offset, int length) throws DecodeBreakException {
        if (length > 0) {
            char ch1st = charArray[0];
            assert (!Character.isLowSurrogate(ch1st));
            char chLast = charArray[length - 1];
            assert (!Character.isHighSurrogate(chLast));
        }
        this.getContent().append(charArray, offset, length);
    }

    @Override
    public void malformedError(byte[] errorArray, int offset, int length) throws DecodeBreakException {
        this.decodingError(errorArray, offset, length);
    }

    @Override
    public void unmapError(byte[] errorArray, int offset, int length) throws DecodeBreakException {
        this.decodingError(errorArray, offset, length);
    }

    private void decodingError(byte[] errorArray, int offset, int length) {
        DecodedContent text = this.getContent();
        int limit = offset + length;
        for (int bpos = offset; bpos < limit; ++bpos) {
            byte bVal = errorArray[bpos];
            text.addDecodeError(bVal);
        }
    }
}

