/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.jindolf.parser.content;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class DecodeErrorInfo {
    public static final Comparator<DecodeErrorInfo> POS_COMPARATOR = new PosComparator();
    static final int BSEARCH_THRESHOLD = 16;
    private final int charPos;
    private final boolean has2ndFlag;
    private final byte rawByte1st;
    private final byte rawByte2nd;

    private DecodeErrorInfo(int charPos, boolean has2ndFlag, byte rawByte1st, byte rawByte2nd) throws IndexOutOfBoundsException {
        if (charPos < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.charPos = charPos;
        this.has2ndFlag = has2ndFlag;
        this.rawByte1st = rawByte1st;
        this.rawByte2nd = rawByte2nd;
    }

    public DecodeErrorInfo(int charPos, byte rawByte1st, byte rawByte2nd) throws IndexOutOfBoundsException {
        this(charPos, true, rawByte1st, rawByte2nd);
    }

    public DecodeErrorInfo(int charPos, byte rawByte1st) throws IndexOutOfBoundsException {
        this(charPos, false, rawByte1st, 0);
    }

    public static int lsearchErrorIndex(List<DecodeErrorInfo> errList, int charPos) {
        DecodeErrorInfo einfo;
        int errCharPos;
        int idx = 0;
        Iterator<DecodeErrorInfo> i$ = errList.iterator();
        while (i$.hasNext() && charPos > (errCharPos = (einfo = i$.next()).getCharPosition())) {
            ++idx;
        }
        return idx;
    }

    public static int bsearchErrorIndex(List<DecodeErrorInfo> errList, int charPos) {
        int floorIdx = 0;
        int roofIdx = errList.size() - 1;
        while (floorIdx <= roofIdx) {
            int gapHalf = (roofIdx - floorIdx) / 2;
            int midIdx = floorIdx + gapHalf;
            DecodeErrorInfo einfo = errList.get(midIdx);
            int errCharPos = einfo.getCharPosition();
            if (errCharPos < charPos) {
                floorIdx = midIdx + 1;
                continue;
            }
            if (errCharPos > charPos) {
                roofIdx = midIdx - 1;
                continue;
            }
            return midIdx;
        }
        return floorIdx;
    }

    public static int searchErrorIndex(List<DecodeErrorInfo> errList, int charPos) {
        boolean useLinear = errList instanceof RandomAccess ? errList.size() < 16 : true;
        int result = useLinear ? DecodeErrorInfo.lsearchErrorIndex(errList, charPos) : DecodeErrorInfo.bsearchErrorIndex(errList, charPos);
        return result;
    }

    public int getCharPosition() {
        return this.charPos;
    }

    public boolean has2nd() {
        return this.has2ndFlag;
    }

    public byte getRawByte1st() {
        return this.rawByte1st;
    }

    public byte getRawByte2nd() throws IllegalStateException {
        if (!this.has2ndFlag) {
            throw new IllegalStateException();
        }
        return this.rawByte2nd;
    }

    public DecodeErrorInfo createGappedClone(int gap) throws IndexOutOfBoundsException {
        int newPos = this.charPos - gap;
        DecodeErrorInfo result = new DecodeErrorInfo(newPos, this.has2ndFlag, this.rawByte1st, this.rawByte2nd);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("start:").append(this.charPos).append(' ');
        String hex = Integer.toHexString(this.rawByte1st & 0xFF);
        if (hex.length() <= 1) {
            result.append('0');
        }
        result.append(hex);
        if (this.has2ndFlag) {
            result.append(':');
            hex = Integer.toHexString(this.rawByte2nd & 0xFF);
            if (hex.length() <= 1) {
                result.append('0');
            }
            result.append(hex);
        }
        return result.toString();
    }

    private static final class PosComparator
    implements Comparator<DecodeErrorInfo> {
        PosComparator() {
        }

        @Override
        public int compare(DecodeErrorInfo info1, DecodeErrorInfo info2) {
            int pos2;
            if (info1 == info2) {
                return 0;
            }
            if (info1 == null) {
                return -1;
            }
            if (info2 == null) {
                return 1;
            }
            int pos1 = info1.getCharPosition();
            int result = pos1 < (pos2 = info2.getCharPosition()) ? -1 : (pos1 > pos2 ? 1 : 0);
            return result;
        }
    }
}

