/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.jindolf.parser.content;

import java.nio.charset.Charset;

public final class ShiftJis {
    public static final String ENCODE_NAME = "Shift_JIS";
    public static final Charset CHARSET = Charset.forName("Shift_JIS");
    public static final int MAX_BYTES_PER_CHAR = 2;

    private ShiftJis() {
    }

    public static boolean isShiftJIS1stByte(byte bval) {
        int iVal = bval & 0xFF;
        boolean result = 129 <= iVal && iVal <= 159 || 224 <= iVal && iVal <= 252;
        return result;
    }

    public static boolean isShiftJIS2ndByte(byte bval) {
        int iVal = bval & 0xFF;
        boolean result = 64 <= iVal && iVal <= 126 || 128 <= iVal && iVal <= 252;
        return result;
    }

    public static boolean isShiftJIS(byte b1st, byte b2nd) {
        boolean result = ShiftJis.isShiftJIS1stByte(b1st) && ShiftJis.isShiftJIS2ndByte(b2nd);
        return result;
    }
}

