/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.config;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Locale;

public final class FileUtils {
    private static final Class<?> THISKLASS = FileUtils.class;
    private static final String LANG_JA = "ja";
    private static final String SYSPROP_OSNAME = "os.name";
    private static final String SCHEME_FILE = "file";
    private static final String ENTITY_YEN = "&yen;";

    private FileUtils() {
        assert (this.getClass() == THISKLASS);
    }

    public static boolean setOwnerOnlyAccess(File file) throws SecurityException {
        boolean result = true;
        result &= file.setReadable(false, false);
        result &= file.setReadable(true, true);
        result &= file.setWritable(false, false);
        return result &= file.setWritable(true, true);
    }

    public static File findExistsAncestor(File file) throws IllegalArgumentException {
        if (file == null) {
            return null;
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (file.exists()) {
            return file;
        }
        File parent = file.getParentFile();
        return FileUtils.findExistsAncestor(parent);
    }

    public static File findRootFile(File file) throws IllegalArgumentException {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return file;
        }
        return FileUtils.findRootFile(parent);
    }

    public static File supplyFullPath(File file) {
        File absFile;
        if (file.isAbsolute()) {
            return file;
        }
        try {
            absFile = file.getAbsoluteFile();
        }
        catch (SecurityException e) {
            return file;
        }
        return absFile;
    }

    public static boolean isAccessibleDirectory(File path) {
        if (path == null) {
            return false;
        }
        boolean result = true;
        if (!path.exists()) {
            result = false;
        } else if (!path.isDirectory()) {
            result = false;
        } else if (!path.canRead()) {
            result = false;
        } else if (!path.canWrite()) {
            result = false;
        }
        return result;
    }

    public static File getClassSourceFile(Class<?> klass) {
        URI uri;
        ProtectionDomain domain;
        try {
            domain = klass.getProtectionDomain();
        }
        catch (SecurityException e) {
            return null;
        }
        CodeSource src = domain.getCodeSource();
        URL location = src.getLocation();
        String scheme = location.getProtocol();
        if (!scheme.equals(SCHEME_FILE)) {
            return null;
        }
        try {
            uri = location.toURI();
        }
        catch (URISyntaxException e) {
            assert (false);
            return null;
        }
        File file = new File(uri);
        return file;
    }

    public static boolean isExistsJarFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        String name = file.getName();
        return name.matches("^.+\\.[jJ][aA][rR]$");
    }

    public static File getJarDirectory(Class<?> klass) {
        File jarFile = FileUtils.getClassSourceFile(klass);
        if (jarFile == null) {
            return null;
        }
        if (!FileUtils.isExistsJarFile(jarFile)) {
            return null;
        }
        return jarFile.getParentFile();
    }

    public static File getJarDirectory() {
        return FileUtils.getJarDirectory(THISKLASS);
    }

    public static File getHomeDirectory() {
        String homeProp;
        try {
            homeProp = System.getProperty("user.home");
        }
        catch (SecurityException e) {
            return null;
        }
        File homeFile = new File(homeProp);
        return homeFile;
    }

    public static boolean isMacOSXFs() {
        String osName;
        if (File.separatorChar != '/') {
            return false;
        }
        try {
            osName = System.getProperty(SYSPROP_OSNAME);
        }
        catch (SecurityException e) {
            return false;
        }
        if (osName == null) {
            return false;
        }
        return (osName = osName.toLowerCase(Locale.ROOT)).startsWith("mac os x");
    }

    public static boolean isWindowsOSFs() {
        String osName;
        if (File.separatorChar != '\\') {
            return false;
        }
        try {
            osName = System.getProperty(SYSPROP_OSNAME);
        }
        catch (SecurityException e) {
            return false;
        }
        if (osName == null) {
            return false;
        }
        return (osName = osName.toLowerCase(Locale.ROOT)).startsWith("windows");
    }

    public static File getAppSetDir() {
        File home = FileUtils.getHomeDirectory();
        if (home == null) {
            return null;
        }
        File result = home;
        if (FileUtils.isMacOSXFs()) {
            result = new File(result, "Library");
            result = new File(result, "Application Support");
        }
        return result;
    }

    public static String getHtmledFileName(File file) {
        String pathName = file.getPath();
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        if (FileUtils.isWindowsOSFs() && lang.equals(LANG_JA)) {
            pathName = pathName.replace(File.separator, ENTITY_YEN);
        }
        return "<code>" + pathName + "</code>";
    }

    static {
        assert (!FileUtils.isMacOSXFs() || !FileUtils.isWindowsOSFs());
        new FileUtils().hashCode();
    }
}

