/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.data;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.dxchg.XmlUtils;
import jp.sourceforge.jindolf.corelib.LandDef;
import org.xml.sax.SAXException;

public class LandsModel
implements TreeModel {
    private static final String ROOT = "ROOT";
    private static final int SECTION_INTERVAL = 100;
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private final List<Land> landList = new LinkedList<Land>();
    private final List<Land> unmodList = Collections.unmodifiableList(this.landList);
    private final Map<Land, List<VillageSection>> sectionMap = new HashMap<Land, List<VillageSection>>();
    private boolean isLandListLoaded = false;
    private final EventListenerList listeners = new EventListenerList();
    private boolean ascending = false;

    public void updateVillageList(Land land) {
        List sectionList = VillageSection.getSectionList(land, 100);
        this.sectionMap.put(land, sectionList);
        int[] childIndices = new int[sectionList.size()];
        for (int ct = 0; ct < childIndices.length; ++ct) {
            childIndices[ct] = ct;
        }
        Object[] children = sectionList.toArray();
        Object[] path = new Object[]{ROOT, land};
        TreePath treePath = new TreePath(path);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, childIndices, children);
        this.fireTreeStructureChanged(event);
    }

    public void loadLandList() {
        List<LandDef> landDefList;
        if (this.isLandListLoaded) {
            return;
        }
        this.landList.clear();
        try {
            DocumentBuilder builder = XmlUtils.createDocumentBuilder();
            landDefList = LandDef.buildLandDefList(builder);
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.SEVERE, "failed to load land list", e);
            return;
        }
        for (LandDef landDef : landDefList) {
            Land land = new Land(landDef);
            this.landList.add(land);
        }
        this.isLandListLoaded = true;
        this.fireLandListChanged();
    }

    private void fireLandListChanged() {
        int size = this.landList.size();
        int[] childIndices = new int[size];
        for (int ct = 0; ct < size; ++ct) {
            int index;
            childIndices[ct] = index = ct;
        }
        Object[] children = this.landList.toArray();
        TreePath treePath = new TreePath(ROOT);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, childIndices, children);
        this.fireTreeStructureChanged(event);
    }

    public void setAscending(boolean ascending) {
        if (this.ascending == ascending) {
            return;
        }
        this.ascending = ascending;
        this.fireLandListChanged();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    private TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
    }

    protected void fireTreeStructureChanged(TreeModelEvent event) {
        for (TreeModelListener listener : this.getTreeModelListeners()) {
            listener.treeStructureChanged(event);
        }
    }

    public List<Land> getLandList() {
        return this.unmodList;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getChildCount(parent)) {
            return null;
        }
        if (parent == ROOT) {
            List<Land> list = this.getLandList();
            int landIndex = index;
            if (!this.ascending) {
                landIndex = list.size() - index - 1;
            }
            Land land = list.get(landIndex);
            return land;
        }
        if (parent instanceof Land) {
            Land land = (Land)parent;
            List<VillageSection> sectionList = this.sectionMap.get(land);
            int sectIndex = index;
            if (!this.ascending) {
                sectIndex = sectionList.size() - index - 1;
            }
            VillageSection section = sectionList.get(sectIndex);
            return section;
        }
        if (parent instanceof VillageSection) {
            VillageSection section = (VillageSection)parent;
            int vilIndex = index;
            if (!this.ascending) {
                vilIndex = section.getVillageCount() - index - 1;
            }
            Village village = section.getVillage(vilIndex);
            return village;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == ROOT) {
            return this.getLandList().size();
        }
        if (parent instanceof Land) {
            Land land = (Land)parent;
            List<VillageSection> sectionList = this.sectionMap.get(land);
            if (sectionList == null) {
                return 0;
            }
            return sectionList.size();
        }
        if (parent instanceof VillageSection) {
            VillageSection section = (VillageSection)parent;
            return section.getVillageCount();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child == null) {
            return -1;
        }
        if (parent == ROOT) {
            List<Land> list = this.getLandList();
            int index = list.indexOf(child);
            if (!this.ascending) {
                index = list.size() - index - 1;
            }
            return index;
        }
        if (parent instanceof Land) {
            Land land = (Land)parent;
            List<VillageSection> sectionList = this.sectionMap.get(land);
            int index = sectionList.indexOf(child);
            if (!this.ascending) {
                index = sectionList.size() - index - 1;
            }
            return index;
        }
        if (parent instanceof VillageSection) {
            VillageSection section = (VillageSection)parent;
            int index = section.getIndexOfVillage(child);
            if (!this.ascending) {
                index = section.getVillageCount() - index - 1;
            }
            return index;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == ROOT) {
            return false;
        }
        if (node instanceof Land) {
            return false;
        }
        if (node instanceof VillageSection) {
            return false;
        }
        if (node instanceof Village) {
            return true;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static final class VillageSection {
        private final int startID;
        private final int endID;
        private final String prefix;
        private final List<Village> villageList = new LinkedList<Village>();

        private VillageSection(Land land, int startID, int endID) throws IndexOutOfBoundsException {
            if (startID < 0 || startID > endID) {
                throw new IndexOutOfBoundsException();
            }
            this.startID = startID;
            this.endID = endID;
            this.prefix = land.getLandDef().getLandPrefix();
            for (Village village : land.getVillageList()) {
                int id = village.getVillageIDNum();
                if (startID > id || id > endID) continue;
                this.villageList.add(village);
            }
        }

        private static List<VillageSection> getSectionList(Land land, int interval) throws IllegalArgumentException {
            int fixedStart;
            if (interval <= 0) {
                throw new IllegalArgumentException();
            }
            List<Village> villageList = land.getVillageList();
            Village village1st = villageList.get(0);
            Village villageLast = villageList.get(villageList.size() - 1);
            int startID = village1st.getVillageIDNum();
            int endID = villageLast.getVillageIDNum();
            LinkedList<VillageSection> result = new LinkedList<VillageSection>();
            for (int ct = fixedStart = startID / interval * interval; ct <= endID; ct += interval) {
                VillageSection section = new VillageSection(land, ct, ct + interval - 1);
                result.add(section);
            }
            return Collections.unmodifiableList(result);
        }

        private int getVillageCount() {
            return this.villageList.size();
        }

        private Village getVillage(int index) {
            return this.villageList.get(index);
        }

        private int getIndexOfVillage(Object child) {
            return this.villageList.indexOf(child);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.prefix).append(this.startID);
            result.append(" \uff5e ");
            result.append(this.prefix).append(this.endID);
            return result.toString();
        }
    }
}

