/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.dxchg;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.dxchg.ClipboardAction;
import jp.sfjp.jindolf.dxchg.TextPopup;
import jp.sfjp.jindolf.dxchg.UriExporter;
import jp.sfjp.jindolf.util.GUIUtils;
import jp.sfjp.jindolf.util.Monodizer;

public class WebIPCDialog
extends JDialog {
    protected static final Logger LOGGER = Logger.getAnonymousLogger();
    protected static final String CMD_BROWSE = "browse";
    protected static final String CMD_CLIPCOPY = "clipcopy";
    protected static final String CMD_CANCEL = "cancel";
    private static final String MSG_NODESKTOP = "\u4f55\u3089\u304b\u306e\u7406\u7531\u3067\u3053\u306e\u6a5f\u80fd\u306f\u5229\u7528\u4e0d\u53ef\u306b\u306a\u3063\u3066\u3044\u307e\u3059";
    private static final String MSG_DND = "URL {0} \u304c\u3069\u3053\u304b\u3078\u30c9\u30e9\u30c3\u30b0&\u30c9\u30ed\u30c3\u30d7\u3055\u308c\u307e\u3057\u305f";
    private static final String MSG_CLIPCOPY = "\u6587\u5b57\u5217\u300c{0}\u300d\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f";
    private static final String MSG_BROWSE = "URL {0} \u3078\u306e\u30a2\u30af\u30bb\u30b9\u3092Web\u30d6\u30e9\u30a6\u30b6\u306b\u6307\u793a\u3057\u307e\u3057\u305f";
    private static final String TITLE_WWW = VerInfo.getFrameTitle("URL\u3078\u306e\u30a2\u30af\u30bb\u30b9\u78ba\u8a8d");
    private static final DragIgniter DNDIGNITER = new DragIgniter();
    private static final URI URI_EMPTY;
    private final JLabel info = new JLabel("\u4ee5\u4e0b\u306eURL\u3078\u306e\u30a2\u30af\u30bb\u30b9\u304c\u6307\u793a\u3055\u308c\u307e\u3057\u305f\u3002");
    private final JTextArea urltext = new JTextArea("");
    private final JButton browse = new JButton("\u30c7\u30d5\u30a9\u30eb\u30c8\u306eWeb\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a");
    private final JButton clipcopy = new JButton("URL\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc");
    private final JLabel dndLabel = new JLabel("\u2026\u307e\u305f\u306f\u30d6\u30e9\u30a6\u30b6\u306bDrag&Drop \u2192");
    private final JButton cancel = new JButton("\u9589\u3058\u308b");
    private final Desktop desktop = WebIPCDialog.getBrowserCntl();
    private URI uri;

    protected WebIPCDialog(Frame owner) {
        super(owner);
        if (this.desktop == null) {
            this.browse.setEnabled(false);
        }
        this.buildUrlLabel();
        this.buildEventCatcher();
        this.buildDnDLabel();
        Container container = this.getContentPane();
        this.design(container);
    }

    private static Desktop getBrowserCntl() {
        if (!Desktop.isDesktopSupported()) {
            return null;
        }
        Desktop result = Desktop.getDesktop();
        assert (result != null);
        if (!result.isSupported(Desktop.Action.BROWSE)) {
            return null;
        }
        return result;
    }

    public static void showDialog(Frame owner, String url) {
        WebIPCDialog dialog = WebIPCDialog.createDialog(owner);
        dialog.setUrlText(url);
        dialog.pack();
        dialog.setVisible(true);
    }

    protected static WebIPCDialog createDialog(Frame owner) {
        WebIPCDialog dialog = new WebIPCDialog(owner);
        WebIPCDialog.decorateDialog(dialog);
        dialog.setLocationRelativeTo(owner);
        return dialog;
    }

    protected static void decorateDialog(WebIPCDialog dialog) {
        dialog.setResizable(true);
        dialog.setLocationByPlatform(true);
        dialog.setTitle(TITLE_WWW);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
    }

    private static boolean isValidURI(URI uri) {
        if (uri == null) {
            return false;
        }
        if (!uri.isAbsolute()) {
            return false;
        }
        String scheme = uri.getScheme();
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            return false;
        }
        String host = uri.getHost();
        return host != null;
    }

    private void buildUrlLabel() {
        Border inside = BorderFactory.createEmptyBorder(1, 4, 1, 4);
        Border outside = BorderFactory.createEtchedBorder(0);
        CompoundBorder border = BorderFactory.createCompoundBorder(outside, inside);
        this.urltext.setBorder(border);
        this.urltext.setEditable(false);
        this.urltext.setLineWrap(true);
        this.urltext.setComponentPopupMenu(new TextPopup());
        Monodizer.monodize(this.urltext);
    }

    private void buildEventCatcher() {
        this.browse.setActionCommand(CMD_BROWSE);
        this.clipcopy.setActionCommand(CMD_CLIPCOPY);
        this.cancel.setActionCommand(CMD_CANCEL);
        EventCatcher catcher = new EventCatcher();
        this.browse.addActionListener(catcher);
        this.clipcopy.addActionListener(catcher);
        this.cancel.addActionListener(catcher);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(catcher);
        JRootPane pane = this.getRootPane();
        pane.setDefaultButton(this.browse);
        this.browse.requestFocusInWindow();
        if (this.desktop == null) {
            this.browse.setToolTipText(MSG_NODESKTOP);
        }
    }

    private void buildDnDLabel() {
        this.dndLabel.setIcon(GUIUtils.getWWWIcon());
        this.dndLabel.setHorizontalTextPosition(2);
        this.dndLabel.setTransferHandler(new DnDHandler());
        this.dndLabel.addMouseListener(DNDIGNITER);
    }

    private void design(Container container) {
        GridBagLayout layout = new GridBagLayout();
        container.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 5, 5, 5);
        JComponent buttonPanel = this.buildButtonPanel();
        container.add((Component)this.info, constraints);
        container.add((Component)this.urltext, constraints);
        container.add((Component)buttonPanel, constraints);
        container.add((Component)this.cancel, constraints);
    }

    private JComponent buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder("\u30a2\u30af\u30bb\u30b9\u3059\u308b\u65b9\u6cd5\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        buttonPanel.setBorder(border);
        GridBagLayout layout = new GridBagLayout();
        buttonPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.insets = new Insets(3, 3, 3, 3);
        buttonPanel.add((Component)this.browse, constraints);
        buttonPanel.add((Component)this.clipcopy, constraints);
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(10, 3, 10, 3);
        buttonPanel.add((Component)this.dndLabel, constraints);
        return buttonPanel;
    }

    public void setUrlText(String url) {
        URI argUri;
        try {
            argUri = new URI(url);
        }
        catch (URISyntaxException e) {
            argUri = null;
        }
        this.setUri(argUri);
    }

    public void setUri(URI uriArg) {
        this.uri = WebIPCDialog.isValidURI(uriArg) ? uriArg : URI_EMPTY;
        String uriText = this.uri.toASCIIString();
        this.urltext.setText(uriText);
        this.urltext.revalidate();
        this.pack();
    }

    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionBrowse() {
        try {
            this.actionBrowseImpl();
        }
        finally {
            this.closeDialog();
        }
    }

    private void actionBrowseImpl() {
        if (!WebIPCDialog.isValidURI(this.uri)) {
            return;
        }
        if (this.desktop == null) {
            String title = "\u5831\u544a";
            JOptionPane.showMessageDialog(this, MSG_NODESKTOP, title, 1);
            return;
        }
        try {
            this.desktop.browse(this.uri);
        }
        catch (IOException e) {
            return;
        }
        String uriText = this.uri.toASCIIString();
        String logMessage = MessageFormat.format(MSG_BROWSE, uriText);
        LOGGER.info(logMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionClipboardCopy() {
        if (!WebIPCDialog.isValidURI(this.uri)) {
            this.closeDialog();
            return;
        }
        String uriText = this.uri.toASCIIString();
        try {
            ClipboardAction.copyToClipboard(uriText);
            String logMessage = MessageFormat.format(MSG_CLIPCOPY, uriText);
            LOGGER.info(logMessage);
        }
        finally {
            this.closeDialog();
        }
    }

    protected void actionCancel() {
        this.closeDialog();
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    static {
        try {
            URI_EMPTY = new URI("");
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class DragIgniter
    extends MouseAdapter {
        DragIgniter() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            Object source = event.getSource();
            assert (source instanceof JComponent);
            JComponent comp = (JComponent)source;
            TransferHandler handler = comp.getTransferHandler();
            handler.exportAsDrag(comp, event, 1);
        }
    }

    private class DnDHandler
    extends TransferHandler {
        DnDHandler() {
        }

        @Override
        public int getSourceActions(JComponent comp) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent comp) {
            UriExporter result = new UriExporter(WebIPCDialog.this.getURI());
            return result;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 0) {
                return;
            }
            String uriAscii = WebIPCDialog.this.getURI().toASCIIString();
            String logmsg = MessageFormat.format(WebIPCDialog.MSG_DND, uriAscii);
            LOGGER.info(logmsg);
            WebIPCDialog.this.closeDialog();
        }
    }

    private class EventCatcher
    extends WindowAdapter
    implements ActionListener {
        EventCatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String cmd = event.getActionCommand();
            if (cmd == null) {
                return;
            }
            switch (cmd) {
                case "browse": {
                    WebIPCDialog.this.actionBrowse();
                    break;
                }
                case "clipcopy": {
                    WebIPCDialog.this.actionClipboardCopy();
                    break;
                }
                case "cancel": {
                    WebIPCDialog.this.actionCancel();
                    break;
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent event) {
            WebIPCDialog.this.actionCancel();
        }
    }
}

