/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import java.util.Locale;
import jp.sfjp.jindolf.glyph.FontEnv;
import jp.sfjp.jindolf.glyph.ImtblAffineTx;

public class FontInfo {
    public static final FontEnv DEFAULT_FONTENV = FontEnv.DEFAULT;
    public static final FontInfo DEFAULT_FONTINFO = new FontInfo();
    public static final int DEF_SIZE = 16;
    public static final int DEF_STYLE = 0;
    private static final int MS_VEC_LIMIT = 24;
    private static final char DQ = '\"';
    private String familyName = null;
    private Font font;
    private FontRenderContext context;

    public FontInfo() {
        this(null, null);
    }

    public FontInfo(Font font, FontRenderContext context) {
        this.font = font;
        this.context = context;
    }

    protected static boolean isMsRicohJpFont(Font font) {
        String rootFamilyName = font.getFamily(Locale.ROOT);
        if (rootFamilyName.startsWith("MS")) {
            if (rootFamilyName.contains("Gothic")) {
                return true;
            }
            if (rootFamilyName.contains("Mincho")) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isBitmapFont(Font font) {
        if (font.getSize() >= 24) {
            return false;
        }
        return FontInfo.isMsRicohJpFont(font);
    }

    protected static FontRenderContext createBestContext(Font font) {
        boolean usesFractionalMetrics;
        boolean isAntiAliased;
        if (FontInfo.isBitmapFont(font)) {
            isAntiAliased = false;
            usesFractionalMetrics = false;
        } else {
            isAntiAliased = true;
            usesFractionalMetrics = true;
        }
        AffineTransform identity = ImtblAffineTx.IDENTITY;
        FontRenderContext result = new FontRenderContext(identity, isAntiAliased, usesFractionalMetrics);
        return result;
    }

    private String getFamilyName() {
        if (this.familyName == null) {
            this.familyName = this.font == null ? DEFAULT_FONTENV.selectFontFamily() : this.getRootFamilyName();
        }
        return this.familyName;
    }

    public Font getFont() {
        if (this.font == null) {
            String name = this.getFamilyName();
            this.font = new Font(name, 0, 16);
        }
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        if (this.context == null) {
            Font thisFont = this.getFont();
            this.context = FontInfo.createBestContext(thisFont);
        }
        return this.context;
    }

    public boolean isAntiAliased() {
        FontRenderContext frc = this.getFontRenderContext();
        boolean result = frc.isAntiAliased();
        return result;
    }

    public boolean usesFractionalMetrics() {
        FontRenderContext frc = this.getFontRenderContext();
        boolean result = frc.usesFractionalMetrics();
        return result;
    }

    public Rectangle getMaxCharBounds() {
        Font thisFont = this.getFont();
        FontRenderContext frc = this.getFontRenderContext();
        Rectangle2D r2d = thisFont.getMaxCharBounds(frc);
        Rectangle rect = r2d.getBounds();
        return rect;
    }

    public FontInfo deriveFont(Font newFont) {
        FontInfo result = new FontInfo(newFont, this.context);
        return result;
    }

    public FontInfo deriveRenderContext(FontRenderContext newContext) {
        FontInfo result = new FontInfo(this.font, newContext);
        return result;
    }

    public FontInfo deriveRenderContext(boolean isAntiAliases, boolean useFractional) {
        AffineTransform tx = this.context == null ? ImtblAffineTx.IDENTITY : this.context.getTransform();
        FontRenderContext newContext = new FontRenderContext(tx, isAntiAliases, useFractional);
        return this.deriveRenderContext(newContext);
    }

    public GlyphVector createGlyphVector(CharacterIterator iterator) {
        Font thisFont = this.getFont();
        FontRenderContext frc = this.getFontRenderContext();
        GlyphVector glyph = thisFont.createGlyphVector(frc, iterator);
        return glyph;
    }

    public String getRootFamilyName() {
        Font thisFont = this.getFont();
        String result = thisFont.getFamily(Locale.ROOT);
        return result;
    }

    public String getFontDecodeName() {
        StringBuilder result = new StringBuilder();
        String name = this.getRootFamilyName();
        Font thisFont = this.getFont();
        StringBuilder style = new StringBuilder();
        if (thisFont.isBold()) {
            style.append("BOLD");
        }
        if (thisFont.isItalic()) {
            style.append("ITALIC");
        }
        if (style.length() <= 0) {
            style.append("PLAIN");
        }
        int fontSize = thisFont.getSize();
        result.append(name).append('-').append((CharSequence)style).append('-').append(fontSize);
        if (result.indexOf(" ") >= 0 || result.indexOf("\u3000") >= 0) {
            result.insert(0, '\"').append('\"');
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        FontRenderContext targetContext;
        Font targetFont;
        if (!(obj instanceof FontInfo)) {
            return false;
        }
        FontInfo target = (FontInfo)obj;
        Font thisFont = this.getFont();
        if (!thisFont.equals(targetFont = target.getFont())) {
            return false;
        }
        FontRenderContext thisContext = this.getFontRenderContext();
        return thisContext.equals(targetContext = target.getFontRenderContext());
    }

    public int hashCode() {
        int hashFont = this.getFont().hashCode();
        int hashContext = this.getFontRenderContext().hashCode();
        return hashFont ^ hashContext;
    }
}

