/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.glyph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sfjp.jindolf.data.DialogPref;
import jp.sfjp.jindolf.data.SysEvent;
import jp.sfjp.jindolf.glyph.AbstractTextRow;
import jp.sfjp.jindolf.glyph.FontInfo;
import jp.sfjp.jindolf.glyph.GlyphDraw;

public class SysEventDraw
extends AbstractTextRow {
    public static final Color COLOR_ANNOUNCE = new Color(0xFFFFFF);
    public static final Color COLOR_ORDER = new Color(0xF04040);
    public static final Color COLOR_EXTRA = new Color(0x808080);
    private static final Color COLOR_SIMPLEFG = Color.BLACK;
    private static final int INSET = 10;
    private static final int UNDER_MARGIN = 15;
    private final SysEvent sysEvent;
    private final GlyphDraw sysMessage;
    private DialogPref dialogPref;
    private Color fgColor;

    public SysEventDraw(SysEvent sysEvent) {
        this(sysEvent, new DialogPref(), FontInfo.DEFAULT_FONTINFO);
    }

    public SysEventDraw(SysEvent sysEvent, DialogPref pref, FontInfo fontInfo) {
        super(fontInfo);
        this.sysEvent = sysEvent;
        DecodedContent content = this.sysEvent.getContent();
        CharSequence rawContent = content.getRawContent();
        this.sysMessage = new GlyphDraw(rawContent, this.fontInfo);
        this.dialogPref = pref;
        this.setColorDesign();
    }

    private void setColorDesign() {
        this.fgColor = this.dialogPref.isSimpleMode() ? COLOR_SIMPLEFG : this.getEventColor();
        this.sysMessage.setColor(this.fgColor);
    }

    public SysEvent getSysEvent() {
        return this.sysEvent;
    }

    private Color getEventColor() {
        Color result;
        switch (this.sysEvent.getEventFamily()) {
            case ANNOUNCE: {
                result = COLOR_ANNOUNCE;
                break;
            }
            case ORDER: {
                result = COLOR_ORDER;
                break;
            }
            case EXTRA: {
                result = COLOR_EXTRA;
                break;
            }
            default: {
                assert (false);
                result = null;
            }
        }
        return result;
    }

    @Override
    public Rectangle recalcBounds() {
        int newWidth = this.getWidth();
        Rectangle child = this.sysMessage.setWidth(newWidth - 10 - 10);
        this.bounds.width = newWidth;
        this.bounds.height = child.height + 10 + 10 + 15;
        return this.bounds;
    }

    @Override
    public void setFontInfo(FontInfo fontInfo) {
        super.setFontInfo(fontInfo);
        this.sysMessage.setFontInfo(this.fontInfo);
        this.recalcBounds();
    }

    public void setDialogPref(DialogPref pref) {
        this.dialogPref = pref;
        this.setColorDesign();
        this.recalcBounds();
    }

    @Override
    public void drag(Point from, Point to) {
        this.sysMessage.drag(from, to);
    }

    @Override
    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.sysMessage.appendSelected(appendable);
        return appendable;
    }

    @Override
    public void clearSelect() {
        this.sysMessage.clearSelect();
    }

    @Override
    public void setPos(int xPos, int yPos) {
        super.setPos(xPos, yPos);
        this.sysMessage.setPos(this.bounds.x + 10, this.bounds.y + 10);
    }

    @Override
    public void paint(Graphics2D g) {
        g.setColor(this.fgColor);
        RenderingHints.Key aaHintKey = RenderingHints.KEY_ANTIALIASING;
        Object aaHintTemp = RenderingHints.VALUE_ANTIALIAS_OFF;
        Object aaHintOrig = g.getRenderingHint(aaHintKey);
        RenderingHints.Key strokeHintKey = RenderingHints.KEY_STROKE_CONTROL;
        Object strokeHintTemp = RenderingHints.VALUE_STROKE_NORMALIZE;
        Object strokeHintOrig = g.getRenderingHint(strokeHintKey);
        g.setRenderingHint(aaHintKey, aaHintTemp);
        g.setRenderingHint(strokeHintKey, strokeHintTemp);
        if (this.dialogPref.isSimpleMode()) {
            g.drawLine(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y);
        } else {
            g.drawRect(this.bounds.x, this.bounds.y, this.bounds.width - 1, this.bounds.height - 15);
        }
        g.setRenderingHint(aaHintKey, aaHintOrig);
        g.setRenderingHint(strokeHintKey, strokeHintOrig);
        this.sysMessage.paint(g);
    }
}

