/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.net;

import io.bitbucket.olyutorskii.jiocema.DecodeBreakException;
import io.bitbucket.olyutorskii.jiocema.DecodeNotifier;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import jp.osdn.jindolf.parser.content.ContentBuilder;
import jp.osdn.jindolf.parser.content.ContentBuilderSJ;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.osdn.jindolf.parser.content.SjisNotifier;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.net.AuthManager;
import jp.sfjp.jindolf.net.HtmlSequence;
import jp.sfjp.jindolf.net.HttpUtils;
import jp.sfjp.jindolf.net.TallyInputStream;
import jp.sfjp.jindolf.net.TallyOutputStream;

public class ServerAccess {
    private static final String USER_AGENT = HttpUtils.getUserAgentName();
    private static final String JINRO_CGI = "./index.rb";
    private static final Map<String, SoftReference<BufferedImage>> IMAGE_CACHE;
    private static final Logger LOGGER;
    private static final String ENC_POST = "UTF-8";
    private final URL baseURL;
    private final AuthManager authManager;
    private final Charset charset;
    private Proxy proxy = Proxy.NO_PROXY;
    private long lastServerMs;
    private long lastLocalMs;
    private long lastSystemMs;

    public ServerAccess(URL baseURL, Charset charset) throws IllegalArgumentException {
        this.baseURL = baseURL;
        this.authManager = new AuthManager(this.baseURL);
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getImageCache(String key) {
        BufferedImage image;
        if (key == null) {
            return null;
        }
        Map<String, SoftReference<BufferedImage>> map = IMAGE_CACHE;
        synchronized (map) {
            SoftReference<BufferedImage> ref = IMAGE_CACHE.get(key);
            if (ref == null) {
                return null;
            }
            BufferedImage referent = ref.get();
            if (referent == null) {
                IMAGE_CACHE.remove(key);
                return null;
            }
            image = referent;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putImageCache(String key, BufferedImage image) {
        if (key == null || image == null) {
            return;
        }
        Map<String, SoftReference<BufferedImage>> map = IMAGE_CACHE;
        synchronized (map) {
            if (ServerAccess.getImageCache(key) != null) {
                return;
            }
            SoftReference<BufferedImage> ref = new SoftReference<BufferedImage>(image);
            IMAGE_CACHE.put(key, ref);
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    protected URL getQueryURL(String query) {
        URL result;
        if (query.length() >= 1 && query.charAt(0) != '?') {
            return null;
        }
        try {
            result = new URL(this.getBaseURL(), JINRO_CGI + query);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        return result;
    }

    public DecodedContent downloadHTMLStream(InputStream istream) throws IOException {
        ContentBuilder builder;
        DecodeNotifier decoder;
        if (this.charset.name().equalsIgnoreCase("Shift_JIS")) {
            decoder = new SjisNotifier();
            builder = new ContentBuilderSJ(204800);
        } else if (this.charset.name().equalsIgnoreCase(ENC_POST)) {
            decoder = new DecodeNotifier(this.charset.newDecoder());
            builder = new ContentBuilder(204800);
        } else {
            assert (false);
            return null;
        }
        decoder.setCharDecodeListener(builder);
        try {
            decoder.decode(istream);
        }
        catch (DecodeBreakException e) {
            return null;
        }
        return builder.getContent();
    }

    protected HtmlSequence downloadHTML(String query) throws IOException {
        URL url = this.getQueryURL(query);
        HtmlSequence result = this.downloadHTML(url);
        return result;
    }

    protected HtmlSequence downloadHTML(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.proxy);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        connection.connect();
        long datems = this.updateLastAccess(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            String logMessage = "\u767a\u8a00\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            logMessage = logMessage + HttpUtils.formatHttpStat(connection, 0L, 0L);
            LOGGER.warning(logMessage);
            return null;
        }
        String cs = HttpUtils.getHTMLCharset(connection);
        if (!cs.equalsIgnoreCase(this.charset.name())) {
            return null;
        }
        InputStream stream = TallyInputStream.getInputStream(connection);
        DecodedContent html = this.downloadHTMLStream(stream);
        stream.close();
        connection.disconnect();
        HtmlSequence hseq = new HtmlSequence(url, datems, html);
        return hseq;
    }

    public BufferedImage downloadImage(String url) throws IOException {
        URL absolute;
        try {
            URL base = this.getBaseURL();
            absolute = new URL(base, url);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        BufferedImage image = ServerAccess.getImageCache(absolute.toString());
        if (image != null) {
            return image;
        }
        HttpURLConnection connection = (HttpURLConnection)absolute.openConnection(this.proxy);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(true);
        connection.setInstanceFollowRedirects(true);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            String logMessage = "\u30a4\u30e1\u30fc\u30b8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            logMessage = logMessage + HttpUtils.formatHttpStat(connection, 0L, 0L);
            LOGGER.warning(logMessage);
            return null;
        }
        InputStream stream = TallyInputStream.getInputStream(connection);
        image = ImageIO.read(stream);
        stream.close();
        connection.disconnect();
        ServerAccess.putImageCache(absolute.toString(), image);
        return image;
    }

    protected boolean postAuthData(String authData) throws IOException {
        URL url = this.getQueryURL("");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.proxy);
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        byte[] authBytes = authData.getBytes(ENC_POST);
        OutputStream os = TallyOutputStream.getOutputStream(connection);
        os.write(authBytes);
        os.flush();
        os.close();
        this.updateLastAccess(connection);
        connection.disconnect();
        if (!this.authManager.hasLoggedIn()) {
            String logMessage = "\u8a8d\u8a3c\u60c5\u5831\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            LOGGER.warning(logMessage);
            return false;
        }
        LOGGER.info("\u6b63\u3057\u304f\u8a8d\u8a3c\u304c\u884c\u308f\u308c\u307e\u3057\u305f\u3002");
        return true;
    }

    public HtmlSequence getHTMLTopPage() throws IOException {
        return this.downloadHTML("");
    }

    public HtmlSequence getHTMLLandList() throws IOException {
        return this.downloadHTML("?cmd=log");
    }

    public HtmlSequence getHTMLBoneHead(Village village) throws IOException {
        String villageID = village.getVillageID();
        return this.downloadHTML("?vid=" + villageID + "&meslog=");
    }

    public HtmlSequence getHTMLVillage(Village village) throws IOException {
        URL url = this.getVillageURL(village);
        return this.downloadHTML(url);
    }

    public URL getVillageURL(Village village) {
        String villageID = village.getVillageID();
        URL url = this.getQueryURL("?vid=" + villageID);
        return url;
    }

    public HtmlSequence getHTMLPeriod(Period period) throws IOException {
        URL url = this.getPeriodURL(period);
        return this.downloadHTML(url);
    }

    public URL getPeriodURL(Period period) {
        String query = period.getCGIQuery();
        URL url = this.getQueryURL(query);
        return url;
    }

    public long updateLastAccess(HttpURLConnection connection) {
        this.lastServerMs = connection.getDate();
        this.lastLocalMs = System.currentTimeMillis();
        this.lastSystemMs = System.nanoTime() / 1000000L;
        return this.lastServerMs;
    }

    public final boolean login(String userID, char[] password) throws IOException {
        boolean result;
        if (this.authManager.hasLoggedIn()) {
            return true;
        }
        String postText = AuthManager.buildLoginPostData(userID, password);
        try {
            result = this.postAuthData(postText);
        }
        catch (IOException e) {
            this.authManager.clearAuthentication();
            throw e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws IOException {
        if (!this.authManager.hasLoggedIn()) {
            return;
        }
        try {
            this.postAuthData(AuthManager.POST_LOGOUT);
        }
        finally {
            this.authManager.clearAuthentication();
        }
    }

    public boolean hasLoggedIn() {
        boolean result = this.authManager.hasLoggedIn();
        return result;
    }

    static {
        LOGGER = Logger.getAnonymousLogger();
        HashMap cache = new HashMap();
        IMAGE_CACHE = Collections.synchronizedMap(cache);
    }
}

