/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jp.sfjp.jindolf.ResourceManager;
import jp.sfjp.jindolf.data.Land;
import jp.sfjp.jindolf.data.LandsModel;
import jp.sfjp.jindolf.view.VillageIconRenderer;

public class LandsTree
extends JPanel
implements ActionListener,
TreeSelectionListener {
    private static final String TIP_ASCEND = "\u62bc\u3059\u3068\u964d\u9806\u306b";
    private static final String TIP_DESCEND = "\u62bc\u3059\u3068\u6607\u9806\u306b";
    private static final String TIP_ORDER = "\u9078\u629e\u4e2d\u306e\u56fd\u306e\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u76f4\u3059";
    private static final Icon ICON_ASCEND = ResourceManager.getButtonIcon("resources/image/tb_ascend.png");
    private static final Icon ICON_DESCEND = ResourceManager.getButtonIcon("resources/image/tb_descend.png");
    private final JButton orderButton = new JButton();
    private final JButton reloadButton = new JButton();
    private final JTree treeView = new JTree();
    private boolean ascending = false;

    public LandsTree() {
        this.design();
        this.orderButton.setIcon(ICON_DESCEND);
        this.orderButton.setToolTipText(TIP_DESCEND);
        this.orderButton.setMargin(new Insets(1, 1, 1, 1));
        this.orderButton.setActionCommand("SWITCHORDER");
        this.orderButton.addActionListener(this);
        Icon icon = ResourceManager.getButtonIcon("resources/image/tb_reload.png");
        this.reloadButton.setIcon(icon);
        this.reloadButton.setToolTipText(TIP_ORDER);
        this.reloadButton.setMargin(new Insets(1, 1, 1, 1));
        this.reloadButton.setActionCommand("VILLAGELIST");
        TreeSelectionModel selModel = this.treeView.getSelectionModel();
        selModel.setSelectionMode(1);
        this.treeView.addTreeSelectionListener(this);
    }

    private void design() {
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.orderButton);
        toolBar.add(this.reloadButton);
        JComponent landSelector = this.createLandSelector();
        this.add((Component)toolBar, "North");
        this.add((Component)landSelector, "Center");
    }

    private JComponent createLandSelector() {
        this.treeView.setRootVisible(false);
        this.treeView.setCellRenderer(new VillageIconRenderer());
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.treeView.setBorder(border);
        JScrollPane landSelector = new JScrollPane(this.treeView);
        return landSelector;
    }

    public JButton getReloadVillageListButton() {
        return this.reloadButton;
    }

    public JTree getTreeView() {
        return this.treeView;
    }

    public void expandLand(Land land) {
        TreeModel model = this.treeView.getModel();
        Object root = model.getRoot();
        Object[] path = new Object[]{root, land};
        TreePath treePath = new TreePath(path);
        this.treeView.expandPath(treePath);
    }

    private LandsModel getLandsModel() {
        TreeModel model = this.treeView.getModel();
        if (model instanceof LandsModel) {
            return (LandsModel)model;
        }
        return null;
    }

    private boolean toggleTreeOrder() {
        boolean bl = this.ascending = !this.ascending;
        if (this.ascending) {
            this.orderButton.setToolTipText(TIP_ASCEND);
            this.orderButton.setIcon(ICON_ASCEND);
        } else {
            this.orderButton.setToolTipText(TIP_DESCEND);
            this.orderButton.setIcon(ICON_DESCEND);
        }
        final TreePath lastPath = this.treeView.getSelectionPath();
        LandsModel model = this.getLandsModel();
        if (model != null) {
            model.setAscending(this.ascending);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (lastPath != null) {
                    LandsTree.this.treeView.setSelectionPath(lastPath);
                    LandsTree.this.treeView.scrollPathToVisible(lastPath);
                }
            }
        });
        return this.ascending;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if ("SWITCHORDER".equals(cmd)) {
            this.toggleTreeOrder();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        if (path == null) {
            this.reloadButton.setEnabled(false);
            return;
        }
        Object selObj = path.getLastPathComponent();
        if (selObj instanceof Land) {
            this.reloadButton.setEnabled(true);
        } else {
            this.reloadButton.setEnabled(false);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.treeView != null) {
            this.treeView.setCellRenderer(new VillageIconRenderer());
        }
    }
}

