/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.corelib;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class XmlResource {
    public static final String O_XSDBASE = "http://jindolf.sourceforge.jp/xml/xsd/";
    public static final String I_XSDBASE = "resources/xsd/";
    public static final String I_XMLBASE = "resources/xml/";
    public static final String O_RES_EXTXML = "http://www.w3.org/2001/xml.xsd";
    public static final String O_RES_CORETYPE = "http://jindolf.sourceforge.jp/xml/xsd/coreType-090829.xsd";
    public static final String O_RES_COREXML = "http://jindolf.sourceforge.jp/xml/xsd/coreXML-090829.xsd";
    public static final String I_RES_EXTXML = "resources/xsd/ext/xml-2009-01.xsd";
    public static final String I_RES_CORETYPE = "resources/xsd/private/coreType-090829.xsd";
    public static final String I_RES_COREXML = "resources/xsd/private/coreXML-090829.xsd";
    public static final String I_RES_LANDDEF = "resources/xml/landDefList.xml";
    public static final String I_RES_AVATARDEF = "resources/xml/preDefAvatarList.xml";
    public static final URI O_URI_EXTXML;
    public static final URI O_URI_CORETYPE;
    public static final URI O_URI_COREXML;
    public static final URI I_URI_EXTXML;
    public static final URI I_URI_CORETYPE;
    public static final URI I_URI_COREXML;
    public static final URI I_URI_LANDDEF;
    public static final URI I_URI_AVATARDEF;
    public static final URL I_URL_COREXML;
    public static final URL I_URL_LANDDEF;
    public static final URL I_URL_AVATARDEF;
    public static final Map<URI, URI> RESOLVE_MAP;
    private static final Class<?> THISCLASS;

    private XmlResource() {
        assert (this.getClass().equals(THISCLASS));
    }

    private static URI loadInner(String res) throws FileNotFoundException, URISyntaxException {
        URL url = THISCLASS.getResource(res);
        if (url == null) {
            throw new FileNotFoundException(res);
        }
        URI result = url.toURI().normalize();
        return result;
    }

    private static URI loadOuter(String http) {
        URI uri = URI.create(http).normalize();
        return uri;
    }

    static {
        THISCLASS = XmlResource.class;
        new XmlResource().hashCode();
        O_URI_EXTXML = XmlResource.loadOuter(O_RES_EXTXML);
        O_URI_CORETYPE = XmlResource.loadOuter(O_RES_CORETYPE);
        O_URI_COREXML = XmlResource.loadOuter(O_RES_COREXML);
        try {
            I_URI_EXTXML = XmlResource.loadInner(I_RES_EXTXML);
            I_URI_CORETYPE = XmlResource.loadInner(I_RES_CORETYPE);
            I_URI_COREXML = XmlResource.loadInner(I_RES_COREXML);
            I_URI_LANDDEF = XmlResource.loadInner(I_RES_LANDDEF);
            I_URI_AVATARDEF = XmlResource.loadInner(I_RES_AVATARDEF);
        }
        catch (FileNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            I_URL_COREXML = I_URI_COREXML.toURL();
            I_URL_LANDDEF = I_URI_LANDDEF.toURL();
            I_URL_AVATARDEF = I_URI_AVATARDEF.toURL();
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
        HashMap<URI, URI> map = new HashMap<URI, URI>();
        map.put(O_URI_EXTXML, I_URI_EXTXML);
        map.put(O_URI_CORETYPE, I_URI_CORETYPE);
        map.put(O_URI_COREXML, I_URI_COREXML);
        RESOLVE_MAP = Collections.unmodifiableMap(map);
    }
}

