/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jovsonz;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.sourceforge.jovsonz.JsComposition;
import jp.sourceforge.jovsonz.JsPair;
import jp.sourceforge.jovsonz.JsParseException;
import jp.sourceforge.jovsonz.JsString;
import jp.sourceforge.jovsonz.JsTypes;
import jp.sourceforge.jovsonz.JsValue;
import jp.sourceforge.jovsonz.JsVisitException;
import jp.sourceforge.jovsonz.Json;
import jp.sourceforge.jovsonz.JsonSource;
import jp.sourceforge.jovsonz.UnmodIterator;
import jp.sourceforge.jovsonz.ValueVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsObject
implements JsComposition<JsPair> {
    private static final String ERRMSG_NOOBJECTCOMMA = "missing comma in OBJECT";
    private static final String ERRMSG_NOHASHNAME = "no hash name in OBJECT";
    private static final String ERRMSG_NOHASHSEP = "missing hash separator(:) in OBJECT";
    private static final String ERRMSG_NOHASHVAL = "no hash value in OBJECT";
    private final Map<String, JsPair> pairMap = new TreeMap<String, JsPair>();
    private final Collection<JsPair> pairCollection = this.pairMap.values();
    private boolean changed = false;

    static JsObject parseObject(JsonSource source) throws IOException, JsParseException {
        char charHead = source.readOrDie();
        if (charHead != '{') {
            source.unread(charHead);
            return null;
        }
        JsObject result = new JsObject();
        while (true) {
            source.skipWhiteSpace();
            char chData = source.readOrDie();
            if (chData == '}') break;
            if (result.isEmpty()) {
                source.unread(chData);
            } else {
                if (chData != ',') {
                    throw new JsParseException(ERRMSG_NOOBJECTCOMMA, source.getLineNumber());
                }
                source.skipWhiteSpace();
            }
            JsString name = JsString.parseString(source);
            if (name == null) {
                throw new JsParseException(ERRMSG_NOHASHNAME, source.getLineNumber());
            }
            source.skipWhiteSpace();
            chData = source.readOrDie();
            if (chData != ':') {
                throw new JsParseException(ERRMSG_NOHASHSEP, source.getLineNumber());
            }
            JsValue value = Json.parseValue(source);
            if (value == null) {
                throw new JsParseException(ERRMSG_NOHASHVAL, source.getLineNumber());
            }
            result.putValue(name.toRawString(), value);
        }
        return result;
    }

    @Override
    public JsTypes getJsTypes() {
        return JsTypes.OBJECT;
    }

    @Override
    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (JsPair pair : this) {
            JsComposition composition;
            JsValue value = pair.getValue();
            if (!(value instanceof JsComposition) || !(composition = (JsComposition)value).hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setUnchanged() {
        this.changed = false;
        for (JsPair pair : this) {
            JsValue value = pair.getValue();
            if (!(value instanceof JsComposition)) continue;
            JsComposition composition = (JsComposition)value;
            composition.setUnchanged();
        }
    }

    @Override
    public void traverse(ValueVisitor visitor) throws JsVisitException {
        visitor.visitValue(this);
        for (JsPair pair : this) {
            String name = pair.getName();
            JsValue value = pair.getValue();
            visitor.visitPairName(name);
            value.traverse(visitor);
        }
        visitor.visitCompositionClose(this);
    }

    @Override
    public int size() {
        return this.pairMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.pairMap.isEmpty();
    }

    @Override
    public void clear() {
        if (this.pairMap.size() > 0) {
            this.changed = true;
        }
        this.pairMap.clear();
    }

    public int hashCode() {
        return this.pairMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsObject)) {
            return false;
        }
        JsObject composit = (JsObject)obj;
        return this.pairMap.equals(composit.pairMap);
    }

    public JsValue putValue(String name, JsValue value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        JsValue oldValue = null;
        JsPair oldPair = this.pairMap.get(name);
        if (oldPair != null && value.equals(oldValue = oldPair.getValue())) {
            return null;
        }
        JsPair newPair = new JsPair(name, value);
        this.pairMap.put(name, newPair);
        this.changed = true;
        return oldValue;
    }

    public JsValue getValue(String name) {
        JsPair pair = this.pairMap.get(name);
        if (pair == null) {
            return null;
        }
        JsValue value = pair.getValue();
        return value;
    }

    public void putPair(JsPair pair) {
        this.pairMap.put(pair.getName(), pair);
    }

    public JsPair getPair(String name) {
        JsValue value = this.getValue(name);
        if (value == null) {
            return null;
        }
        return new JsPair(name, value);
    }

    public JsPair remove(String name) {
        JsPair oldPair = this.pairMap.remove(name);
        if (oldPair != null) {
            this.changed = true;
        }
        return oldPair;
    }

    public Set<String> nameSet() {
        return this.pairMap.keySet();
    }

    public List<JsPair> getPairList() {
        ArrayList<JsPair> result = new ArrayList<JsPair>(this.pairMap.size());
        for (JsPair pair : this) {
            result.add(pair);
        }
        return result;
    }

    @Override
    public Iterator<JsPair> iterator() {
        return UnmodIterator.unmodIterator(this.pairCollection);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("{");
        boolean hasElem = false;
        for (JsPair pair : this) {
            if (hasElem) {
                text.append(',');
            }
            text.append(pair);
            hasElem = true;
        }
        text.append("}");
        return text.toString();
    }
}

