/*
 * Decompiled with CFR 0.152.
 */
package io.bitbucket.olyutorskii.jiocema;

import io.bitbucket.olyutorskii.jiocema.CharDecodeListener;
import io.bitbucket.olyutorskii.jiocema.DecodeBreakException;
import io.bitbucket.olyutorskii.jiocema.EmptyListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.MessageFormat;
import java.util.Arrays;

public class DecodeNotifier {
    public static final int DEFSZ_BYTEBUF = 2048;
    public static final int DEFSZ_CHARBUF = 1024;
    private static final int DEFSZ_ERRBUF = 2;
    private static final String MSGFORM_INFLOOP = "too small input buffer ({0}bytes) for {1}";
    private static final String MSGFORM_INBUFLEN = "input buffer must have an effective length";
    private static final String MSGFORM_OUTBUFLEN = "output buffer length must be 2 or more for surrogate pair";
    private static final InputStream DMY_IS = new ByteArrayInputStream(new byte[0]);
    private final CharsetDecoder decoder;
    private InputStream istream;
    private final byte[] byteInData;
    private final char[] charOutData;
    private byte[] errorOutData;
    private final ByteBuffer byteInBuffer;
    private final CharBuffer charOutBuffer;
    private CharDecodeListener listener;
    private boolean isChokingMode;
    private CoderResult decodingResult;
    private boolean hasMoreInput;
    private boolean isFlushing;
    private boolean decodeDone;

    public DecodeNotifier(CharsetDecoder decoder) {
        this(decoder, 2048, 1024);
    }

    public DecodeNotifier(CharsetDecoder decoder, int inbufSz, int outbufSz) throws IllegalArgumentException {
        if (inbufSz < 1) {
            throw new IllegalArgumentException(MSGFORM_INBUFLEN);
        }
        if (outbufSz < 2) {
            throw new IllegalArgumentException(MSGFORM_OUTBUFLEN);
        }
        this.decoder = decoder;
        this.byteInData = new byte[inbufSz];
        this.charOutData = new char[outbufSz];
        this.errorOutData = new byte[2];
        this.byteInBuffer = ByteBuffer.wrap(this.byteInData);
        this.charOutBuffer = CharBuffer.wrap(this.charOutData);
        this.istream = DMY_IS;
        this.listener = EmptyListener.DUMMY_LISTENER;
        this.isChokingMode = false;
        this.initDecoderImpl();
    }

    protected void initDecoder() {
        this.initDecoderImpl();
    }

    private void initDecoderImpl() {
        this.byteInBuffer.clear().flip();
        this.charOutBuffer.clear();
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.decoder.reset();
        this.decodingResult = CoderResult.UNDERFLOW;
        this.hasMoreInput = true;
        this.isFlushing = false;
        this.decodeDone = false;
        Arrays.fill(this.errorOutData, (byte)0);
    }

    public void setCharDecodeListener(CharDecodeListener listenerArg) {
        this.listener = listenerArg == null ? EmptyListener.DUMMY_LISTENER : listenerArg;
    }

    public void setChokingMode(boolean isChoking) {
        this.isChokingMode = isChoking;
    }

    public boolean isChokingMode() {
        boolean result = this.isChokingMode;
        return result;
    }

    protected ByteBuffer getByteBuffer() {
        return this.byteInBuffer;
    }

    protected CharBuffer getCharBuffer() {
        return this.charOutBuffer;
    }

    protected boolean hasDecodeError() {
        boolean result = this.decodingResult.isError();
        return result;
    }

    protected boolean isCharBufOver() {
        boolean result = this.decodingResult.isOverflow();
        return result;
    }

    protected boolean hasMoreInput() {
        boolean result = this.hasMoreInput;
        return result;
    }

    protected boolean isFlushDone() {
        boolean result = this.decodeDone;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(InputStream istream) throws IOException, DecodeBreakException {
        this.istream = istream;
        try {
            this.decodeImpl();
        }
        finally {
            try {
                this.istream.close();
            }
            finally {
                this.istream = DMY_IS;
            }
        }
    }

    private void decodeImpl() throws IOException, DecodeBreakException {
        this.initDecoder();
        this.listener.startDecoding(this.decoder);
        do {
            if (this.isCharBufOver()) {
                this.sweepOutCharBuf();
            } else if (this.hasMoreInput()) {
                this.supplyInputBytes();
            }
            this.decodeByte2Char();
        } while (!this.isFlushDone());
        this.sweepOutCharBuf();
        this.listener.endDecoding();
    }

    private void decodeByte2Char() throws DecodeBreakException, IOException {
        int offset = this.byteInBuffer.position();
        int decodedSpan = this.doDecodeOrFlush();
        if (decodedSpan > 0) {
            this.notifyRawBytesConsumed(offset, decodedSpan);
            if (this.isChokingMode()) {
                this.sweepOutCharBuf();
            }
        }
        int errorSpan = 0;
        if (this.hasDecodeError()) {
            this.sweepOutCharBuf();
            this.byteInBuffer.compact().flip();
            errorSpan = this.skipErrorBytes();
        }
        if (decodedSpan <= 0 && errorSpan <= 0) {
            this.infLoopCheck();
        }
    }

    private int doDecodeOrFlush() {
        int decodedSpan = 0;
        if (!this.isFlushing) {
            int oldPos = this.byteInBuffer.position();
            boolean endOfInput = !this.hasMoreInput;
            this.decodingResult = this.decoder.decode(this.byteInBuffer, this.charOutBuffer, endOfInput);
            if (endOfInput && this.decodingResult.isUnderflow()) {
                this.isFlushing = true;
            }
            int newPos = this.byteInBuffer.position();
            decodedSpan = newPos - oldPos;
        } else {
            this.decodingResult = this.decoder.flush(this.charOutBuffer);
            if (this.decodingResult.isUnderflow()) {
                this.decodeDone = true;
            }
        }
        return decodedSpan;
    }

    private void infLoopCheck() throws IllegalStateException {
        boolean deadLock;
        int pos = this.byteInBuffer.position();
        int limit = this.byteInBuffer.limit();
        int capacity = this.byteInBuffer.capacity();
        boolean noMoreInputSpace = pos == 0 && limit == capacity;
        boolean bl = deadLock = noMoreInputSpace && this.decodingResult.isUnderflow();
        if (deadLock) {
            String csName = this.decoder.charset().name();
            String msg = MessageFormat.format(MSGFORM_INFLOOP, capacity, csName);
            throw new IllegalStateException(msg);
        }
    }

    protected int supplyInputBytes() throws IOException {
        if (!this.hasMoreInput()) {
            return -1;
        }
        this.byteInBuffer.compact();
        int ioSz = this.isChokingMode() ? 1 : this.byteInBuffer.remaining();
        assert (ioSz > 0);
        int offset = this.byteInBuffer.position();
        int ioDone = this.istream.read(this.byteInData, offset, ioSz);
        assert (ioSz != 0 && ioDone != 0);
        if (ioDone > 0) {
            int newPos = offset + ioDone;
            this.byteInBuffer.position(newPos);
        } else {
            assert (ioDone < 0);
            this.hasMoreInput = false;
        }
        this.byteInBuffer.flip();
        return ioDone;
    }

    protected int sweepOutCharBuf() throws DecodeBreakException {
        int lastPos = this.charOutBuffer.position();
        if (lastPos <= 0) {
            return 0;
        }
        boolean offset = false;
        this.listener.charContent(this.charOutData, 0, lastPos);
        this.charOutBuffer.clear();
        return lastPos;
    }

    private void notifyRawBytesConsumed(int offset, int length) throws DecodeBreakException {
        this.listener.rawBytes(this.byteInData, offset, length);
    }

    private int skipErrorBytes() throws DecodeBreakException, IOException {
        assert (this.hasDecodeError());
        this.decodingResult = this.modifyErrorResult(this.decodingResult);
        assert (this.decodingResult.isError());
        int errorLength = this.decodingResult.length();
        assert (errorLength > 0);
        this.reassignErrorArray(errorLength);
        boolean offset = false;
        this.byteInBuffer.get(this.errorOutData, 0, errorLength);
        this.notifyErrorBytesSkipped(0, errorLength);
        return errorLength;
    }

    protected CoderResult modifyErrorResult(CoderResult errInfo) throws IOException {
        CoderResult modified = errInfo;
        return modified;
    }

    private void reassignErrorArray(int newSize) {
        int oldLength = this.errorOutData.length;
        if (oldLength >= newSize) {
            return;
        }
        int extSize = Math.max(newSize, oldLength * 2);
        byte[] newArray = Arrays.copyOf(this.errorOutData, extSize);
        this.errorOutData = newArray;
    }

    private void notifyErrorBytesSkipped(int offset, int length) throws DecodeBreakException {
        if (this.decodingResult.isUnmappable()) {
            this.listener.unmapError(this.errorOutData, offset, length);
        } else if (this.decodingResult.isMalformed()) {
            this.listener.malformedError(this.errorOutData, offset, length);
        } else assert (false);
    }
}

