/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.jindolf.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.osdn.jindolf.parser.SeqRange;
import jp.osdn.jindolf.parser.content.DecodedContent;

public class EntityConverter {
    private static final char DQ_CH = '\"';
    private static final String DQ_STR = Character.toString('\"');
    private static final String YEN_STR = "\u00a5";
    private static final char BS_CH = '\\';
    private static final String BS_STR = Character.toString('\\');
    private static final String BS_PATTERN = BS_STR + BS_STR;
    private static final String UCS4_PATTERN = "[\\x{10000}-\\x{10ffff}]";
    private static final RepInfo GT = new RepInfo("&gt;", ">");
    private static final RepInfo LT = new RepInfo("&lt;", "<");
    private static final RepInfo AMP = new RepInfo("&amp;", "&");
    private static final RepInfo QUAT = new RepInfo("&quot;", DQ_STR);
    private static final RepInfo BS = new RepInfo(BS_PATTERN, "\u00a5");
    private static final RepInfo UCS4 = new RepInfo("[\\x{10000}-\\x{10ffff}]", "?");
    private final MultiMatcher multiMatcher = new MultiMatcher();
    private final boolean replaceSmp;

    public EntityConverter() {
        this(false);
    }

    public EntityConverter(boolean replaceSmp) {
        this.multiMatcher.putRepInfo(GT, LT, AMP, QUAT, BS, UCS4);
        this.replaceSmp = replaceSmp;
    }

    public DecodedContent convert(DecodedContent srcContent) {
        int startPos = 0;
        int endPos = srcContent.length();
        return this.append(null, srcContent, startPos, endPos);
    }

    public DecodedContent convert(DecodedContent srcContent, SeqRange range) throws IndexOutOfBoundsException {
        int startPos = range.getStartPos();
        int endPos = range.getEndPos();
        return this.append(null, srcContent, startPos, endPos);
    }

    public DecodedContent convert(DecodedContent srcContent, int startPos, int endPos) throws IndexOutOfBoundsException {
        return this.append(null, srcContent, startPos, endPos);
    }

    public DecodedContent append(DecodedContent dstContent, DecodedContent srcContent) throws IndexOutOfBoundsException {
        int startPos = 0;
        int endPos = srcContent.length();
        return this.append(dstContent, srcContent, startPos, endPos);
    }

    public DecodedContent append(DecodedContent dstContent, DecodedContent srcContent, SeqRange range) throws IndexOutOfBoundsException {
        int startPos = range.getStartPos();
        int endPos = range.getEndPos();
        return this.append(dstContent, srcContent, startPos, endPos);
    }

    public DecodedContent append(DecodedContent dstContent, DecodedContent srcContent, int startPos, int endPos) throws IndexOutOfBoundsException {
        RepInfo repInfo;
        DecodedContent result;
        if (startPos > endPos || startPos < 0 || srcContent.length() < endPos) {
            throw new IndexOutOfBoundsException();
        }
        if (dstContent == null) {
            int length = endPos - startPos;
            result = new DecodedContent(length);
        } else {
            result = dstContent;
        }
        CharSequence rawContent = srcContent.getRawContent();
        this.multiMatcher.setText(rawContent, startPos, endPos);
        int copiedPos = startPos;
        while ((repInfo = this.multiMatcher.multiFind()) != null) {
            if (repInfo == UCS4 && !this.replaceSmp) continue;
            int matchStart = this.multiMatcher.getMatchStart();
            int matchEnd = this.multiMatcher.getMatchEnd();
            result.append(srcContent, copiedPos, matchStart);
            String altTxt = repInfo.getAltTxt();
            result.append(altTxt);
            copiedPos = matchEnd;
        }
        result.append(srcContent, copiedPos, endPos);
        return result;
    }

    private static class RepInfo {
        private final String regex;
        private final String altTxt;

        RepInfo(String regex, String altTxt) {
            this.regex = regex;
            this.altTxt = altTxt;
        }

        String getRegex() {
            return this.regex;
        }

        String getAltTxt() {
            return this.altTxt;
        }
    }

    private static class MultiMatcher {
        private static final char REGEX_OR = '|';
        private static final char REGEX_GRPOPEN = '(';
        private static final char REGEX_GRPCLOSE = ')';
        private List<RepInfo> repInfoList;
        private Pattern orPattern;
        private Matcher matcher;
        private int matchStart = -1;
        private int matchEnd = -1;

        MultiMatcher() {
        }

        void putRepInfo(RepInfo ... infos) {
            List<RepInfo> list = Arrays.asList(infos);
            list = Collections.unmodifiableList(list);
            this.repInfoList = list;
            StringBuilder orRegex = new StringBuilder();
            for (RepInfo repInfo : this.repInfoList) {
                String regex = repInfo.getRegex();
                if (orRegex.length() != 0) {
                    orRegex.append('|');
                }
                orRegex.append('(');
                orRegex.append(regex);
                orRegex.append(')');
            }
            this.orPattern = Pattern.compile(orRegex.toString());
            this.matcher = this.orPattern.matcher("");
            this.matchStart = -1;
            this.matchEnd = -1;
        }

        void setText(CharSequence seq, int startPos, int endPos) {
            if (this.matcher == null) {
                throw new IllegalStateException();
            }
            this.matcher.reset(seq);
            this.matcher.region(startPos, endPos);
            this.matchStart = -1;
            this.matchEnd = -1;
        }

        int getMatchStart() {
            return this.matchStart;
        }

        int getMatchEnd() {
            return this.matchEnd;
        }

        RepInfo multiFind() {
            if (this.repInfoList == null || this.matcher == null) {
                throw new IllegalStateException();
            }
            if (!this.matcher.find()) {
                return null;
            }
            RepInfo result = null;
            int group = 1;
            for (RepInfo rc : this.repInfoList) {
                this.matchStart = this.matcher.start(group);
                this.matchEnd = this.matcher.end(group);
                if (this.matchStart >= 0) {
                    result = rc;
                    break;
                }
                ++group;
            }
            return result;
        }
    }
}

