/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.jindolf.parser.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import jp.osdn.jindolf.parser.content.DecodeErrorInfo;

public class DecodedContent
implements CharSequence,
Appendable {
    public static final char ALTCHAR = '?';
    private static final List<DecodeErrorInfo> EMPTY_LIST;
    private static final String NULLTEXT = "null";
    private final StringBuilder rawContent = new StringBuilder();
    private List<DecodeErrorInfo> errList;

    public DecodedContent() {
        this.initImpl();
    }

    public DecodedContent(CharSequence seq) {
        this.initImpl();
        this.rawContent.append(seq);
    }

    public DecodedContent(int capacity) throws NegativeArraySizeException {
        if (capacity < 0) {
            throw new NegativeArraySizeException();
        }
        this.initImpl();
        this.rawContent.ensureCapacity(capacity);
    }

    static List<DecodeErrorInfo> appendGappedErrorInfo(List<DecodeErrorInfo> srcErrList, int startCharPt, int endCharPt, List<DecodeErrorInfo> dstErrList, int gap) {
        boolean hasLoop;
        int errSize;
        if (srcErrList == dstErrList) {
            throw new IllegalArgumentException();
        }
        if (startCharPt >= endCharPt) {
            return dstErrList;
        }
        int startErrorIdx = DecodeErrorInfo.searchErrorIndex(srcErrList, startCharPt);
        if (startErrorIdx >= (errSize = srcErrList.size())) {
            return null;
        }
        int endErrorIdx = DecodedContent.calcEndIdx(srcErrList, endCharPt);
        boolean bl = hasLoop = 0 <= startErrorIdx && startErrorIdx <= endErrorIdx;
        if (!hasLoop) {
            return null;
        }
        List<DecodeErrorInfo> result = dstErrList == null ? DecodedContent.createErrorList() : dstErrList;
        DecodedContent.copyGappedErrorInfo(srcErrList, startErrorIdx, endErrorIdx, result, gap);
        return result;
    }

    private static int calcEndIdx(List<DecodeErrorInfo> srcErrList, int endCharPt) {
        int errSize;
        int lastCharPos = endCharPt - 1;
        int endErrorIdx = DecodeErrorInfo.searchErrorIndex(srcErrList, lastCharPos);
        if (endErrorIdx >= (errSize = srcErrList.size())) {
            endErrorIdx = errSize - 1;
        } else {
            boolean isLastErrorInfoOnLastPos;
            DecodeErrorInfo lastErrorInfo = srcErrList.get(endErrorIdx);
            boolean bl = isLastErrorInfoOnLastPos = lastErrorInfo.getCharPosition() == lastCharPos;
            if (!isLastErrorInfoOnLastPos) {
                --endErrorIdx;
            }
        }
        return endErrorIdx;
    }

    private static void copyGappedErrorInfo(List<DecodeErrorInfo> srcErrList, int startErrorIdx, int endErrorIdx, List<DecodeErrorInfo> dstErrList, int gap) {
        for (int index = startErrorIdx; index <= endErrorIdx; ++index) {
            DecodeErrorInfo srcErrInfo = srcErrList.get(index);
            DecodeErrorInfo gappedInfo = srcErrInfo.createGappedClone(gap);
            dstErrList.add(gappedInfo);
        }
    }

    private static List<DecodeErrorInfo> createErrorList() {
        ArrayList<DecodeErrorInfo> result = new ArrayList<DecodeErrorInfo>();
        return result;
    }

    public void init() {
        this.initImpl();
    }

    private void initImpl() {
        this.rawContent.setLength(0);
        if (this.errList != null) {
            this.errList.clear();
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        this.rawContent.ensureCapacity(minimumCapacity);
    }

    public boolean hasDecodeError() {
        if (this.errList == null) {
            return false;
        }
        return !this.errList.isEmpty();
    }

    public List<DecodeErrorInfo> getDecodeErrorList() {
        if (!this.hasDecodeError()) {
            return EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.errList);
    }

    public CharSequence getRawContent() {
        return this.rawContent;
    }

    public void setCharAt(int index, char ch) throws IndexOutOfBoundsException {
        this.rawContent.setCharAt(index, ch);
    }

    @Override
    public char charAt(int index) {
        return this.rawContent.charAt(index);
    }

    @Override
    public int length() {
        return this.rawContent.length();
    }

    @Override
    public CharSequence subSequence(int startCharPt, int endCharPt) {
        return this.rawContent.subSequence(startCharPt, endCharPt);
    }

    public DecodedContent subContent(int startCharPt, int endCharPt) throws IndexOutOfBoundsException {
        int length = endCharPt - startCharPt;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        DecodedContent result = new DecodedContent(length);
        result.append(this, startCharPt, endCharPt);
        return result;
    }

    @Override
    public DecodedContent append(char letter) {
        this.rawContent.append(letter);
        return this;
    }

    @Override
    public DecodedContent append(CharSequence seq) {
        DecodedContent result;
        if (seq == null) {
            result = this.append(NULLTEXT);
        } else if (seq instanceof DecodedContent) {
            DecodedContent content = (DecodedContent)seq;
            int seqLen = seq.length();
            result = this.append(content, 0, seqLen);
        } else {
            this.rawContent.append(seq);
            result = this;
        }
        return result;
    }

    @Override
    public DecodedContent append(CharSequence seq, int startCharPt, int endCharPt) throws IndexOutOfBoundsException {
        DecodedContent result;
        if (seq == null) {
            result = this.append(NULLTEXT, startCharPt, endCharPt);
        } else if (seq instanceof DecodedContent) {
            result = this.append((DecodedContent)seq, startCharPt, endCharPt);
        } else {
            if (startCharPt < 0 || startCharPt > endCharPt || endCharPt > seq.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (startCharPt == endCharPt) {
                result = this;
            } else {
                this.rawContent.append(seq, startCharPt, endCharPt);
                result = this;
            }
        }
        return result;
    }

    public DecodedContent append(char[] str, int offset, int len) throws IndexOutOfBoundsException {
        this.rawContent.append(str, offset, len);
        return this;
    }

    public DecodedContent append(DecodedContent source, int startCharPt, int endCharPt) throws IndexOutOfBoundsException {
        if (source == null) {
            return this.append(NULLTEXT, startCharPt, endCharPt);
        }
        if (startCharPt < 0 || startCharPt > endCharPt || endCharPt > source.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (startCharPt == endCharPt) {
            return this;
        }
        int oldLength = this.rawContent.length();
        this.rawContent.append(source.rawContent, startCharPt, endCharPt);
        if (!source.hasDecodeError()) {
            return this;
        }
        List<DecodeErrorInfo> srcErrList = source.errList;
        List<DecodeErrorInfo> dstErrList = source == this ? null : this.errList;
        int gap = startCharPt - oldLength;
        dstErrList = DecodedContent.appendGappedErrorInfo(srcErrList, startCharPt, endCharPt, dstErrList, gap);
        if (dstErrList == null) {
            return this;
        }
        if (dstErrList == this.errList) {
            return this;
        }
        if (this.errList == null) {
            this.errList = dstErrList;
        } else {
            this.errList.addAll(dstErrList);
        }
        return this;
    }

    void addDecodeError(DecodeErrorInfo errorInfo) {
        if (this.errList == null) {
            this.errList = DecodedContent.createErrorList();
        }
        this.errList.add(errorInfo);
        this.rawContent.append('?');
    }

    public void addDecodeError(byte b1st) {
        DecodeErrorInfo errInfo = new DecodeErrorInfo(this.rawContent.length(), b1st);
        this.addDecodeError(errInfo);
    }

    public void addDecodeError(byte b1st, byte b2nd) {
        DecodeErrorInfo errInfo = new DecodeErrorInfo(this.rawContent.length(), b1st, b2nd);
        this.addDecodeError(errInfo);
    }

    @Override
    public String toString() {
        return this.rawContent.toString();
    }

    static {
        List emptyList = Collections.emptyList();
        emptyList = Collections.unmodifiableList(emptyList);
        EMPTY_LIST = emptyList;
        assert (DecodedContent.createErrorList() instanceof RandomAccess);
    }
}

