/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import io.bitbucket.olyutorskii.jiocema.DecodeBreakException;
import io.bitbucket.olyutorskii.jiocema.DecodeNotifier;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import jp.osdn.jindolf.parser.HtmlParseException;
import jp.osdn.jindolf.parser.HtmlParser;
import jp.osdn.jindolf.parser.content.ContentBuilder;
import jp.osdn.jindolf.parser.content.ContentBuilderSJ;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.osdn.jindolf.parser.content.SjisNotifier;
import jp.sourceforge.jindolf.archiver.Handler;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.VillageData;

public final class Builder {
    private static final int BUF_SZ = 102400;

    private Builder() {
        assert (false);
        throw new AssertionError();
    }

    public static DecodedContent contentFromStream(Charset charset, InputStream istream) throws IOException, DecodeBreakException {
        ContentBuilder builder;
        DecodeNotifier decoder;
        String name = charset.name();
        if ("Shift_JIS".equalsIgnoreCase(name)) {
            decoder = new SjisNotifier();
            builder = new ContentBuilderSJ(102400);
        } else if ("UTF-8".equalsIgnoreCase(name)) {
            decoder = new DecodeNotifier(charset.newDecoder());
            builder = new ContentBuilder(102400);
        } else {
            assert (false);
            return null;
        }
        decoder.setCharDecodeListener(builder);
        decoder.decode(istream);
        DecodedContent content = builder.getContent();
        return content;
    }

    public static void fillVillageData(VillageData villageData) throws IOException, DecodeBreakException, HtmlParseException {
        HtmlParser parser = new HtmlParser();
        Handler handler = new Handler();
        parser.setBasicHandler(handler);
        parser.setTalkHandler(handler);
        parser.setSysEventHandler(handler);
        handler.initVillageData(villageData);
        Charset charset = villageData.getLandDef().getEncoding();
        for (PeriodResource resource : villageData.getPeriodResourceList()) {
            DecodedContent content;
            handler.initPeriodResource(resource);
            URL url = resource.getResourceUrl();
            if (url == null) {
                url = new URL(resource.getOrigUrlText());
            }
            URLConnection conn = url.openConnection();
            try (InputStream istream = conn.getInputStream();){
                if (resource.getDownTimeMs() <= 0L) {
                    long downTimeMs = conn.getDate();
                    resource.setDownTimeMs(downTimeMs);
                }
                content = Builder.contentFromStream(charset, istream);
            }
            parser.parseAutomatic(content);
        }
    }
}

