/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.osdn.jindolf.parser.EntityConverter;
import jp.osdn.jindolf.parser.HtmlAdapter;
import jp.osdn.jindolf.parser.HtmlParseException;
import jp.osdn.jindolf.parser.PageType;
import jp.osdn.jindolf.parser.SeqRange;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sourceforge.jindolf.archiver.AvatarData;
import jp.sourceforge.jindolf.archiver.EventData;
import jp.sourceforge.jindolf.archiver.PeriodData;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.TalkData;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.archiver.Win31j;
import jp.sourceforge.jindolf.corelib.DisclosureType;
import jp.sourceforge.jindolf.corelib.EventFamily;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.corelib.TalkType;
import jp.sourceforge.jindolf.corelib.Team;
import jp.sourceforge.jindolf.corelib.VillageTag;

public class Handler
extends HtmlAdapter {
    private static final Pattern MURDER_PATTERN = Pattern.compile("^(.*) \uff01 \u4eca\u65e5\u304c\u304a\u524d\u306e\u547d\u65e5\u3060\uff01$");
    private final EntityConverter converter = new EntityConverter();
    private VillageData villageData = null;
    private String pageTitle = null;
    private PeriodData currentPeriod = null;
    private PeriodResource currentResource = null;
    private TalkData currentTalk = null;
    private EventData currentEvent = null;

    public void initVillageData(VillageData villageDataArg) {
        this.villageData = villageDataArg;
        this.currentPeriod = null;
        this.pageTitle = null;
    }

    public void initPeriodResource(PeriodResource resource) {
        this.currentResource = resource;
    }

    @Override
    public void startParse(DecodedContent content) throws HtmlParseException {
        if (this.villageData == null) {
            throw new HtmlParseException();
        }
        this.currentPeriod = new PeriodData(this.villageData, this.currentResource);
    }

    @Override
    public void pageTitle(DecodedContent content, SeqRange titleRange) throws HtmlParseException {
        DecodedContent title = this.converter.convert(content, titleRange);
        if (this.pageTitle == null) {
            this.pageTitle = title.toString();
        } else if (!this.pageTitle.contentEquals(title)) {
            throw new HtmlParseException();
        }
    }

    @Override
    public void loginName(DecodedContent content, SeqRange loginRange) throws HtmlParseException {
        DecodedContent account = this.converter.convert(content, loginRange);
        this.currentPeriod.setLoginName(account);
    }

    @Override
    public void pageType(PageType type) throws HtmlParseException {
        if (type != PageType.PERIOD_PAGE) {
            throw new HtmlParseException();
        }
    }

    @Override
    public void villageName(DecodedContent content, SeqRange villageRange) throws HtmlParseException {
        String vName = this.converter.convert(content, villageRange).toString();
        String fullName = this.villageData.getFullName();
        if (fullName.length() <= 0) {
            if (!this.pageTitle.endsWith(vName)) {
                throw new HtmlParseException();
            }
            Pattern ptn = Pattern.compile("^([^0-9]*)([0-9]+)\\s+(\\S+)$");
            Matcher matcher = ptn.matcher(vName);
            if (!matcher.matches()) {
                throw new HtmlParseException();
            }
            String prefix = matcher.group(1);
            String vid = matcher.group(2);
            String vtag = matcher.group(3);
            LandDef landDef = this.villageData.getLandDef();
            if (!prefix.equals(landDef.getLandPrefix())) {
                throw new HtmlParseException();
            }
            if (Integer.parseInt(vid) != this.villageData.getVillageId()) {
                throw new HtmlParseException();
            }
            matcher.reset(vtag);
            if (VillageTag.lookingAtVillageTag(matcher) == null) {
                throw new HtmlParseException();
            }
            this.villageData.setFullName(vName);
        } else if (!vName.equals(fullName)) {
            throw new HtmlParseException();
        }
    }

    @Override
    public void commitTime(int month, int day, int hour, int minute) throws HtmlParseException {
        int commitHour = this.villageData.getCommitHour();
        int commitMinute = this.villageData.getCommitMinute();
        if (commitHour < 0) {
            this.villageData.setCommitHour(hour);
        } else if (hour != commitHour) {
            throw new HtmlParseException();
        }
        if (commitMinute < 0) {
            this.villageData.setCommitMinute(minute);
        } else if (minute != commitMinute) {
            throw new HtmlParseException();
        }
        this.currentPeriod.setCommitMonth(month);
        this.currentPeriod.setCommitDay(day);
        this.currentPeriod.setCommitHour(hour);
        this.currentPeriod.setCommitMinute(minute);
    }

    @Override
    public void periodLink(DecodedContent content, SeqRange anchorRange, PeriodType periodType, int day) throws HtmlParseException {
        if (anchorRange.isValid()) {
            DisclosureType newType = periodType == null ? DisclosureType.COMPLETE : (periodType == PeriodType.EPILOGUE && this.currentResource.getPeriodType() != PeriodType.EPILOGUE ? DisclosureType.COMPLETE : (periodType != PeriodType.PROLOGUE && this.currentResource.getPeriodType() == PeriodType.PROLOGUE ? DisclosureType.COMPLETE : DisclosureType.UNCOMPLETE));
            this.currentPeriod.setDisclosureType(newType);
            return;
        }
        if (periodType != this.currentResource.getPeriodType()) {
            throw new HtmlParseException();
        }
        if (periodType == PeriodType.PROGRESS && day != this.currentResource.getDay()) {
            throw new HtmlParseException();
        }
        this.currentPeriod.setDisclosureType(DisclosureType.HOT);
    }

    @Override
    public void startTalk() throws HtmlParseException {
        this.currentTalk = new TalkData();
    }

    @Override
    public void talkAvatar(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentTalk.setAvatarData(avatar);
    }

    @Override
    public void talkIconUrl(DecodedContent content, SeqRange urlRange) throws HtmlParseException {
        DecodedContent faceIcon = this.converter.convert(content, urlRange);
        this.currentTalk.setFaceIconUri(faceIcon.toString());
    }

    @Override
    public void talkId(DecodedContent content, SeqRange idRange) throws HtmlParseException {
        DecodedContent xname = this.converter.convert(content, idRange);
        this.currentTalk.setXName(xname.toString());
    }

    @Override
    public void talkTime(int hour, int minute) throws HtmlParseException {
        this.currentTalk.setHour(hour);
        this.currentTalk.setMinute(minute);
    }

    @Override
    public void talkType(TalkType type) throws HtmlParseException {
        this.currentTalk.setTalkType(type);
    }

    @Override
    public void talkText(DecodedContent content, SeqRange textRange) throws HtmlParseException {
        DecodedContent line = this.converter.convert(content, textRange);
        this.currentTalk.addLine(line);
    }

    @Override
    public void talkBreak() throws HtmlParseException {
        this.currentTalk.addBreak();
    }

    @Override
    public void endTalk() throws HtmlParseException {
        DecodedContent line1st;
        Matcher matcher;
        boolean maybeAssaultEvent;
        String faceIcon = this.currentTalk.getFaceIconUri();
        if (this.currentTalk.getTalkType() == TalkType.GRAVE) {
            this.villageData.setGraveIconUri(faceIcon);
        } else {
            AvatarData avatar = this.currentTalk.getAvatarData();
            if (avatar.getFaceIconUri() == null) {
                avatar.setFaceIconUri(faceIcon);
            }
        }
        TalkType currentTalkType = this.currentTalk.getTalkType();
        int talkLineNum = this.currentTalk.getLineNum();
        boolean hasNotMurder = !this.currentPeriod.hasMurderResult();
        boolean isWolfTalk = currentTalkType == TalkType.WOLFONLY;
        boolean isOneLineTalk = talkLineNum == 1;
        boolean bl = maybeAssaultEvent = hasNotMurder && isWolfTalk && isOneLineTalk;
        if (maybeAssaultEvent && (matcher = MURDER_PATTERN.matcher(line1st = this.currentTalk.get1stLine())).matches()) {
            String avatarName = matcher.group(1);
            AvatarData target = this.villageData.getAvatarData(avatarName);
            EventData event = this.buildAssaultEvent(target);
            this.currentPeriod.addTopicData(event);
            this.currentTalk = null;
            return;
        }
        this.currentPeriod.addTopicData(this.currentTalk);
        this.currentTalk = null;
    }

    private EventData buildAssaultEvent(AvatarData target) {
        DecodedContent line1st = this.currentTalk.get1stLine();
        String xname = this.currentTalk.getXName();
        int hour = this.currentTalk.getHour();
        int minute = this.currentTalk.getMinute();
        AvatarData byWhom = this.currentTalk.getAvatarData();
        String iconUri = this.currentTalk.getFaceIconUri();
        if (byWhom.getFaceIconUri() == null) {
            byWhom.setFaceIconUri(iconUri);
        }
        EventData event = new EventData();
        event.setEventType(SysEventType.ASSAULT);
        event.addLine(line1st);
        event.addAvatarData(byWhom);
        event.addAvatarData(target);
        event.addDecodedContent(new DecodedContent(xname));
        event.addInteger(hour);
        event.addInteger(minute);
        event.addDecodedContent(new DecodedContent(iconUri));
        return event;
    }

    @Override
    public void startSysEvent(EventFamily eventFamily) throws HtmlParseException {
        this.currentEvent = new EventData();
    }

    @Override
    public void sysEventType(SysEventType type) throws HtmlParseException {
        this.currentEvent.setEventType(type);
    }

    @Override
    public void sysEventContent(DecodedContent content, SeqRange contentRange) throws HtmlParseException {
        DecodedContent line = this.converter.convert(content, contentRange);
        this.currentEvent.addLine(line);
    }

    @Override
    public void sysEventContentAnchor(DecodedContent content, SeqRange anchorRange, SeqRange contentRange) throws HtmlParseException {
        DecodedContent line = this.converter.convert(content, contentRange);
        this.currentEvent.addLine(line);
    }

    @Override
    public void sysEventContentBreak() throws HtmlParseException {
        this.currentEvent.addBreak();
    }

    @Override
    public void sysEventOnStage(DecodedContent content, int entryNo, SeqRange avatarRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(avatar);
        this.currentEvent.addInteger(entryNo);
    }

    @Override
    public void sysEventOpenRole(GameRole role, int num) throws HtmlParseException {
        this.currentEvent.addGameRole(role);
        this.currentEvent.addInteger(num);
    }

    @Override
    public void sysEventMurdered(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(avatar);
    }

    @Override
    public void sysEventSurvivor(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(avatar);
    }

    @Override
    public void sysEventCounting(DecodedContent content, SeqRange voteByRange, SeqRange voteToRange) throws HtmlParseException {
        AvatarData avatar;
        if (voteByRange.isValid()) {
            DecodedContent voteBy = this.converter.convert(content, voteByRange);
            avatar = this.villageData.getAvatarData(voteBy);
            this.currentEvent.addAvatarData(avatar);
        }
        DecodedContent voteTo = this.converter.convert(content, voteToRange);
        avatar = this.villageData.getAvatarData(voteTo);
        this.currentEvent.addAvatarData(avatar);
    }

    @Override
    public void sysEventCounting2(DecodedContent content, SeqRange voteByRange, SeqRange voteToRange) throws HtmlParseException {
        DecodedContent voteBy = this.converter.convert(content, voteByRange);
        AvatarData avatar = this.villageData.getAvatarData(voteBy);
        this.currentEvent.addAvatarData(avatar);
        DecodedContent voteTo = this.converter.convert(content, voteToRange);
        avatar = this.villageData.getAvatarData(voteTo);
        this.currentEvent.addAvatarData(avatar);
    }

    @Override
    public void sysEventSuddenDeath(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(avatar);
    }

    @Override
    public void sysEventPlayerList(DecodedContent content, SeqRange avatarRange, SeqRange anchorRange, SeqRange loginRange, boolean isLiving, GameRole role) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(avatar);
        DecodedContent uri = anchorRange.isValid() ? this.converter.convert(content, anchorRange) : new DecodedContent("");
        Win31j.supplyWin31jChar(uri);
        this.currentEvent.addDecodedContent(uri);
        DecodedContent account = this.converter.convert(content, loginRange);
        Win31j.supplyWin31jChar(account);
        this.currentEvent.addDecodedContent(account);
        if (isLiving) {
            this.currentEvent.addInteger(1);
        } else {
            this.currentEvent.addInteger(0);
        }
        this.currentEvent.addGameRole(role);
    }

    @Override
    public void sysEventAskEntry(int hour, int minute, int minLimit, int maxLimit) throws HtmlParseException {
        this.currentEvent.addInteger(hour);
        this.currentEvent.addInteger(minute);
        this.currentEvent.addInteger(minLimit);
        this.currentEvent.addInteger(maxLimit);
    }

    @Override
    public void sysEventAskCommit(int hour, int minute) throws HtmlParseException {
        this.currentEvent.addInteger(hour);
        this.currentEvent.addInteger(minute);
    }

    @Override
    public void sysEventNoComment(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(avatar);
    }

    @Override
    public void sysEventStayEpilogue(Team winner, int hour, int minute) throws HtmlParseException {
        GameRole role;
        switch (winner) {
            case VILLAGE: {
                role = GameRole.INNOCENT;
                break;
            }
            case WOLF: {
                role = GameRole.WOLF;
                break;
            }
            case HAMSTER: {
                role = GameRole.HAMSTER;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.currentEvent.addGameRole(role);
        this.currentEvent.addInteger(hour);
        this.currentEvent.addInteger(minute);
    }

    @Override
    public void sysEventGuard(DecodedContent content, SeqRange guardByRange, SeqRange guardToRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, guardByRange);
        AvatarData guardBy = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(guardBy);
        avatarName = this.converter.convert(content, guardToRange);
        AvatarData guardTo = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(guardTo);
    }

    @Override
    public void sysEventJudge(DecodedContent content, SeqRange judgeByRange, SeqRange judgeToRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, judgeByRange);
        AvatarData judgeBy = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(judgeBy);
        avatarName = this.converter.convert(content, judgeToRange);
        AvatarData judgeTo = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(judgeTo);
    }

    @Override
    public void sysEventExecution(DecodedContent content, SeqRange avatarRange, int votes) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(avatar);
        if (votes > 0) {
            this.currentEvent.addInteger(votes);
        }
    }

    @Override
    public void sysEventCheckout(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(avatar);
    }

    @Override
    public void sysEventVanish(DecodedContent content, SeqRange avatarRange) throws HtmlParseException {
        DecodedContent avatarName = this.converter.convert(content, avatarRange);
        AvatarData avatar = this.villageData.getAvatarData(avatarName);
        this.currentEvent.addAvatarData(avatar);
    }

    @Override
    public void endSysEvent() throws HtmlParseException {
        this.currentPeriod.addTopicData(this.currentEvent);
        this.currentEvent = null;
    }

    @Override
    public void endParse() throws HtmlParseException {
        this.villageData.addPeriodData(this.currentPeriod);
        this.currentPeriod = null;
    }
}

