/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.sourceforge.jindolf.archiver.LandUtils;

public enum OptArg implements Iterable<String>
{
    OPT_HELP("-h", "-help", "-?"),
    OPT_LAND("-land"),
    OPT_VID("-vid"),
    OPT_OUTDIR("-outdir"),
    OPT_STDOUT("-stdout");

    private static final Map<String, OptArg> MAP_OPT;
    private static final String FMT_HELP = "\n{0} \u4eba\u72fcBBS \u30a2\u30fc\u30ab\u30a4\u30d6\u4f5c\u6210\u30c4\u30fc\u30eb\n\n-h, -help, -?\n\t\u30d8\u30eb\u30d7\u30e1\u30c3\u30bb\u30fc\u30b8\n-land \u56fd\u8b58\u5225\u5b50\n-vid \u6751\u756a\u53f7\n-outdir \u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\n-stdout\n\t\u6a19\u6e96\u51fa\u529b\u3078\u51fa\u529b\n\n\u203b -outdir \u3068 -stdout \u306f\u6392\u4ed6\u6307\u5b9a\n\n\u5229\u7528\u53ef\u80fd\u306a\u56fd\u8b58\u5225\u5b50\u306f {1}\n";
    private final List<String> argList;

    private OptArg(String ... opts) {
        List<String> list = Arrays.asList(opts);
        list = Collections.unmodifiableList(list);
        this.argList = list;
    }

    public static OptArg parseOptArg(String txt) {
        OptArg result = MAP_OPT.get(txt);
        return result;
    }

    public static String getHelpMessage(String generator) {
        String appName = "";
        if (generator != null) {
            appName = generator;
        }
        String catalog = LandUtils.getLandIdCatalog();
        String result = MessageFormat.format(FMT_HELP, appName, catalog);
        return result;
    }

    public List<String> getArgList() {
        return this.argList;
    }

    @Override
    public Iterator<String> iterator() {
        return this.argList.iterator();
    }

    static {
        HashMap<String, OptArg> map = new HashMap<String, OptArg>();
        for (OptArg optArg : OptArg.values()) {
            for (String argtxt : optArg) {
                map.put(argtxt, optArg);
            }
        }
        MAP_OPT = Collections.unmodifiableMap(map);
    }
}

