/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.jindolf.archiver.AvatarData;
import jp.sourceforge.jindolf.archiver.JinArchiver;
import jp.sourceforge.jindolf.archiver.PeriodData;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.XmlOut;
import jp.sourceforge.jindolf.corelib.DisclosureType;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.PeriodType;
import jp.sourceforge.jindolf.corelib.PreDefAvatar;

public class VillageData {
    private final List<PeriodResource> resourceList;
    private final LandDef landDef;
    private final int villageId;
    private final String baseUri;
    private String fullName = "";
    private int commitHour = -1;
    private int commitMinute = -1;
    private String graveIconUri;
    private final List<AvatarData> avatarList = new LinkedList<AvatarData>();
    private int undefAvatarNo = 1;
    private final List<PeriodData> periodList = new LinkedList<PeriodData>();

    public VillageData(List<PeriodResource> resourceList) {
        VillageData.validatePeriodResource(resourceList);
        this.resourceList = new LinkedList<PeriodResource>(resourceList);
        PeriodResource resource1st = this.resourceList.get(0);
        this.landDef = resource1st.getLandDef();
        this.villageId = resource1st.getVillageId();
        this.baseUri = VillageData.getBaseUri(this.resourceList);
    }

    public static void validatePeriodResource(List<PeriodResource> list) throws IllegalArgumentException {
        LandDef landDef = null;
        int villageId = -1;
        int lastDay = -1;
        PeriodType periodType = null;
        for (PeriodResource resource : list) {
            if (landDef == null) {
                landDef = resource.getLandDef();
            } else if (resource.getLandDef() != landDef) {
                throw new IllegalArgumentException();
            }
            if (villageId < 0) {
                villageId = resource.getVillageId();
            } else if (resource.getVillageId() != villageId) {
                throw new IllegalArgumentException();
            }
            if (lastDay < 0) {
                lastDay = resource.getDay();
                if (lastDay != 0) {
                    throw new IllegalArgumentException();
                }
            } else {
                if (resource.getDay() != lastDay + 1) {
                    throw new IllegalArgumentException();
                }
                lastDay = resource.getDay();
            }
            if (periodType == null) {
                periodType = resource.getPeriodType();
                if (periodType != PeriodType.PROLOGUE) {
                    throw new IllegalArgumentException();
                }
                if (lastDay == 0) continue;
                throw new IllegalArgumentException();
            }
            if (periodType == PeriodType.PROLOGUE) {
                periodType = resource.getPeriodType();
                if (periodType == PeriodType.PROGRESS) continue;
                throw new IllegalArgumentException();
            }
            if (periodType == PeriodType.PROGRESS) {
                periodType = resource.getPeriodType();
                continue;
            }
            if (periodType != PeriodType.EPILOGUE) continue;
            throw new IllegalArgumentException();
        }
        if (lastDay < 0) {
            throw new IllegalArgumentException();
        }
        if (periodType != PeriodType.EPILOGUE) {
            throw new IllegalArgumentException();
        }
    }

    public static String getBaseUri(List<PeriodResource> list) throws IllegalArgumentException {
        String result = null;
        for (PeriodResource resource : list) {
            String urlText = resource.getOrigUrlText();
            urlText = urlText.replaceAll("[^/]*$", "");
            if (result == null) {
                result = urlText;
                continue;
            }
            if (result.equals(urlText)) continue;
            throw new IllegalArgumentException();
        }
        return result;
    }

    public LandDef getLandDef() {
        return this.landDef;
    }

    public int getVillageId() {
        return this.villageId;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public int getCommitHour() {
        return this.commitHour;
    }

    public void setCommitHour(int commitHour) {
        this.commitHour = commitHour;
    }

    public int getCommitMinute() {
        return this.commitMinute;
    }

    public void setCommitMinute(int commitMinute) {
        this.commitMinute = commitMinute;
    }

    public String getGraveIconUri() {
        if (this.graveIconUri == null) {
            return this.landDef.getTombFaceIconURI().toASCIIString();
        }
        return this.graveIconUri;
    }

    public void setGraveIconUri(String graveIconUri) {
        this.graveIconUri = graveIconUri;
    }

    public DisclosureType getDisclosureType() {
        DisclosureType result = DisclosureType.COMPLETE;
        for (PeriodData period : this.periodList) {
            DisclosureType type = period.getDisclosureType();
            switch (type) {
                case HOT: {
                    return DisclosureType.HOT;
                }
                case UNCOMPLETE: {
                    result = DisclosureType.UNCOMPLETE;
                    break;
                }
            }
        }
        return result;
    }

    public void addPeriodData(PeriodData period) {
        this.periodList.add(period);
    }

    public List<PeriodResource> getPeriodResourceList() {
        return Collections.unmodifiableList(this.resourceList);
    }

    public AvatarData createAvatar(String avfullName) {
        AvatarData avatar = new AvatarData();
        avatar.setFullName(avfullName);
        String[] token = avfullName.split("\\s");
        String shortName = token[token.length - 1];
        avatar.setShortName(shortName);
        String avatarId = "ukavatar" + this.undefAvatarNo;
        ++this.undefAvatarNo;
        avatar.setAvatarId(avatarId);
        return avatar;
    }

    public AvatarData getAvatarData(CharSequence seq) {
        AvatarData avatar2;
        for (AvatarData avatar2 : this.avatarList) {
            String avfullName = avatar2.getFullName();
            if (!avfullName.contentEquals(seq)) continue;
            return avatar2;
        }
        PreDefAvatar predefAvatar = AvatarData.getPreDefAvatar(seq);
        if (predefAvatar != null) {
            avatar2 = new AvatarData(predefAvatar);
            this.avatarList.add(avatar2);
            return avatar2;
        }
        avatar2 = this.createAvatar(seq.toString());
        this.avatarList.add(avatar2);
        return avatar2;
    }

    public void dumpAvatarList(XmlOut writer) throws IOException {
        writer.append("<avatarList>");
        writer.nl();
        writer.nl();
        for (AvatarData avatar : this.avatarList) {
            avatar.dumpXml(writer);
            writer.nl();
        }
        writer.append("</avatarList>");
        writer.nl();
    }

    public void dumpPeriodList(XmlOut writer) throws IOException {
        for (PeriodData period : this.periodList) {
            period.dumpXml(writer);
            writer.nl();
        }
    }

    public void dumpXml(XmlOut writer) throws IOException {
        writer.append("<village");
        writer.nl();
        writer.indent(1);
        writer.dumpNameSpaceDecl();
        writer.nl();
        writer.indent(1);
        writer.dumpSiNameSpaceDecl();
        writer.nl();
        writer.indent(1);
        writer.dumpSchemeLocation();
        writer.nl();
        writer.indent(1);
        writer.attrOut("xml:lang", "ja-JP");
        writer.nl();
        writer.indent(1);
        writer.attrOut("xml:base", this.baseUri);
        writer.nl();
        writer.indent(1);
        writer.attrOut("fullName", this.fullName);
        writer.sp();
        writer.attrOut("vid", Integer.toString(this.villageId));
        writer.nl();
        writer.indent(1);
        writer.timeAttrOut("commitTime", this.commitHour, this.commitMinute);
        writer.nl();
        writer.indent(1);
        writer.attrOut("state", "gameover");
        DisclosureType type = this.getDisclosureType();
        if (type != DisclosureType.COMPLETE) {
            writer.sp();
            writer.attrOut("disclosure", type.getXmlName());
        }
        String isValid = this.landDef.isValidVillageId(this.villageId) ? "true" : "false";
        writer.sp();
        writer.attrOut("isValid", isValid);
        writer.nl();
        writer.indent(1);
        writer.attrOut("landName", this.landDef.getLandName());
        writer.sp();
        writer.attrOut("formalName", this.landDef.getFormalName());
        writer.nl();
        writer.indent(1);
        writer.attrOut("landId", this.landDef.getLandId());
        writer.sp();
        writer.attrOut("landPrefix", this.landDef.getLandPrefix());
        writer.nl();
        writer.indent(1);
        String locale = this.landDef.getLocale().toString();
        locale = locale.replaceAll("_", "-");
        writer.attrOut("locale", locale);
        writer.sp();
        writer.attrOut("origencoding", this.landDef.getEncoding().name());
        writer.sp();
        writer.attrOut("timezone", this.landDef.getTimeZone().getID());
        writer.nl();
        writer.indent(1);
        writer.attrOut("graveIconURI", this.getGraveIconUri());
        writer.nl();
        writer.indent(1);
        writer.attrOut("generator", JinArchiver.GENERATOR);
        writer.nl();
        writer.append(">");
        writer.nl();
        writer.nl();
        this.dumpAvatarList(writer);
        writer.nl();
        this.dumpPeriodList(writer);
        writer.append("</village>");
        writer.nl();
    }
}

