/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.corelib;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.corelib.Team;

public enum GameRole {
    INNOCENT("\u6751\u4eba", '\u6751', "innocent", Team.VILLAGE, -50),
    WOLF("\u4eba\u72fc", '\u72fc', "wolf", Team.WOLF, 20),
    SEER("\u5360\u3044\u5e2b", '\u5360', "seer", Team.VILLAGE, -30),
    SHAMAN("\u970a\u80fd\u8005", '\u970a', "shaman", Team.VILLAGE, -20),
    MADMAN("\u72c2\u4eba", '\u72c2', "madman", Team.WOLF, 10),
    HUNTER("\u72e9\u4eba", '\u72e9', "hunter", Team.VILLAGE, -10),
    FRATER("\u5171\u6709\u8005", '\u5171', "frater", Team.VILLAGE, -40),
    HAMSTER("\u30cf\u30e0\u30b9\u30bf\u30fc\u4eba\u9593", '\u516c', "hamster", Team.HAMSTER, 0);

    private static final Comparator<GameRole> BALANCE_COMPARATOR;
    private static final Pattern ROLE_PATTERN;
    private final String roleName;
    private final char shortName;
    private final String xmlName;
    private final Team team;
    private final int order;

    private GameRole(String roleName, char shortName, String xmlName, Team team, int order) {
        this.roleName = roleName.intern();
        this.shortName = shortName;
        this.xmlName = xmlName.intern();
        this.team = team;
        this.order = order;
    }

    public static GameRole lookingAtRole(Matcher matcher) {
        matcher.usePattern(ROLE_PATTERN);
        if (!matcher.lookingAt()) {
            return null;
        }
        int groupCt = matcher.groupCount();
        for (int group = 1; group <= groupCt; ++group) {
            if (matcher.start(group) < 0) continue;
            GameRole role = GameRole.values()[group - 1];
            return role;
        }
        return null;
    }

    public static Comparator<GameRole> getPowerBalanceComparator() {
        return BALANCE_COMPARATOR;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public char getShortName() {
        return this.shortName;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public Team getTeam() {
        return this.team;
    }

    private int getOrder() {
        return this.order;
    }

    static {
        BALANCE_COMPARATOR = new PowerBalanceComparator();
        StringBuilder roleRegex = new StringBuilder();
        for (GameRole role : GameRole.values()) {
            if (roleRegex.length() > 0) {
                roleRegex.append('|');
            }
            roleRegex.append('(').append(Pattern.quote(role.getRoleName())).append(')');
        }
        ROLE_PATTERN = Pattern.compile(roleRegex.toString());
    }

    private static final class PowerBalanceComparator
    implements Comparator<GameRole> {
        private PowerBalanceComparator() {
        }

        private static int getPowerValue(GameRole role) {
            if (role == null) {
                return Integer.MIN_VALUE;
            }
            int result = role.getOrder();
            return result;
        }

        @Override
        public int compare(GameRole role1, GameRole role2) {
            int order1 = PowerBalanceComparator.getPowerValue(role1);
            int order2 = PowerBalanceComparator.getPowerValue(role2);
            return order1 - order2;
        }
    }
}

