/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import io.bitbucket.olyutorskii.jiocema.DecodeBreakException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import jp.osdn.jindolf.parser.HtmlAdapter;
import jp.osdn.jindolf.parser.HtmlParseException;
import jp.osdn.jindolf.parser.HtmlParser;
import jp.osdn.jindolf.parser.PageType;
import jp.osdn.jindolf.parser.SeqRange;
import jp.osdn.jindolf.parser.content.DecodedContent;
import jp.sourceforge.jindolf.archiver.Builder;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.LandState;
import jp.sourceforge.jindolf.corelib.PeriodType;

public final class HttpAccess {
    private HttpAccess() {
        assert (false);
        throw new AssertionError();
    }

    public static URL getPeriodListURL(LandDef landDef, int vid) throws IOException {
        StringBuilder urlText = new StringBuilder();
        urlText.append(landDef.getCgiURI().toASCIIString());
        urlText.append('?').append("vid=").append(vid);
        if (landDef.getLandState() == LandState.ACTIVE) {
            urlText.append('&').append("meslog=");
        }
        URL result = new URL(urlText.toString());
        return result;
    }

    public static List<PeriodResource> loadResourceList(LandDef landDef, int vid) throws DecodeBreakException, HtmlParseException, IOException {
        DecodedContent content;
        URL url = HttpAccess.getPeriodListURL(landDef, vid);
        Charset charset = landDef.getEncoding();
        try (InputStream istream = url.openStream();){
            content = Builder.contentFromStream(charset, istream);
        }
        HtmlParser parser = new HtmlParser();
        PeriodListHandler handler = new PeriodListHandler(landDef, vid);
        parser.setBasicHandler(handler);
        parser.setTalkHandler(handler);
        parser.setSysEventHandler(handler);
        parser.parseAutomatic(content);
        List<PeriodResource> result = handler.getResourceList();
        return result;
    }

    public static class PeriodListHandler
    extends HtmlAdapter {
        private final LandDef landDef;
        private final int vid;
        private List<PeriodResource> resourceList = null;
        private int progressDays;
        private boolean hasDone;

        public PeriodListHandler(LandDef landDef, int vid) {
            this.landDef = landDef;
            this.vid = vid;
        }

        public String getURL(PeriodType type, int day) {
            String base = this.landDef.getCgiURI().toASCIIString();
            base = base + "?vid=" + this.vid + "&meslog=";
            String landId = this.landDef.getLandId();
            if ("wolfg".equals(landId)) {
                String dnum = "000" + (day - 1);
                dnum = dnum.substring(dnum.length() - 3);
                switch (type) {
                    case PROLOGUE: {
                        base = base + "000_ready";
                        break;
                    }
                    case PROGRESS: {
                        base = base + dnum;
                        base = base + "_progress";
                        break;
                    }
                    case EPILOGUE: {
                        base = base + dnum;
                        base = base + "_party";
                        break;
                    }
                    default: {
                        assert (false);
                        return null;
                    }
                }
            } else {
                base = base + this.vid + "_";
                switch (type) {
                    case PROLOGUE: {
                        base = base + "ready_0";
                        break;
                    }
                    case PROGRESS: {
                        base = base + "progress_" + (day - 1);
                        break;
                    }
                    case EPILOGUE: {
                        base = base + "party_" + (day - 1);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            base = base + "&mes=all";
            return base;
        }

        public List<PeriodResource> getResourceList() {
            return this.resourceList;
        }

        @Override
        public void startParse(DecodedContent content) throws HtmlParseException {
            this.resourceList = new LinkedList<PeriodResource>();
            this.progressDays = 0;
            this.hasDone = false;
        }

        @Override
        public void pageType(PageType type) throws HtmlParseException {
            if (type != PageType.PERIOD_PAGE) {
                throw new HtmlParseException();
            }
        }

        @Override
        public void periodLink(DecodedContent content, SeqRange anchorRange, PeriodType periodType, int day) throws HtmlParseException {
            if (periodType == null) {
                this.hasDone = true;
            } else if (periodType == PeriodType.PROGRESS) {
                this.progressDays = day;
            }
        }

        @Override
        public void endParse() throws HtmlParseException {
            if (!this.hasDone) {
                throw new HtmlParseException();
            }
            String prologueURI = this.getURL(PeriodType.PROLOGUE, 0);
            PeriodResource resource = new PeriodResource(this.landDef, this.vid, PeriodType.PROLOGUE, 0, prologueURI, 0L, null);
            this.resourceList.add(resource);
            for (int day = 1; day <= this.progressDays; ++day) {
                String progressURI = this.getURL(PeriodType.PROGRESS, day);
                resource = new PeriodResource(this.landDef, this.vid, PeriodType.PROGRESS, day, progressURI, 0L, null);
                this.resourceList.add(resource);
            }
            String epilogueURI = this.getURL(PeriodType.EPILOGUE, this.progressDays + 1);
            resource = new PeriodResource(this.landDef, this.vid, PeriodType.EPILOGUE, this.progressDays + 1, epilogueURI, 0L, null);
            this.resourceList.add(resource);
        }
    }
}

