/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jp.sourceforge.jindolf.archiver.DumpXmlTask;
import jp.sourceforge.jindolf.archiver.ValidateTask;

public class ProdCons {
    private static final int NUM_THREADS = 2;
    private final CompletionService<Void> service = ProdCons.createService();
    private final DumpXmlTask dumpTask;
    private final ValidateTask validateTask;
    private Future<Void> dumpFuture;
    private Future<Void> validFuture;
    private boolean endValidator1st;
    private Throwable cause = null;
    private Callable<Void> causeTask = null;

    public ProdCons(DumpXmlTask dumpTask, ValidateTask validateTask) {
        this.dumpTask = dumpTask;
        this.validateTask = validateTask;
    }

    private static CompletionService<Void> createService() {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<Void> service = new ExecutorCompletionService<Void>(executor);
        return service;
    }

    private static Throwable getReason(Future<?> future) throws IllegalStateException {
        if (!future.isDone()) {
            throw new IllegalStateException();
        }
        Throwable result = null;
        try {
            Object dummyNull = future.get();
            assert (dummyNull == null);
        }
        catch (InterruptedException e) {
            assert (false);
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            result = e.getCause();
        }
        return result;
    }

    public void submit() throws InterruptedException {
        this.validFuture = this.service.submit(this.validateTask);
        this.dumpFuture = this.service.submit(this.dumpTask);
        this.waitTask1st();
        this.waitTask2nd();
    }

    private void waitTask1st() throws InterruptedException {
        Future<Void> future1st = this.service.take();
        this.endValidator1st = future1st == this.validFuture;
        this.cause = ProdCons.getReason(future1st);
        if (this.cause != null) {
            this.causeTask = this.endValidator1st ? this.validateTask : this.dumpTask;
        }
    }

    private void waitTask2nd() throws InterruptedException {
        if (this.cause != null) {
            this.cancel2ndTask();
            return;
        }
        Future<Void> future2nd = this.service.take();
        this.cause = ProdCons.getReason(future2nd);
        if (this.cause != null) {
            this.causeTask = this.endValidator1st ? this.dumpTask : this.validateTask;
        }
    }

    private void cancel2ndTask() throws InterruptedException {
        Future<Void> future2nd = this.endValidator1st ? this.dumpFuture : this.validFuture;
        boolean useInterrupt = true;
        future2nd.cancel(useInterrupt);
        Future<Void> future = this.service.take();
        assert (future == future2nd);
    }

    public boolean hasError() {
        boolean result = this.cause != null;
        return result;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getErrDescription() {
        String desc = this.causeTask == this.validateTask ? ValidateTask.getErrDescription(this.cause) : (this.causeTask == this.dumpTask ? DumpXmlTask.getErrDescription(this.cause) : null);
        return desc;
    }
}

