/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;

public class SnifWriter
extends Writer {
    private static final int SZ_PIPEREAD = 8192;
    private final Writer fout;
    private final Writer pout;
    private final Reader reader;

    public SnifWriter(Writer writer) {
        PipedReader pipeIn;
        PipedWriter pipeOut;
        block3: {
            if (writer == null) {
                throw new NullPointerException();
            }
            this.fout = writer;
            pipeOut = new PipedWriter();
            pipeIn = new PipedReader(8192);
            try {
                pipeOut.connect(pipeIn);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        this.pout = pipeOut;
        this.reader = pipeIn;
    }

    public Reader getSnifReader() {
        return this.reader;
    }

    @Override
    public void close() throws IOException {
        this.fout.close();
        this.pout.close();
    }

    @Override
    public void flush() throws IOException {
        this.fout.flush();
        this.pout.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.fout.write(cbuf, off, len);
        this.pout.write(cbuf, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.fout.write(str, off, len);
        this.pout.write(str, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.fout.write(c);
        this.pout.write(c);
    }
}

