/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.jindolf.parser.content;

import io.bitbucket.olyutorskii.jiocema.DecodeNotifier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CoderResult;
import jp.osdn.jindolf.parser.content.ShiftJis;

public class SjisNotifier
extends DecodeNotifier {
    private static final String MSGFORM_SJBUFLEN = "input buffer length must be 2 or more for Shift_JIS";

    public SjisNotifier() {
        this(2048, 1024);
    }

    public SjisNotifier(int inbufSz, int outbufSz) throws IllegalArgumentException {
        super(ShiftJis.CHARSET.newDecoder(), inbufSz, outbufSz);
        if (inbufSz < 2) {
            throw new IllegalArgumentException(MSGFORM_SJBUFLEN);
        }
    }

    @Override
    protected CoderResult modifyErrorResult(CoderResult errInfo) throws IOException {
        boolean unmapSingle = false;
        boolean unmapDouble = false;
        if (errInfo.isUnmappable()) {
            int errorLength = errInfo.length();
            switch (errorLength) {
                case 1: {
                    unmapSingle = true;
                    break;
                }
                case 2: {
                    unmapDouble = true;
                    break;
                }
            }
        }
        if (unmapDouble) {
            return this.modifyUnmapDoubleError(errInfo);
        }
        boolean detectSjis = false;
        if (this.fillDoubleBytes() && this.isSjisHeadErr()) {
            detectSjis = true;
        }
        CoderResult newResult = detectSjis ? CoderResult.unmappableForLength(2) : (unmapSingle ? CoderResult.malformedForLength(1) : errInfo);
        return newResult;
    }

    private CoderResult modifyUnmapDoubleError(CoderResult errInfo) {
        assert (errInfo.isUnmappable());
        assert (errInfo.length() == 2);
        CoderResult newResult = this.isSjisHeadErr() ? errInfo : CoderResult.malformedForLength(1);
        return newResult;
    }

    private boolean fillDoubleBytes() throws IOException {
        ByteBuffer inbuffer = this.getByteBuffer();
        while (inbuffer.remaining() < 2) {
            if (!this.hasMoreInput()) {
                return false;
            }
            this.supplyInputBytes();
        }
        return true;
    }

    private boolean isSjisHeadErr() {
        ByteBuffer inbuffer = this.getByteBuffer();
        if (inbuffer.remaining() < 2) {
            return false;
        }
        int currPos = inbuffer.position();
        int nextPos = currPos + 1;
        byte curr = inbuffer.get(currPos);
        byte next = inbuffer.get(nextPos);
        boolean result = ShiftJis.isShiftJIS(curr, next);
        return result;
    }
}

